/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Value;

public class LocalizedInstances<T> {
    private final Class<T> clazz;
    private final ResourceBundle.Control cntrl;
    private String staticMethodName;

    public LocalizedInstances(Class<T> clazz, ResourceBundle.Control cntrl) {
        this.clazz = clazz;
        this.cntrl = cntrl;
        this.staticMethodName = null;
    }

    public final Class<T> getClassToUse() {
        return this.clazz;
    }

    public final ResourceBundle.Control getControl() {
        return this.cntrl;
    }

    public final Tuple2<Locale, List<T>> createInstances(String baseName, Locale locale) {
        return this.createInstances(baseName, locale, this.getClassToUse());
    }

    public final Tuple2<Locale, List<T>> createInstances(String baseName, Locale locale, Class<?> cl) {
        ArrayList<T> l = new ArrayList<T>();
        Locale localeRes = null;
        Locale targetLocale = locale;
        while (targetLocale != null && l.isEmpty()) {
            localeRes = targetLocale;
            for (Locale candidate : this.cntrl.getCandidateLocales(baseName, targetLocale)) {
                String bundleName = this.cntrl.toBundleName(baseName, candidate);
                Class<?> loadedClass = this.loadClass(bundleName, cl);
                if (loadedClass != null && this.clazz.isAssignableFrom(loadedClass)) {
                    Class<T> subclazz = loadedClass.asSubclass(this.clazz);
                    try {
                        Value<T> instance = this.getInstance(subclazz);
                        if (instance.hasValue()) {
                            l.add(instance.getValue());
                        } else {
                            Log.get().warning(loadedClass + " exists but the constructor wasn't found");
                        }
                    }
                    catch (Exception e) {
                        Log.get().log(Level.WARNING, "Couldn't create an instance using " + subclazz, e);
                    }
                }
                try {
                    T newInstance = this.createInstance(bundleName, candidate, cl);
                    if (newInstance == null) continue;
                    l.add(newInstance);
                }
                catch (IOException e) {
                    Log.get().log(Level.WARNING, "Couldn't create an instance using " + bundleName, e);
                }
            }
            targetLocale = this.cntrl.getFallbackLocale(baseName, targetLocale);
        }
        return Tuple2.create(localeRes, l);
    }

    private final Class<?> loadClass(String name, Class<?> cl) {
        try {
            return Class.forName(name, true, cl.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public final synchronized LocalizedInstances<T> setStaticMethodName(String staticMethodName) {
        this.staticMethodName = staticMethodName;
        return this;
    }

    public final synchronized String getStaticMethodName() {
        return this.staticMethodName;
    }

    protected <U extends T> Value<U> getInstance(Class<U> subclass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        String staticMethodName = this.getStaticMethodName();
        try {
            if (staticMethodName != null) {
                Method method = subclass.getMethod(staticMethodName, new Class[0]);
                if (Modifier.isStatic(method.getModifiers()) && subclass.isAssignableFrom(method.getReturnType())) {
                    return Value.getSome(subclass.cast(method.invoke(null, new Object[0])));
                }
                return Value.getNone();
            }
            Constructor<U> ctor = subclass.getConstructor(new Class[0]);
            return Value.getSome(ctor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            return Value.getNone();
        }
    }

    protected T createInstance(String bundleName, Locale candidate, Class<?> cl) throws IOException {
        return null;
    }
}

