/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogUtils {
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();

    public static final synchronized Logger getLogger(String name) {
        Logger res = loggers.get(name);
        if (res == null) {
            res = Logger.getLogger(name);
            loggers.put(name, res);
        }
        return res;
    }

    public static final void rmRootHandlers() {
        Logger root = Logger.getLogger("");
        Handler[] handlers = root.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            Handler handler = handlers[i];
            root.removeHandler(handler);
            handler.close();
            ++i;
        }
    }

    public static final void setUpConsoleHandler() {
        Logger rootLogger = Logger.getLogger("");
        Handler ch = null;
        Handler[] handlerArray = rootLogger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            if (h instanceof ConsoleHandler) {
                ch = (ConsoleHandler)h;
            }
            ++n2;
        }
        if (ch == null) {
            ch = new ConsoleHandler();
            rootLogger.addHandler(ch);
        }
        ch.setLevel(Level.ALL);
    }
}

