/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class IScheduledFutureTask<V>
implements RunnableScheduledFuture<V> {
    private final RunnableScheduledFuture<V> delegate;
    private Object inner;

    public IScheduledFutureTask(RunnableScheduledFuture<V> delegate) {
        this.delegate = delegate;
    }

    public final IScheduledFutureTask<V> setInnerRunnable(Runnable inner) {
        if (inner instanceof Callable) {
            throw new IllegalArgumentException("Must call setInnerCallable() to check the generic parameter");
        }
        return this.setInner(inner);
    }

    public final IScheduledFutureTask<V> setInnerCallable(Callable<V> innerCallable) {
        return this.setInner(innerCallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IScheduledFutureTask<V> setInner(Object inner) {
        if (inner == null) {
            throw new NullPointerException();
        }
        IScheduledFutureTask iScheduledFutureTask = this;
        synchronized (iScheduledFutureTask) {
            if (this.inner != null) {
                throw new IllegalStateException("Already set");
            }
            this.inner = inner;
        }
        return this;
    }

    public final Object getInner() {
        return this.inner;
    }

    public final synchronized Runnable getInnerRunnable() {
        return (Runnable)this.inner;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.delegate.getDelay(unit);
    }

    @Override
    public void run() {
        if (this.getInner() == null) {
            throw new IllegalStateException("Inner callable not set");
        }
        this.delegate.run();
    }

    @Override
    public boolean isPeriodic() {
        return this.delegate.isPeriodic();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.delegate.compareTo(o);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }
}

