/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import org.openconcerto.utils.Log;

public class ExceptionUtils {
    public static <T extends Exception> T createExn(Class<T> exnClass, String msg, Throwable cause) {
        Exception instance = null;
        try {
            Constructor<T> ctor = exnClass.getConstructor(String.class);
            instance = (Exception)ctor.newInstance(msg);
        }
        catch (Exception exn) {
            throw new IllegalArgumentException(exnClass + " has no working String constructor");
        }
        instance.initCause(cause);
        return (T)instance;
    }

    public static <T extends Throwable, X extends T, Y extends T> X throwExn(T toThrow, Class<X> classX, Class<Y> classY) throws X, Y {
        if (classX.isInstance(toThrow)) {
            throw (Throwable)classX.cast(toThrow);
        }
        throw (Throwable)classY.cast(toThrow);
    }

    public static String getStackTrace(Throwable cause) {
        StringWriter res = new StringWriter(128);
        PrintWriter pw = new PrintWriter(res);
        try {
            cause.printStackTrace(pw);
        }
        finally {
            pw.close();
        }
        if (pw.checkError()) {
            Log.get().warning("Error while writing " + cause);
        }
        return res.toString();
    }
}

