/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public final class ValueChangeSupport<T> {
    private final ValueWrapper<T> vw;
    private final PropertyChangeSupport supp;
    private final List<ValidListener> validListeners;
    private ValidState valid;
    private boolean signalInvalid;

    public ValueChangeSupport(ValueWrapper<T> vw) {
        this.vw = vw;
        this.validListeners = new ArrayList<ValidListener>();
        this.supp = new PropertyChangeSupport(vw);
        this.valid = null;
        this.signalInvalid = true;
    }

    public final void fireValueChange() {
        ValidState newValid = this.vw.getValidState();
        if (newValid.isValid()) {
            this.supp.firePropertyChange("value", null, this.vw.getValue());
        } else if (this.signalInvalid) {
            this.supp.firePropertyChange("invalidValue", null, null);
        }
        this.setValid(newValid);
    }

    private final void setValid(ValidState newValid) {
        if (!newValid.equals(this.valid)) {
            this.valid = newValid;
            for (ValidListener l : this.validListeners) {
                l.validChange(this.vw, this.valid);
            }
        }
    }
}

