/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.config;

import com.jcraft.jsch.Session;
import java.io.File;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.ProductInfo;

public abstract class ComptaBasePropsConfiguration
extends PropsConfiguration {
    private int idSociete = -1;
    private SQLRow rowSociete = null;
    private DBRoot baseSociete;
    private Thread sslThread = null;

    public static File getConfFile(String appName) {
        return ComptaBasePropsConfiguration.getConfFile(appName, new File("."));
    }

    public static File getConfFile(String appName, File wd) {
        String confFilePath = System.getProperty("gestion.confFile");
        File wdFile = new File(wd + "/Configuration", "main.properties");
        File confFile = confFilePath != null ? new File(confFilePath) : (wdFile.isFile() ? wdFile : new File(DesktopEnvironment.getDE().getPreferencesFolder(appName), "main.properties"));
        return confFile;
    }

    public ComptaBasePropsConfiguration(Properties props, ProductInfo productInfo) {
        super(props);
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        this.setLoggersLevel();
        this.setProductInfo(productInfo);
        String name = "ilm";
        if (this.getProperty("systemRoot.rootsToMap") == null) {
            this.setProperty("systemRoot.rootsToMap", String.valueOf(name) + "_Common");
            this.setProperty("systemRoot.rootPath", String.valueOf(name) + "_Common");
        }
    }

    @Override
    protected void afterSSLConnect(final Session conn) {
        if (conn.isConnected()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        do {
                            Thread.sleep(1000L);
                        } while (conn.isConnected());
                        JOptionPane.showMessageDialog(null, "Coupure r\u00e9seau", "Liaison s\u00e9curis\u00e9e d\u00e9connect\u00e9e!\nV\u00e9rifiez votre connexion internet et relancez le logiciel.", 0);
                        System.exit(1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t.setDaemon(true);
            t.setName("SSL connection watcher");
            t.start();
            assert (this.sslThread == null);
            this.sslThread = t;
        } else {
            ExceptionHandler.die("Impossible d'\u00e9tablir la liaison s\u00e9curis\u00e9e!\nV\u00e9rifiez votre connexion internet et relancez le logiciel.");
        }
    }

    @Override
    public void destroy() {
        if (this.sslThread != null) {
            this.sslThread.interrupt();
            this.sslThread = null;
        }
        super.destroy();
    }

    @Override
    protected PropsConfiguration.FileMode getFileMode() {
        return PropsConfiguration.FileMode.NORMAL_FILE;
    }

    public final String getSocieteBaseName() {
        return this.getRowSociete().getString("DATABASE_NAME");
    }

    public final SQLRow getRowSociete() {
        return this.rowSociete;
    }

    public final int getSocieteID() {
        return this.idSociete;
    }

    protected final void setRowSociete(int id) {
        this.idSociete = id;
        this.rowSociete = this.getSystemRoot().findTable("SOCIETE_COMMON").getValidRow(this.getSocieteID());
    }

    public final DBRoot getRootSociete() {
        if (this.baseSociete == null && this.rowSociete != null) {
            this.baseSociete = this.createSQLBaseSociete();
        }
        return this.baseSociete;
    }

    private DBRoot createSQLBaseSociete() {
        DBSystemRoot b = this.getSystemRoot();
        String societeBaseName = this.getSocieteBaseName();
        b.addRootToMap(societeBaseName);
        try {
            b.reload(Collections.singleton(societeBaseName));
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not access societe base", e);
        }
        b.prependToRootPath(societeBaseName);
        return b.getRoot(societeBaseName);
    }
}

