/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;

public class SQLCreateTable
extends SQLCreateTableBase<SQLCreateTable> {
    private final DBRoot b;
    private boolean createID;
    private boolean createOrder;
    private boolean createArchive;

    public SQLCreateTable(DBRoot b, String name) {
        super(b.getServer().getSQLSystem().getSyntax(), b.getName(), name);
        this.b = b;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.setPlain(false);
    }

    public final DBRoot getRoot() {
        return this.b;
    }

    public final void setPlain(boolean b) {
        this.setCreateID(!b);
        this.setCreateOrder(!b);
        this.setCreateArchive(!b);
    }

    public final boolean isCreateID() {
        return this.createID;
    }

    public final void setCreateID(boolean createID) {
        this.createID = createID;
    }

    public final boolean isCreateOrder() {
        return this.createOrder;
    }

    public final void setCreateOrder(boolean createOrder) {
        this.createOrder = createOrder;
    }

    public final boolean isCreateArchive() {
        return this.createArchive;
    }

    public final void setCreateArchive(boolean createArchive) {
        this.createArchive = createArchive;
    }

    public SQLCreateTable addForeignColumn(String foreignTable) {
        return this.addForeignColumn(foreignTable, "");
    }

    public SQLCreateTable addForeignColumn(String foreignTableN, String suffix) {
        String fk = "ID_" + foreignTableN + (suffix.length() == 0 ? "" : "_" + suffix);
        SQLTable foreignTable = this.b.getTable(foreignTableN);
        if (foreignTable == null) {
            throw new IllegalArgumentException("Unknown table in " + this.b + " : " + foreignTableN);
        }
        return (SQLCreateTable)this.addForeignColumn(fk, foreignTable, true);
    }

    @Override
    public List<String> getPrimaryKey() {
        return !this.isCreateID() ? super.getPrimaryKey() : Collections.singletonList("ID");
    }

    @Override
    protected void checkPK() {
        if (this.isCreateID()) {
            throw new IllegalStateException("can only set primary key in plain mode, otherwise it is automatically added");
        }
    }

    @Override
    protected void modifyClauses(List<String> genClauses) {
        if (this.isCreateID()) {
            genClauses.add(0, String.valueOf(SQLBase.quoteIdentifier("ID")) + this.getSyntax().getPrimaryIDDefinition());
        }
        if (this.isCreateArchive()) {
            genClauses.add(String.valueOf(SQLBase.quoteIdentifier("ARCHIVE")) + this.getSyntax().getArchiveDefinition());
        }
        if (this.isCreateOrder()) {
            if (this.getSyntax().getSystem() == SQLSystem.MSSQL) {
                genClauses.add(String.valueOf(SQLBase.quoteIdentifier("ORDRE")) + this.getSyntax().getOrderType() + " DEFAULT " + this.getSyntax().getOrderDefault());
            } else {
                genClauses.add(String.valueOf(SQLBase.quoteIdentifier("ORDRE")) + this.getSyntax().getOrderDefinition());
            }
        }
    }

    @Override
    protected void modifyOutClauses(List<ChangeTable.DeferredClause> clauses) {
        super.modifyOutClauses(clauses);
        if (this.isCreateOrder() && this.getSyntax().getSystem() == SQLSystem.MSSQL) {
            clauses.add(this.createUniquePartialIndex("orderIdx", Collections.singletonList("ORDRE"), null));
        }
    }
}

