/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ReOrder;

final class ReOrderMySQL
extends ReOrder {
    public ReOrderMySQL(SQLTable t, ReOrder.Spec spec) {
        super(t, spec);
    }

    @Override
    public List<String> getSQL(Connection conn, BigDecimal inc) {
        SQLField oF = this.t.getOrderField();
        ArrayList<String> res = new ArrayList<String>();
        res.add("SELECT " + inc.toPlainString() + " into @inc");
        res.add(this.t.getBase().quote("UPDATE %f SET %n =  -%n " + this.getWhere(), this.t, oF, oF));
        res.add("SET @o := " + this.getFirstOrderValue() + "- @inc");
        res.add(this.getLoop(oF, String.valueOf(this.isFirstToReorderInclusive() ? "<=" : "<") + this.getFirstToReorder().negate().toPlainString(), oF, "DESC"));
        if (this.isAll()) {
            res.add(this.getLoop(oF, "is null", this.t.getKey(), "ASC"));
        }
        return res;
    }

    private String getLoop(SQLField oF, String cond, SQLField orderBy, String way) {
        return this.t.getBase().quote("UPDATE %f SET %n = ( @o := @o + @inc ) where %n " + cond + " ORDER BY %n " + way, this.t, oF, oF, orderBy);
    }
}

