/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.users.rights.LockAdminUserRight;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple2;

public class UserRightsManager {
    private static UserRightsManager instance;
    private static final ListMap<String, Tuple2<String, Boolean>> SUPERUSER_RIGHTS;
    private static final ListMap<String, Tuple2<String, Boolean>> NO_RIGHTS;
    public static final List<MacroRight> DEFAULT_MACRO_RIGHTS;
    private final Map<String, MacroRight> macroRights;
    private final Map<Integer, ListMap<String, Tuple2<String, Boolean>>> rights;
    private final SQLTable table;
    private SQLTableModifiedListener tableL;
    private final ListMap javaRights;

    static {
        SUPERUSER_RIGHTS = ListMap.singleton(null, Tuple2.create(null, true));
        NO_RIGHTS = ListMap.singleton(null, Tuple2.create(null, false));
        DEFAULT_MACRO_RIGHTS = Collections.synchronizedList(new ArrayList());
        DEFAULT_MACRO_RIGHTS.add(new LockAdminUserRight());
        DEFAULT_MACRO_RIGHTS.add(new TableAllRights(true));
        DEFAULT_MACRO_RIGHTS.add(new TableAllRights(false));
    }

    public static synchronized UserRightsManager setInstanceIfNone(DBRoot root) {
        if (instance != null) {
            return null;
        }
        return UserRightsManager.setInstanceFromRoot(root);
    }

    public static synchronized boolean clearInstanceIfSame(UserRightsManager urMngr) {
        if (instance == urMngr) {
            UserRightsManager.setInstance(null);
            return true;
        }
        return false;
    }

    public static UserRightsManager setInstanceFromRoot(DBRoot root) {
        return UserRightsManager.setInstance(root.findTable("USER_RIGHT", false));
    }

    public static synchronized UserRightsManager setInstance(SQLTable t) {
        SQLTable currentTable;
        SQLTable sQLTable = currentTable = instance == null ? null : instance.getTable();
        if (currentTable != t) {
            if (instance != null) {
                instance.destroy();
            }
            instance = t == null ? null : new UserRightsManager(t);
        }
        return UserRightsManager.getInstance();
    }

    public static synchronized UserRightsManager getInstance() {
        return instance;
    }

    private UserRightsManager(SQLTable t) {
        if (t == null) {
            throw new NullPointerException("Missing table");
        }
        this.macroRights = new HashMap<String, MacroRight>();
        this.rights = new HashMap<Integer, ListMap<String, Tuple2<String, Boolean>>>();
        this.javaRights = new ListMap();
        this.table = t;
        this.tableL = new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                UserRightsManager.this.rightsInvalid();
            }
        };
        this.table.addTableModifiedListener(this.tableL);
        this.defaultRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultRegister() {
        List<MacroRight> list = DEFAULT_MACRO_RIGHTS;
        synchronized (list) {
            for (MacroRight macroRight : DEFAULT_MACRO_RIGHTS) {
                this.register(macroRight);
            }
        }
    }

    public void register(MacroRight userRight) {
        this.macroRights.put(userRight.getCode(), userRight);
    }

    public final synchronized boolean isValid() {
        return this.tableL != null;
    }

    public final synchronized void destroy() {
        if (this.isValid()) {
            this.getTable().removeTableModifiedListener(this.tableL);
            this.tableL = null;
        }
        assert (!this.isValid());
    }

    public final SQLTable getTable() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rightsInvalid() {
        Map<Integer, ListMap<String, Tuple2<String, Boolean>>> map = this.rights;
        synchronized (map) {
            this.rights.clear();
        }
    }
}

