/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.TransactionPoint;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.utils.cache.CacheItem;
import org.openconcerto.utils.cache.CacheWatcher;

public class SQLCacheWatcher
extends CacheWatcher<SQLData> {
    private final SQLTable.ListenerAndConfig listener;

    SQLCacheWatcher(SQLData t) {
        super(t);
        this.listener = new SQLTable.ListenerAndConfig(t.createTableListener(new SQLDataListener(){

            @Override
            public void dataChanged(SQLTableEvent evt) {
                SQLCacheWatcher.this.dataChanged(evt);
            }
        }), null);
    }

    @Override
    protected boolean changedBy(CacheItem<?, ?, ? extends SQLData> val, Object event) {
        boolean transactionCommitted;
        SQLCache sqlCache = (SQLCache)val.getCache();
        TransactionPoint cacheTxPoint = sqlCache.getTransactionPoint();
        SQLTableEvent evt = (SQLTableEvent)event;
        TransactionPoint evtTxPoint = evt.getTransactionPoint();
        boolean bl = transactionCommitted = evtTxPoint == null || evtTxPoint.getTransaction().getState() == TransactionPoint.State.COMMITTED;
        if (cacheTxPoint != null) {
            return transactionCommitted || sqlCache.changedBy(evtTxPoint);
        }
        return transactionCommitted;
    }

    private final SQLTable getTable() {
        return ((SQLData)this.getData()).getTable();
    }

    @Override
    protected void startWatching() {
        this.getTable().addPremierTableModifiedListener(this.listener);
    }

    @Override
    protected void stopWatching() {
        this.getTable().removeTableModifiedListener(this.listener);
    }
}

