/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.replication;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.CSVHandler;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.ThreadFactory;

public class MemoryRep {
    private static final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(MemoryRep.class.getName(), true));
    private final DBSystemRoot master;
    private final DBSystemRoot slave;
    private final TablesMap tables;
    private ScheduledFuture<?> future;
    private Future<?> manualFuture;
    private short canceledCount;
    private final AtomicInteger count;

    public final synchronized boolean hasStopped() {
        return this.future != null && this.future.isCancelled();
    }

    public final synchronized Future<?> submitReplicate() {
        boolean canceled = this.manualFuture != null && this.canceledCount < 10 ? this.manualFuture.cancel(true) : false;
        this.canceledCount = canceled ? (short)(this.canceledCount + 1) : (short)0;
        this.manualFuture = exec.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MemoryRep.this.replicateData();
                return null;
            }
        });
        return this.manualFuture;
    }

    private final synchronized Future<?> getManualFuture() {
        return this.manualFuture;
    }

    public final void waitOnLastManualFuture() throws InterruptedException, ExecutionException {
        Future<?> f = this.getManualFuture();
        boolean done = false;
        while (!done) {
            try {
                f.get();
                done = true;
            }
            catch (CancellationException e) {
                if (this.hasStopped()) {
                    done = true;
                } else {
                    Future<?> old = f;
                    boolean bl = done = old == (f = this.getManualFuture());
                }
                if (!done) continue;
                throw e;
            }
        }
    }

    protected final void replicateData() throws SQLException, IOException, InterruptedException {
        final SQLSyntax slaveSyntax = SQLSyntax.get(this.slave);
        File tempDir = FileUtils.createTempDir(String.valueOf(this.getClass().getCanonicalName()) + "_StoreData");
        try {
            final ArrayList<String> queries = new ArrayList<String>();
            final ArrayList<IResultSetHandler> handlers = new ArrayList<IResultSetHandler>();
            final HashMap files = new HashMap();
            for (Map.Entry e : this.tables.entrySet()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("While creating handlers");
                }
                String rootName = (String)e.getKey();
                final File rootDir = new File(tempDir, rootName);
                FileUtils.mkdir_p(rootDir);
                DBRoot root = this.master.getRoot(rootName);
                final DBRoot slaveRoot = this.slave.getRoot(rootName);
                for (final String tableName : (Set)e.getValue()) {
                    SQLTable masterT = root.getTable(tableName);
                    SQLSelect select = new SQLSelect(true).addSelectStar(masterT);
                    queries.add(select.asString());
                    handlers.add(new IResultSetHandler(new ResultSetHandler(masterT){
                        private final CSVHandler csvH;
                        {
                            this.csvH = new CSVHandler(sQLTable.getOrderedFields());
                        }

                        @Override
                        public Object handle(ResultSet rs) throws SQLException {
                            File tempFile = new File(rootDir, String.valueOf(FileUtils.FILENAME_ESCAPER.escape(tableName)) + ".csv");
                            if (!$assertionsDisabled && tempFile.exists()) {
                                throw new AssertionError();
                            }
                            try {
                                FileUtils.write(this.csvH.handle(rs), tempFile);
                                files.put(tempFile, slaveRoot.getTable(tableName));
                            }
                            catch (IOException e) {
                                throw new SQLException(e);
                            }
                            return null;
                        }
                    }, false));
                }
            }
            try {
                SQLUtils.executeAtomic(this.master.getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                    @Override
                    public Object handle(SQLDataSource ds) throws SQLException {
                        SQLUtils.executeMultiple(MemoryRep.this.master, queries, handlers);
                        return null;
                    }
                });
            }
            catch (RTInterruptedException e) {
                InterruptedException exn = new InterruptedException("Interrupted while querying the master");
                exn.initCause(e);
                throw exn;
            }
            SQLUtils.executeAtomic(this.slave.getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException, IOException {
                    for (Map.Entry e : files.entrySet()) {
                        SQLTable slaveT = (SQLTable)e.getValue();
                        slaveSyntax.loadData((File)e.getKey(), slaveT, true);
                    }
                    return null;
                }
            });
            this.count.incrementAndGet();
        }
        finally {
            FileUtils.rm_R(tempDir);
        }
    }
}

