/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.AbstractPath;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;

public final class Path
extends AbstractPath<Path> {
    private final List<SQLTable> tables;
    private final List<Step> steps;
    private final List<SQLField> singleFields;

    public static Path get(SQLTable first) {
        return new Path(first);
    }

    public Path(SQLTable start) {
        this.tables = Collections.singletonList(start);
        this.steps = Collections.emptyList();
        this.singleFields = Collections.emptyList();
    }

    public Path(Step step) {
        this.tables = Arrays.asList(step.getFrom(), step.getTo());
        this.steps = Collections.singletonList(step);
        this.singleFields = Collections.singletonList(step.getSingleField());
    }

    private Path(List<SQLTable> tables, List<Step> steps, List<SQLField> singleFields) {
        this.tables = tables;
        this.steps = steps;
        this.singleFields = singleFields;
    }

    public final Path reverse() {
        int stepsCount = this.steps.size();
        if (stepsCount == 0) {
            return this;
        }
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>(stepsCount + 1);
        ArrayList<Step> steps = new ArrayList<Step>(stepsCount);
        ArrayList<SQLField> singleFields = new ArrayList<SQLField>(stepsCount);
        int i = stepsCount - 1;
        while (i >= 0) {
            Step reversedStep = this.steps.get(i).reverse();
            tables.add(reversedStep.getFrom());
            steps.add(reversedStep);
            singleFields.add(reversedStep.getSingleField());
            --i;
        }
        tables.add(this.getFirst());
        return new Path(Collections.unmodifiableList(tables), Collections.unmodifiableList(steps), Collections.unmodifiableList(singleFields));
    }

    public Path minusFirst() {
        return this.subPath(1);
    }

    public Path minusLast() {
        return this.minusLast(1);
    }

    public Path minusLast(int count) {
        return this.subPath(0, -count);
    }

    public Path subPath(int fromIndex) {
        return this.subPath(fromIndex, this.length());
    }

    public Path subPath(int fromIndex, int toIndex) {
        fromIndex = CollectionUtils.getValidIndex(this.steps, fromIndex, true);
        toIndex = CollectionUtils.getValidIndex(this.steps, toIndex, true);
        if (fromIndex == 0 && toIndex == this.length()) {
            return this;
        }
        return new Path(this.tables.subList(fromIndex, toIndex + 1), this.steps.subList(fromIndex, toIndex), this.singleFields.subList(fromIndex, toIndex));
    }

    @Override
    public List<SQLTable> getTables() {
        return this.tables;
    }

    @Override
    protected final Path _append(Path p) {
        int thisLength = this.length();
        int oLength = p.length();
        if (thisLength == 0) {
            return p;
        }
        if (oLength == 0) {
            return this;
        }
        int stepsCount = thisLength + oLength;
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>(stepsCount + 1);
        ArrayList<Step> steps = new ArrayList<Step>(stepsCount);
        ArrayList<SQLField> singleFields = new ArrayList<SQLField>(stepsCount);
        tables.addAll(this.tables.subList(0, thisLength));
        tables.addAll(p.tables);
        steps.addAll(this.steps);
        steps.addAll(p.steps);
        singleFields.addAll(this.singleFields);
        singleFields.addAll(p.singleFields);
        return new Path(Collections.unmodifiableList(tables), Collections.unmodifiableList(steps), Collections.unmodifiableList(singleFields));
    }

    public final Path add(Step step) {
        return (Path)this.append(new Path(step));
    }

    @Override
    public final List<Step> getSteps() {
        return this.steps;
    }

    public final Step getStep(int i) {
        return this.steps.get(CollectionUtils.getValidIndex(this.steps, i, true));
    }

    public SQLField getSingleField(int i) {
        return this.singleFields.get(i);
    }

    public boolean isSingleField() {
        for (SQLField step : this.singleFields) {
            if (step != null) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleLink() {
        for (Step step : this.steps) {
            if (step.isSingleLink()) continue;
            return false;
        }
        return true;
    }

    public final Boolean isBackwards(int i) {
        Boolean foreign = this.getStep(i).isForeign();
        return foreign == null ? null : Boolean.valueOf(foreign == false);
    }

    public final Link.Direction getDirection() {
        HashSet<Link.Direction> directions = new HashSet<Link.Direction>(this.steps.size());
        for (Step s : this.steps) {
            directions.add(s.getDirection());
        }
        return (Link.Direction)((Object)CollectionUtils.getSole(directions));
    }

    public final boolean isDirection(Link.Direction dir) {
        if (dir == null) {
            throw new NullPointerException("Null direction");
        }
        return this.length() == 0 || this.getDirection() == dir;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeClassName) {
        StringBuilder sb = new StringBuilder(128);
        if (includeClassName) {
            sb.append(this.getClass().getSimpleName());
            sb.append(" ");
        }
        sb.append(this.getFirst());
        for (Step step : this.steps) {
            sb.append(" ");
            step.linksToString(sb);
            sb.append(" ");
            sb.append(step.getTo());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Path o = (Path)obj;
            return this.getFirst().equals(o.getFirst()) && this.steps.equals(o.steps);
        }
        return false;
    }

    public int hashCode() {
        return this.steps.hashCode();
    }

    public boolean startsWith(Path other) {
        int otherL = other.length();
        if (otherL == 0) {
            return this.getFirst() == other.getFirst();
        }
        return this.length() >= otherL && this.subPath(0, otherL).equals(other);
    }
}

