/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TransactionPoint;

public class SQLTableEvent {
    private final SQLTable table;
    private final SQLRow row;
    private final Mode mode;
    private final List<String> fieldNames;
    private final List<SQLField> fields;
    private final TransactionPoint txPoint;
    private SQLRowValues vals;

    public SQLTableEvent(SQLTable table, int id, Mode mode, Collection<String> fields) {
        this(table, id < 0 ? null : new SQLRow(table, id), mode, fields);
    }

    public SQLTableEvent(SQLRow row, Mode mode, Collection<String> fields) {
        this(row.getTable(), row, mode, fields);
    }

    private SQLTableEvent(SQLTable table, SQLRow row, Mode mode, Collection<String> fields) {
        this(table, row, mode, fields, table.getDBSystemRoot().getDataSource().getTransactionPoint());
    }

    private SQLTableEvent(SQLTable table, SQLRow row, Mode mode, Collection<String> fields, TransactionPoint txPoint) {
        this.table = table;
        this.row = row;
        this.mode = mode;
        if (fields == null) {
            this.fieldNames = new ArrayList<String>(this.getTable().getFieldsName());
            this.fields = new ArrayList<SQLField>(this.getTable().getFields());
        } else {
            this.fieldNames = new ArrayList<String>(new LinkedHashSet<String>(fields));
            this.fields = new ArrayList<SQLField>(this.fieldNames.size());
            for (String fieldName : this.fieldNames) {
                this.fields.add(this.getTable().getField(fieldName));
            }
        }
        this.txPoint = txPoint;
    }

    public final TransactionPoint getTransactionPoint() {
        return this.txPoint;
    }

    final SQLTableEvent opposite() {
        return new SQLTableEvent(this.table, this.row == null ? null : new SQLRow(this.table, this.row.getID()), this.mode.opposite(), this.fieldNames, this.txPoint);
    }

    public final List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public final SQLRow getRow() {
        return this.row;
    }

    public final SQLRowValues getRowValues() {
        if (this.vals == null) {
            this.vals = this.getRow().asRowValues();
        }
        return this.vals;
    }

    final void setRowValues(SQLRowValues vals) {
        if (this.vals != null) {
            throw new IllegalStateException("already set to " + this.vals);
        }
        if (this.getId() != vals.getID()) {
            throw new IllegalArgumentException("incoherent ID: " + this.getId() + " != " + vals.getID());
        }
        assert (new SQLRowValues(vals, SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM).asRow().getAbsolutelyAll().equals(this.getRow().getAbsolutelyAll()));
        this.vals = vals;
    }

    public final int getId() {
        return this.getRow() == null ? -1 : this.getRow().getID();
    }

    public final Mode getMode() {
        return this.mode;
    }

    public final SQLTable getTable() {
        return this.table;
    }

    public String toString() {
        return "in " + this.getTable() + " " + (Object)((Object)this.getMode()) + " " + this.getId();
    }

    public static enum Mode {
        ROW_ADDED{

            @Override
            public Mode opposite() {
                return ROW_DELETED;
            }
        }
        ,
        ROW_DELETED{

            @Override
            public Mode opposite() {
                return ROW_ADDED;
            }
        }
        ,
        ROW_UPDATED{

            @Override
            public Mode opposite() {
                return this;
            }
        };


        public abstract Mode opposite();
    }
}

