/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.dbcp.DelegatingConnection;
import org.openconcerto.sql.changer.correct.FixSerial;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.PGSQLBase;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.postgresql.PGConnection;

class SQLSyntaxPG
extends SQLSyntax {
    private static final Pattern NOW_PTRN = Pattern.compile("\\(?'now'::text\\)?(::timestamp)");

    SQLSyntaxPG() {
        super(SQLSystem.POSTGRESQL);
        this.typeNames.addAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.addAll(Short.class, "smallint");
        this.typeNames.addAll(Integer.class, "integer", "int", "int4");
        this.typeNames.addAll(Long.class, "bigint", "int8");
        this.typeNames.addAll(BigDecimal.class, "decimal", "numeric");
        this.typeNames.addAll(Float.class, "real", "float4");
        this.typeNames.addAll(Double.class, "double precision", "float8");
        this.typeNames.addAll(Timestamp.class, "timestamp", "timestamp without time zone");
        this.typeNames.addAll(Date.class, "time", "time without time zone", "date");
        this.typeNames.addAll(Blob.class, "bytea");
        this.typeNames.addAll(Clob.class, "varchar", "char", "character varying", "character", "text");
        this.typeNames.addAll(String.class, "varchar", "char", "character varying", "character", "text");
    }

    @Override
    public int getMaximumIdentifierLength() {
        return 63;
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return Tuple2.create(false, "::");
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public String getAuto() {
        return " serial";
    }

    @Override
    public int getMaximumVarCharLength() {
        return 0xFFFFFFF;
    }

    @Override
    public List<Map<String, Object>> getIndexInfo(SQLTable t) throws SQLException {
        String query = "SELECT NULL AS \"TABLE_CAT\",  n.nspname as \"TABLE_SCHEM\",\nct.relname as \"TABLE_NAME\", NOT i.indisunique AS \"NON_UNIQUE\",\nNULL AS \"INDEX_QUALIFIER\", ci.relname as \"INDEX_NAME\",\nNULL as \"TYPE\", col.attnum as \"ORDINAL_POSITION\",\nCASE WHEN i.indexprs IS NULL THEN col.attname ELSE pg_get_indexdef(ci.oid,col.attnum,false) END AS \"COLUMN_NAME\",\nNULL AS \"ASC_OR_DESC\", ci.reltuples as \"CARDINALITY\", ci.relpages as \"PAGES\",\npg_get_expr(i.indpred,ct.oid) as \"FILTER_CONDITION\"\nFROM pg_catalog.pg_class ct\n     JOIN pg_catalog.pg_namespace n ON n.oid = ct.relnamespace\n     JOIN pg_catalog.pg_index i ON ct.oid=i.indrelid\n     JOIN pg_catalog.pg_class ci ON ci.oid=i.indexrelid\n     JOIN pg_catalog.pg_attribute col ON col.attrelid = ci.oid\nWHERE ci.relkind IN ('i','') AND n.nspname <> 'pg_catalog' AND n.nspname !~ '^pg_toast'\n AND n.nspname = " + t.getBase().quoteString(t.getSchema().getName()) + " AND ct.relname = " + t.getBase().quoteString(t.getName()) + "\n" + "ORDER BY \"NON_UNIQUE\", \"TYPE\", \"INDEX_NAME\", \"ORDINAL_POSITION\";";
        return (List)t.getDBSystemRoot().getDataSource().execute(query, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
    }

    protected String setNullable(SQLField f, boolean b) {
        return "ALTER COLUMN " + f.getQuotedName() + " " + (b ? "DROP" : "SET") + " NOT NULL";
    }

    @Override
    public Map<ChangeTable.ClauseType, List<String>> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        ArrayList<String> res = new ArrayList<String>();
        if (toAlter.contains((Object)SQLField.Properties.NULLABLE)) {
            res.add(this.setNullable(f, nullable));
        }
        if (toAlter.contains((Object)SQLField.Properties.TYPE)) {
            String newType = type;
            res.add("ALTER COLUMN " + f.getQuotedName() + " TYPE " + newType);
        } else {
            String newType = this.getType(f);
        }
        if (toAlter.contains((Object)SQLField.Properties.DEFAULT)) {
            res.add(this.setDefault(f, defaultVal));
        }
        return ListMap.singleton(ChangeTable.ClauseType.ALTER_COL, res);
    }

    @Override
    protected String getCreateIndex(String cols, SQLName tableName, SQLTable.SQLIndex i) {
        String method = i.getMethod() != null ? " USING " + i.getMethod() : "";
        return "ON " + tableName.quote() + " " + method + cols;
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        if (f.getDefaultValue() != null && Date.class.isAssignableFrom(f.getType().getJavaType())) {
            return NOW_PTRN.matcher(f.getDefaultValue().toString()).replaceAll("CURRENT_TIMESTAMP$1");
        }
        return super.transfDefaultJDBC2SQL(f);
    }

    @Override
    public void _loadData(final File f, SQLTable t) throws IOException, SQLException {
        final String copy = "COPY " + t.getSQLName().quote() + " FROM STDIN " + SQLSyntaxPG.getDataOptions(t.getBase()) + ";";
        Number count = t.getDBSystemRoot().getDataSource().useConnection(new ConnectionHandlerNoSetup<Number, IOException>(){

            @Override
            public Number handle(SQLDataSource ds) throws SQLException, IOException {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    Connection conn = ((DelegatingConnection)ds.getConnection()).getInnermostDelegate();
                    Long l = ((PGConnection)((Object)conn)).getCopyAPI().copyIn(copy, in);
                    return l;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        });
        SQLName seq = FixSerial.getPrimaryKeySeq(t);
        if (count.intValue() != 0 && seq != null) {
            t.getDBSystemRoot().getDataSource().execute(t.getBase().quote("select %n.\"alterSeq\"( %s, 'select max(%n)+1 from %f');", t.getDBRoot(), seq, t.getKey(), t));
        }
    }

    private static String getDataOptions(SQLBase b) {
        return " WITH NULL " + b.quoteString("\\N") + " CSV HEADER QUOTE " + b.quoteString("\"") + " ESCAPE AS " + b.quoteString("\\");
    }

    @Override
    public String getFormatTimestamp(String sqlTS, boolean basic) {
        return "to_char(cast(" + sqlTS + " as timestamp), " + SQLBase.quoteStringStd(basic ? "YYYYMMDD\"T\"HH24MISS.US" : "YYYY-MM-DD\"T\"HH24:MI:SS.US") + ")";
    }

    @Override
    public SQLBase createBase(SQLServer server, String name, IClosure<? super DBSystemRoot> systemRootInit, String login, String pass, IClosure<? super SQLDataSource> dsInit) {
        return new PGSQLBase(server, name, systemRootInit, login, pass, dsInit);
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "SELECT ROUTINE_SCHEMA as \"schema\", ROUTINE_NAME as \"name\", ROUTINE_DEFINITION as \"src\" FROM \"information_schema\".ROUTINES where ROUTINE_CATALOG='" + b.getMDName() + "' and ROUTINE_SCHEMA in (" + SQLSyntaxPG.quoteStrings(b, schemas) + ")";
    }

    @Override
    public String getTriggerQuery(SQLBase b, TablesMap tables) throws SQLException {
        return "SELECT tgname as \"TRIGGER_NAME\", n.nspname as \"TABLE_SCHEMA\", c.relname as \"TABLE_NAME\", tgfoid as \"ACTION\", pg_get_triggerdef(t.oid) as \"SQL\" \nFROM pg_catalog.pg_trigger t\nINNER JOIN pg_catalog.pg_class c on t.tgrelid = c.oid\nINNER JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n" + this.getTablesMapJoin(b, tables, "n.nspname", "c.relname") + "\nwhere not t." + (b.getVersion()[0] >= 9 ? "tgisinternal" : "tgisconstraint");
    }

    @Override
    public String getColumnsQuery(SQLBase b, TablesMap tables) {
        return "SELECT TABLE_SCHEMA as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", TABLE_NAME as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", COLUMN_NAME as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , CHARACTER_SET_NAME as \"CHARACTER_SET_NAME\", COLLATION_NAME as \"COLLATION_NAME\" from INFORMATION_SCHEMA.COLUMNS\n" + this.getTablesMapJoin(b, tables, "TABLE_SCHEMA", "TABLE_NAME");
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, TablesMap tables) throws SQLException {
        String sel = "select nsp.nspname as \"TABLE_SCHEMA\", rel.relname as \"TABLE_NAME\", c.conname as \"CONSTRAINT_NAME\", c.oid as cid, \ncase c.contype when 'u' then 'UNIQUE' when 'c' then 'CHECK' when 'f' then 'FOREIGN KEY' when 'p' then 'PRIMARY KEY' end as \"CONSTRAINT_TYPE\", att.attname as \"COLUMN_NAME\", pg_get_constraintdef(c.oid) as \"DEFINITION\",c.conkey as \"colsNum\", att.attnum as \"colNum\"\nfrom pg_catalog.pg_constraint c\njoin pg_namespace nsp on nsp.oid = c.connamespace\nleft join pg_class rel on rel.oid = c.conrelid\nleft join pg_attribute att on  att.attrelid = c.conrelid and att.attnum = ANY(c.conkey)\n" + this.getTablesMapJoin(b, tables, "nsp.nspname", "rel.relname") + "\norder by nsp.nspname, rel.relname, c.conname";
        List<Map<String, Object>> res = this.sort((List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false)));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    private List<Map<String, Object>> sort(List<Map<String, Object>> sortedByConstraint) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(sortedByConstraint.size());
        Comparator<Map<String, Object>> comp = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return CompareUtils.compareInt(this.getIndex(o1), this.getIndex(o2));
            }

            private final int getIndex(Map<String, Object> o) {
                int colNum = ((Number)o.get("colNum")).intValue();
                try {
                    Object[] array = (Integer[])((Array)o.get("colsNum")).getArray();
                    int i = 0;
                    while (i < array.length) {
                        if (array[i] == colNum) {
                            return i;
                        }
                        ++i;
                    }
                    throw new IllegalStateException(String.valueOf(colNum) + " was not found in " + Arrays.toString(array));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        int prevID = -1;
        ArrayList<Map<String, Object>> currentConstr = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> m : sortedByConstraint) {
            int currentID = ((Number)m.get("cid")).intValue();
            if (currentConstr.size() > 0 && currentID != prevID) {
                res.addAll(this.sort(currentConstr, comp));
                currentConstr.clear();
            }
            currentConstr.add(m);
            prevID = currentID;
        }
        res.addAll(this.sort(currentConstr, comp));
        return res;
    }

    private final List<Map<String, Object>> sort(List<Map<String, Object>> currentConstr, Comparator<Map<String, Object>> comp) {
        Collections.sort(currentConstr, comp);
        int i = 0;
        while (i < currentConstr.size()) {
            currentConstr.get(i).put("ORDINAL_POSITION", i + 1);
            currentConstr.get(i).remove("cid");
            currentConstr.get(i).remove("colNum");
            currentConstr.get(i).remove("colsNum");
            ++i;
        }
        return currentConstr;
    }
}

