/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntaxH2;
import org.openconcerto.sql.model.SQLSyntaxMS;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSyntaxPG;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public abstract class SQLSyntax {
    private static final Map<SQLSystem, SQLSyntax> instances = new HashMap<SQLSystem, SQLSyntax>();
    private static final StringUtils.Escaper DEFAULT_LIKE_ESCAPER = new StringUtils.Escaper('\\', '\\');
    private final SQLSystem sys;
    protected final ListMap<Class<?>, String> typeNames;
    private static final Set<String> nonStandardTimeFunctions;
    public static final List<String> INFO_SCHEMA_NAMES_KEYS;

    static {
        SQLSyntax.register(new SQLSyntaxPG());
        SQLSyntax.register(new SQLSyntaxH2());
        SQLSyntax.register(new SQLSyntaxMySQL());
        SQLSyntax.register(new SQLSyntaxMS());
        DEFAULT_LIKE_ESCAPER.add('_', '_');
        DEFAULT_LIKE_ESCAPER.add('%', '%');
        nonStandardTimeFunctions = CollectionUtils.createSet("now()", "transaction_timestamp()", "current_timestamp()", "getdate()");
        INFO_SCHEMA_NAMES_KEYS = Arrays.asList("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME");
    }

    private static void register(SQLSyntax s) {
        instances.put(s.getSystem(), s);
    }

    public static final SQLSyntax get(DBStructureItem<?> sql) {
        return SQLSyntax.get(sql.getServer().getSQLSystem());
    }

    public static final SQLSyntax get(SQLSystem system) {
        SQLSyntax res = instances.get((Object)system);
        if (res == null) {
            throw new IllegalArgumentException("unsupported system: " + (Object)((Object)system));
        }
        return res;
    }

    protected SQLSyntax(SQLSystem sys) {
        this.sys = sys;
        this.typeNames = new ListMap();
    }

    public final Collection<String> getTypeNames(Class<?> clazz) {
        return this.typeNames.getNonNull(clazz);
    }

    public final SQLSystem getSystem() {
        return this.sys;
    }

    public abstract int getMaximumIdentifierLength();

    public abstract String getAuto();

    public String getIDType() {
        return " int";
    }

    public String getPrimaryIDDefinitionShort() {
        return this.getAuto();
    }

    public final String getPrimaryIDDefinition() {
        return String.valueOf(this.getPrimaryIDDefinitionShort()) + " PRIMARY KEY";
    }

    public String getArchiveType() {
        return " int";
    }

    public String getArchiveDefinition() {
        return String.valueOf(this.getArchiveType()) + " DEFAULT 0 NOT NULL";
    }

    public final String getOrderType() {
        return " DECIMAL(" + this.getOrderPrecision() + "," + this.getOrderScale() + ")";
    }

    public final int getOrderPrecision() {
        return 16;
    }

    public final int getOrderScale() {
        return 8;
    }

    public final Object getOrderDefault() {
        return null;
    }

    public final boolean isOrder(SQLField f) {
        SQLType type = f.getType();
        if (type.getType() != 3 && type.getType() != 2) {
            return false;
        }
        if (type.getSize() != this.getOrderPrecision() || ((Number)type.getDecimalDigits()).intValue() != this.getOrderScale()) {
            return false;
        }
        return f.isNullable() != false && CompareUtils.equals(f.getDefaultValue(), this.getOrderDefault());
    }

    public final String getOrderDefinition() {
        return String.valueOf(this.getOrderType()) + " DEFAULT " + this.getOrderDefault() + " UNIQUE";
    }

    public String getFK(String tableName, List<String> fk, SQLName refTable, List<String> referencedFields, Link.Rule updateRule, Link.Rule deleteRule) {
        String onDelete;
        String onUpdate = updateRule == null ? "" : " ON UPDATE " + this.getRuleSQL(updateRule);
        String string = onDelete = deleteRule == null ? "" : " ON DELETE " + this.getRuleSQL(deleteRule);
        if (tableName == null) {
            throw new NullPointerException("Null tableName");
        }
        String name = String.valueOf(tableName) + '_' + CollectionUtils.join(fk, "__") + "_fkey";
        String boundedName = StringUtils.getBoundedLengthString(name, this.getMaximumIdentifierLength());
        return "CONSTRAINT " + SQLBase.quoteIdentifier(boundedName) + " FOREIGN KEY ( " + SQLSyntax.quoteIdentifiers(fk) + " ) REFERENCES " + refTable.quote() + " ( " + SQLSyntax.quoteIdentifiers(referencedFields) + " )" + onUpdate + onDelete;
    }

    protected String getRuleSQL(Link.Rule r) {
        return r.asString();
    }

    public String getCreateIndex(String indexSuffix, SQLName tableName, List<String> fields) {
        return this.getCreateIndex(false, String.valueOf(tableName.getName()) + "_" + CollectionUtils.join(fields, "__") + indexSuffix, tableName, fields);
    }

    public final String getCreateIndex(boolean unique, String indexName, SQLName tableName, List<String> fields) {
        String res = "CREATE" + (unique ? " UNIQUE" : "") + " INDEX " + SQLBase.quoteIdentifier(indexName) + " ON " + tableName.quote();
        return String.valueOf(res) + " (" + SQLSyntax.quoteIdentifiers(fields) + ");";
    }

    public final ChangeTable.OutsideClause getCreateIndex(final SQLTable.SQLIndex i) {
        return new ChangeTable.OutsideClause(){

            @Override
            public ChangeTable.ClauseType getType() {
                return ChangeTable.ClauseType.ADD_INDEX;
            }

            @Override
            public String asString(SQLName tableName) {
                boolean neededButUnsupported;
                String indexName = SQLSyntax.getSchemaUniqueName(tableName.getName(), i.getName());
                String res = "CREATE" + (i.isUnique() ? " UNIQUE" : "") + " INDEX " + SQLBase.quoteIdentifier(indexName) + " ";
                String exprs = CollectionUtils.join(i.getAttrs(), ", ");
                res = String.valueOf(res) + SQLSyntax.this.getCreateIndex("(" + exprs + ")", tableName, i);
                if (i.getFilter() != null && i.getFilter().length() > 0) {
                    res = String.valueOf(res) + " WHERE " + i.getFilter();
                    neededButUnsupported = !SQLSyntax.this.getSystem().isIndexFilterConditionSupported();
                } else {
                    neededButUnsupported = false;
                }
                res = String.valueOf(res) + ";";
                if (neededButUnsupported) {
                    res = "-- filter condition not supported\n-- " + res;
                    Log.get().warning(res);
                }
                return res;
            }
        };
    }

    protected String getCreateIndex(String cols, SQLName tableName, SQLTable.SQLIndex i) {
        return "ON " + tableName.quote() + cols;
    }

    public String getCreateTableSuffix() {
        return "";
    }

    public final String getFieldDecl(String sqlType, String sqlDefault, boolean nullable) {
        return String.valueOf(sqlType) + this.getDefaultClause(sqlDefault) + this.getNullableClause(nullable);
    }

    protected final boolean getNullable(SQLField f) {
        return !Boolean.FALSE.equals(f.isNullable());
    }

    public final String getNullableClause(boolean nullable) {
        return nullable ? " " : " NOT NULL ";
    }

    protected final String getDefault(SQLField f, String sqlType) {
        if (!this.supportsDefault(sqlType)) {
            return null;
        }
        String stdDefault = SQLSyntax.getNormalizedDefault(f);
        return stdDefault == null ? null : this.transfDefault(f, stdDefault);
    }

    static final String getNormalizedDefault(SQLField f) {
        SQLSyntax fs = f.getServer().getSQLSystem().getSyntax();
        String stdDefault = fs.transfDefaultSQL2Common(f);
        if (stdDefault == null) {
            return null;
        }
        Tuple2<Boolean, String> cast = fs.getCast();
        String castless = cast == null ? stdDefault : SQLSyntax.remove(stdDefault, fs.getTypeNames(f.getType().getJavaType()), cast.get0(), cast.get1());
        return castless;
    }

    private static String remove(String s, Collection<String> substrings, boolean leading, String sep) {
        String lowerS = s.toLowerCase();
        String typeCast = null;
        for (String syn : substrings) {
            typeCast = syn.toLowerCase();
            typeCast = leading ? String.valueOf(typeCast) + sep : String.valueOf(sep) + typeCast;
            if (leading ? lowerS.startsWith(typeCast) : lowerS.endsWith(typeCast)) break;
            typeCast = null;
        }
        if (typeCast == null) {
            return s;
        }
        if (leading) {
            return s.substring(typeCast.length());
        }
        return s.substring(0, s.length() - typeCast.length());
    }

    public final String getDefaultClause(String def) {
        if (def == null) {
            return " ";
        }
        return " DEFAULT " + def;
    }

    public final String getType(SQLField f) {
        String sqlType;
        SQLSyntax fs = f.getServer().getSQLSystem().getSyntax();
        SQLType t = f.getType();
        String typeName = t.getTypeName().toLowerCase();
        if (typeName.contains("clob")) {
            sqlType = "text";
        } else if (Date.class.isAssignableFrom(t.getJavaType())) {
            sqlType = fs.isAutoDate(f) && this.getAutoDateType(f) != null ? this.getAutoDateType(f) : (typeName.contains("datetime") || typeName.contains("timestamp") ? String.valueOf(this.getDateAndTimeType()) + (this.getSystem().isFractionalSecondsSupported() && t.getDecimalDigits() != null ? "(" + t.getDecimalDigits() + ")" : "") : typeName);
        } else if (t.getJavaType() == String.class) {
            if (typeName.contains("text") || typeName.contains("clob")) {
                sqlType = "text";
            } else {
                String type = typeName.contains("var") ? "varchar" : "char";
                int size = t.getSize();
                if (size < Integer.MAX_VALUE) {
                    sqlType = String.valueOf(type) + "(" + size + ")";
                } else {
                    Log.get().warning("Unbounded varchar for " + f.getSQLName());
                    if (this.getSystem() == SQLSystem.MYSQL) {
                        throw new IllegalStateException("MySQL doesn't support unbounded varchar and might truncate data if reducing size of " + f.getSQLName());
                    }
                    sqlType = type;
                }
            }
        } else {
            sqlType = t.getJavaType() == BigDecimal.class ? "DECIMAL(" + t.getSize() + "," + t.getDecimalDigits() + ")" : (t.getJavaType() == Boolean.class ? this.getBooleanType() : (Number.class.isAssignableFrom(t.getJavaType()) ? (Double.class.isAssignableFrom(t.getJavaType()) ? "double precision" : (Float.class.isAssignableFrom(t.getJavaType()) ? "real" : typeName.replace("unsigned", "").replace("int2", "smallint").replace("integer", "int").replace("int4", "int").replace("int8", "bigint").trim())) : typeName));
        }
        return sqlType;
    }

    private boolean isAutoDate(SQLField f) {
        if (f.getDefaultValue() == null) {
            return false;
        }
        String def = SQLSyntax.getNormalizedDefault(f).toLowerCase();
        return Date.class.isAssignableFrom(f.getType().getJavaType()) && (def.contains("now") || def.contains("current_"));
    }

    protected String getAutoDateType(SQLField f) {
        return null;
    }

    public String getDateAndTimeType() {
        return "timestamp";
    }

    public String getBooleanType() {
        return "boolean";
    }

    public abstract int getMaximumVarCharLength();

    protected boolean supportsDefault(String sqlType) {
        return true;
    }

    protected String transfDefault(SQLField f, String castless) {
        return castless;
    }

    private String transfDefaultSQL2Common(SQLField f) {
        String defaultVal = this.transfDefaultJDBC2SQL(f);
        if (defaultVal != null && Date.class.isAssignableFrom(f.getType().getJavaType()) && nonStandardTimeFunctions.contains(defaultVal.trim().toLowerCase())) {
            return "CURRENT_TIMESTAMP";
        }
        if (defaultVal != null && Boolean.class.isAssignableFrom(f.getType().getJavaType())) {
            return defaultVal.toUpperCase();
        }
        return defaultVal;
    }

    public String transfDefaultJDBC2SQL(SQLField f) {
        return f.getDefaultValue();
    }

    protected abstract Tuple2<Boolean, String> getCast();

    public List<Map<String, Object>> getIndexInfo(final SQLTable t) throws SQLException {
        List indexesInfo = (List)t.getDBSystemRoot().getDataSource().useConnection(new ConnectionHandlerNoSetup<List<?>, SQLException>(){

            @Override
            public List<?> handle(SQLDataSource ds) throws SQLException {
                return (List)SQLDataSource.MAP_LIST_HANDLER.handle(ds.getConnection().getMetaData().getIndexInfo(t.getBase().getMDName(), t.getSchema().getName(), t.getName(), false, false));
            }
        });
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(indexesInfo.size());
        for (Object o : indexesInfo) {
            Map m = (Map)o;
            if (String.valueOf(0).equals(m.get("TYPE").toString())) continue;
            res.add(this.normalizeIndexInfo(m));
        }
        return res;
    }

    protected Map<String, Object> normalizeIndexInfo(Map<?, ?> m) {
        throw new UnsupportedOperationException();
    }

    protected final Map<String, Object> copyIndexInfoMap(Map<?, ?> m) {
        HashMap<String, Object> res = new HashMap<String, Object>(m.size());
        for (Map.Entry<?, ?> e : m.entrySet()) {
            res.put(((String)e.getKey()).toUpperCase(), e.getValue());
        }
        return res;
    }

    protected final String setDefault(SQLField field, String defaut) {
        if (defaut == null) {
            return "ALTER " + field.getQuotedName() + " DROP DEFAULT";
        }
        return "ALTER COLUMN " + field.getQuotedName() + " SET DEFAULT " + defaut;
    }

    public abstract Map<ChangeTable.ClauseType, List<String>> getAlterField(SQLField var1, Set<SQLField.Properties> var2, String var3, String var4, Boolean var5);

    public String getDecimal(int precision, int scale) {
        return " DECIMAL(" + precision + "," + scale + ")";
    }

    public final void loadData(File f, SQLTable t, boolean delete) throws IOException, SQLException {
        this.loadData(f, t, delete, null);
    }

    public final void loadData(File f, SQLTable t, boolean delete, Level level) throws IOException, SQLException {
        if (level != null) {
            Log.get().log(level, "loading " + f + " into " + t.getSQLName() + "... ");
        }
        if (delete) {
            t.getBase().getDataSource().execute("DELETE FROM " + t.getSQLName().quote());
        }
        this._loadData(f, t);
        t.fireTableModified(-1);
        if (level != null) {
            Log.get().log(level, "done loading " + f);
        }
    }

    protected abstract void _loadData(File var1, SQLTable var2) throws IOException, SQLException;

    protected boolean isServerLocalhost(SQLServer s) {
        return NetUtils.isSelfAddr(s.getName());
    }

    protected final void checkServerLocalhost(DBStructureItem<?> t) {
        if (!this.isServerLocalhost(t.getServer())) {
            throw new IllegalArgumentException("the server of " + t + " is not this computer: " + t.getServer());
        }
    }

    SQLBase createBase(SQLServer server, String name, IClosure<? super DBSystemRoot> systemRootInit, String login, String pass, IClosure<? super SQLDataSource> dsInit) {
        return new SQLBase(server, name, systemRootInit, login, pass, dsInit);
    }

    public boolean supportMultiAlterClause() {
        return true;
    }

    public String getNullIsDataComparison(String x, boolean eq, String y) {
        return String.valueOf(x) + (eq ? " IS NOT DISTINCT FROM " : " IS DISTINCT FROM ") + y;
    }

    public abstract String getFormatTimestamp(String var1, boolean var2);

    public final String getInsertOne(SQLName tableName, List<String> fields, String ... values) {
        return this.getInsertOne(tableName, fields, Arrays.asList(values));
    }

    public final String getInsertOne(SQLName tableName, List<String> fields, List<String> values) {
        return this.getInsert(tableName, fields, Collections.singletonList(values));
    }

    public final String getInsert(SQLName tableName, List<String> fields, List<List<String>> values) {
        return "INSERT INTO " + tableName.quote() + "(" + SQLSyntax.quoteIdentifiers(fields) + ") " + this.getValues(values, fields.size());
    }

    public final String getValues(List<List<String>> rows, int colCount) {
        int rowCount = rows.size();
        if (rowCount < 1) {
            throw new IllegalArgumentException("Empty rows will cause a syntax error");
        }
        if (colCount < 0) {
            colCount = rows.get(0).size();
        }
        StringBuilder sb = new StringBuilder(rowCount * 64);
        char space = rowCount > 6 ? (char)'\n' : ' ';
        sb.append("VALUES");
        sb.append(space);
        for (List<String> row : rows) {
            if (row.size() != colCount) {
                throw new IllegalArgumentException("Row have wrong size, not " + colCount + " : " + row);
            }
            sb.append("(");
            sb.append(CollectionUtils.join(row, ", "));
            sb.append("),");
            sb.append(space);
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public String getConstantTable(List<List<String>> rows, String alias, List<String> columnsAlias) {
        int colSize = columnsAlias.size();
        if (colSize < 1) {
            throw new IllegalArgumentException("Empty columns will cause a syntax error");
        }
        StringBuilder sb = new StringBuilder(rows.size() * 64);
        sb.append("( ");
        sb.append(this.getValues(rows, colSize));
        sb.append(" ) as ");
        sb.append(SQLBase.quoteIdentifier(alias));
        sb.append(" (");
        for (String colAlias : columnsAlias) {
            sb.append(SQLBase.quoteIdentifier(colAlias));
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(")");
        return sb.toString();
    }

    protected final String getTablesMapJoin(SQLBase b, TablesMap tables, String schemaExpr, String tableExpr) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (Map.Entry e : tables.entrySet()) {
            String schemaName = b.quoteString((String)e.getKey());
            if (e.getValue() == null) {
                rows.add(Arrays.asList(schemaName, "NULL"));
                continue;
            }
            for (String tableName : (Set)e.getValue()) {
                rows.add(Arrays.asList(schemaName, b.quoteString(tableName)));
            }
        }
        String tableAlias = "tables";
        SQLName schemaName = new SQLName("tables", "schema");
        SQLName tableName = new SQLName("tables", "table");
        String schemaWhere = String.valueOf(schemaExpr) + " = " + schemaName.quote();
        String tableWhere = "(" + tableName.quote() + " is null or " + tableExpr + " = " + tableName.quote() + ")";
        return "INNER JOIN " + this.getConstantTable(rows, "tables", Arrays.asList(schemaName.getName(), tableName.getName())) + " on " + schemaWhere + " and " + tableWhere;
    }

    public abstract String getColumnsQuery(SQLBase var1, TablesMap var2);

    public abstract String getFunctionQuery(SQLBase var1, Set<String> var2);

    public abstract List<Map<String, Object>> getConstraints(SQLBase var1, TablesMap var2) throws SQLException;

    protected static final String quoteStrings(final SQLBase b, Collection<String> c) {
        return CollectionUtils.join(c, ", ", new ITransformer<String, String>(){

            public String transformChecked(String s) {
                return b.quoteString(s);
            }
        });
    }

    public static final String quoteIdentifiers(Collection<String> c) {
        return CollectionUtils.join(c, ", ", new ITransformer<String, String>(){

            public String transformChecked(String s) {
                return SQLBase.quoteIdentifier(s);
            }
        });
    }

    public static final String getSchemaUniqueName(String tableName, String name) {
        return name.startsWith(tableName) ? name : String.valueOf(tableName) + "_" + name;
    }

    public abstract String getTriggerQuery(SQLBase var1, TablesMap var2) throws SQLException;

    public String getUpdate(SQLTable t, List<String> tables, Map<String, String> setPart) throws UnsupportedOperationException {
        String res = String.valueOf(t.getSQLName().quote()) + " SET\n" + CollectionUtils.join(setPart.entrySet(), ",\n", new ITransformer<Map.Entry<String, String>, String>(){

            public String transformChecked(Map.Entry<String, String> input) {
                return String.valueOf(SQLBase.quoteIdentifier(input.getKey())) + " = " + input.getValue();
            }
        });
        if (tables.size() > 0) {
            res = String.valueOf(res) + " FROM " + CollectionUtils.join(tables, ", ");
        }
        return res;
    }

    public static enum ConstraintType {
        CHECK,
        FOREIGN_KEY("FOREIGN KEY"),
        PRIMARY_KEY("PRIMARY KEY"),
        UNIQUE,
        DEFAULT;

        private final String sqlName;

        private ConstraintType() {
            this(null);
        }

        private ConstraintType(String n2) {
            this.sqlName = n2 == null ? this.name() : n2;
        }

        public final String getSqlName() {
            return this.sqlName;
        }

        public static ConstraintType find(String sqlName) {
            ConstraintType[] constraintTypeArray = ConstraintType.values();
            int n = constraintTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConstraintType c = constraintTypeArray[n2];
                if (c.getSqlName().equals(sqlName)) {
                    return c;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unknown type: " + sqlName);
        }
    }
}

