/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.AliasedTables;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.FromClause;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public final class SQLSelect {
    public static final ArchiveMode UNARCHIVED = ArchiveMode.UNARCHIVED;
    public static final ArchiveMode ARCHIVED = ArchiveMode.ARCHIVED;
    public static final ArchiveMode BOTH = ArchiveMode.BOTH;
    private final List<String> select;
    private final List<String> selectNames;
    private final List<FieldRef> selectFields;
    private Where where;
    private final List<FieldRef> groupBy;
    private Where having;
    private final List<String> order;
    private final FromClause from;
    private final AliasedTables declaredTables;
    private final Set<String> joinAliases;
    private final List<SQLSelectJoin> joins;
    private boolean generalExcludeUndefined;
    private final Map<SQLTable, Boolean> excludeUndefined;
    private final Map<SQLTable, ArchiveMode> archivedPolicy;
    private boolean distinct;
    private LockStrength lockStrength;
    private final List<String> waitTrxTables;
    private Integer limit;
    private int offset;

    public static final String quote(String pattern, Object ... params) {
        return SQLBase.quoteStd(pattern, params);
    }

    @Deprecated
    public SQLSelect(SQLBase base) {
        this(base, false);
    }

    @Deprecated
    public SQLSelect(SQLBase base, boolean plain) {
        this(base.getDBSystemRoot(), plain);
    }

    public SQLSelect() {
        this(false);
    }

    public SQLSelect(boolean plain) {
        this((DBSystemRoot)null, plain);
    }

    public SQLSelect(DBSystemRoot sysRoot, boolean plain) {
        this.select = new ArrayList<String>();
        this.selectNames = new ArrayList<String>();
        this.selectFields = new ArrayList<FieldRef>();
        this.where = null;
        this.groupBy = new ArrayList<FieldRef>();
        this.having = null;
        this.order = new ArrayList<String>();
        this.from = new FromClause();
        this.declaredTables = new AliasedTables(sysRoot);
        this.joinAliases = new HashSet<String>();
        this.joins = new ArrayList<SQLSelectJoin>();
        this.distinct = false;
        this.excludeUndefined = new HashMap<SQLTable, Boolean>();
        this.archivedPolicy = new HashMap<SQLTable, ArchiveMode>();
        this.lockStrength = LockStrength.NONE;
        this.waitTrxTables = new ArrayList<String>();
        this.limit = null;
        this.offset = 0;
        if (plain) {
            this.generalExcludeUndefined = false;
            this.setArchivedPolicy(BOTH);
        } else {
            this.generalExcludeUndefined = true;
            this.setArchivedPolicy(UNARCHIVED);
        }
        assert (this.archivedPolicy.containsKey(null));
    }

    public SQLSelect(SQLSelect orig) {
        this.select = new ArrayList<String>(orig.select);
        this.selectNames = new ArrayList<String>(orig.selectNames);
        this.selectFields = new ArrayList<FieldRef>(orig.selectFields);
        this.where = orig.where;
        this.groupBy = new ArrayList<FieldRef>(orig.groupBy);
        this.having = orig.having;
        this.order = new ArrayList<String>(orig.order);
        this.from = new FromClause(orig.from);
        this.declaredTables = new AliasedTables(orig.declaredTables);
        this.joinAliases = new HashSet<String>(orig.joinAliases);
        this.joins = new ArrayList<SQLSelectJoin>(orig.joins);
        this.generalExcludeUndefined = orig.generalExcludeUndefined;
        this.excludeUndefined = new HashMap<SQLTable, Boolean>(orig.excludeUndefined);
        this.archivedPolicy = new HashMap<SQLTable, ArchiveMode>(orig.archivedPolicy);
        this.distinct = orig.distinct;
        this.lockStrength = orig.lockStrength;
        this.waitTrxTables = new ArrayList<String>(orig.waitTrxTables);
        this.limit = orig.limit;
        this.offset = orig.offset;
    }

    final DBSystemRoot getSystemRoot() {
        DBSystemRoot sysRoot = this.declaredTables.getSysRoot();
        if (sysRoot == null) {
            throw new IllegalStateException("No systemRoot supplied (neither in the constructor nor by adding an item)");
        }
        return sysRoot;
    }

    public final SQLSystem getSQLSystem() {
        return this.getSystemRoot().getServer().getSQLSystem();
    }

    public String asString() {
        SQLSystem sys = this.getSQLSystem();
        StringBuffer result = new StringBuffer(512);
        result.append("SELECT ");
        if (this.distinct) {
            result.append("DISTINCT ");
        }
        result.append(CollectionUtils.join(this.select, ", "));
        result.append("\n " + this.from.getSQL());
        Where archive = this.where;
        Collection<String> fromAliases = CollectionUtils.substract(this.declaredTables.getAliases(), this.joinAliases);
        for (String alias : fromAliases) {
            SQLTable fromTable = this.declaredTables.getTable(alias);
            archive = Where.and(this.getArchiveWhere(fromTable, alias), archive);
            archive = Where.and(this.getUndefWhere(fromTable, alias), archive);
        }
        if (archive != null && archive.getClause() != "") {
            result.append("\n WHERE ");
            result.append(archive.getClause());
        }
        if (!this.groupBy.isEmpty()) {
            result.append("\n GROUP BY ");
            result.append(CollectionUtils.join(this.groupBy, ", ", new ITransformer<FieldRef, String>(){

                public String transformChecked(FieldRef input) {
                    return input.getFieldRef();
                }
            }));
        }
        if (this.having != null) {
            result.append("\n HAVING ");
            result.append(this.having.getClause());
        }
        if (!this.order.isEmpty()) {
            result.append("\n ORDER BY ");
            result.append(CollectionUtils.join(this.order, ", "));
        }
        if (this.getLimit() != null || this.getOffset() != 0) {
            if (sys == SQLSystem.MSSQL) {
                result.append("\nOFFSET ");
                result.append(this.getOffset());
                result.append(" ROWS");
                if (this.getLimit() != null) {
                    result.append(" FETCH NEXT ");
                    result.append(this.getLimit());
                    result.append(" ROWS ONLY");
                }
            } else {
                Object actualLimit = this.getLimit() != null ? this.getLimit() : (sys == SQLSystem.H2 ? "NULL" : (sys == SQLSystem.POSTGRESQL ? "ALL" : Integer.valueOf(Integer.MAX_VALUE)));
                result.append("\nLIMIT ");
                result.append(actualLimit);
                result.append(" OFFSET ");
                result.append(this.getOffset());
            }
        }
        if (this.lockStrength != LockStrength.NONE) {
            if (sys.equals((Object)SQLSystem.POSTGRESQL)) {
                result.append(this.lockStrength == LockStrength.SHARE ? " FOR SHARE" : " FOR UPDATE");
                if (this.waitTrxTables.size() > 0) {
                    result.append(" OF " + CollectionUtils.join(this.waitTrxTables, ", "));
                }
            } else if (sys.equals((Object)SQLSystem.MYSQL)) {
                result.append(this.lockStrength == LockStrength.SHARE ? " LOCK IN SHARE MODE" : " FOR UPDATE");
            } else if (sys.equals((Object)SQLSystem.H2)) {
                result.append(" FOR UPDATE");
            } else {
                throw new IllegalStateException("Unsupported system : " + (Object)((Object)sys));
            }
        }
        return result.toString();
    }

    Where getArchiveWhere(SQLTable table, String alias) {
        Where res;
        ArchiveMode m;
        ArchiveMode archiveMode = m = this.archivedPolicy.containsKey(table) ? this.archivedPolicy.get(table) : this.archivedPolicy.get(null);
        assert (m != null) : "no default policy";
        if (m == BOTH) {
            res = null;
        } else if (table.isArchivable()) {
            Comparable<Boolean> archiveValue = table.getArchiveField().getType().getJavaType().equals(Boolean.class) ? (Comparable<Boolean>)Boolean.valueOf(m == ARCHIVED) : (Comparable<Boolean>)Integer.valueOf(m == ARCHIVED ? 1 : 0);
            res = new Where(this.createRef(alias, table.getArchiveField()), "=", (Object)archiveValue);
        } else {
            res = m == ARCHIVED ? Where.FALSE : null;
        }
        return res;
    }

    Where getUndefWhere(SQLTable table, String alias) {
        Boolean exclude = this.excludeUndefined.get(table);
        Where res = table.isRowable() && (exclude == Boolean.TRUE || exclude == null && this.generalExcludeUndefined) ? new Where(this.createRef(alias, table.getKey()), "!=", table.getUndefinedID()) : null;
        return res;
    }

    public String toString() {
        return this.asString();
    }

    public final List<FieldRef> getSelectFields() {
        return Collections.unmodifiableList(this.selectFields);
    }

    public Where getWhere() {
        return this.where;
    }

    public final boolean contains(String alias) {
        return this.declaredTables.contains(alias);
    }

    private final void addIfNotExist(TableRef t) {
        if (this.declaredTables.add(t, false)) {
            this.from.add(t);
        }
    }

    public SQLSelect addGroupBy(FieldRef f) {
        this.groupBy.add(f);
        return this;
    }

    public SQLSelect addOrder(TableRef t, boolean fieldMustExist) {
        SQLField orderField = t.getTable().getOrderField();
        if (orderField != null) {
            this.addFieldOrder(t.getField(orderField.getName()));
        } else if (fieldMustExist) {
            throw new IllegalArgumentException("table is not ordered : " + t);
        }
        return this;
    }

    public SQLSelect addFieldOrder(FieldRef fieldRef) {
        return this.addFieldOrder(fieldRef, Order.asc());
    }

    public SQLSelect addFieldOrder(FieldRef fieldRef, Order.Direction dir) {
        return this.addFieldOrder(fieldRef, dir, null);
    }

    public SQLSelect addFieldOrder(FieldRef fieldRef, Order.Direction dir, Order.Nulls nulls) {
        if (fieldRef.getField().getServer().getSQLSystem().equals((Object)SQLSystem.DERBY)) {
            this.addSelect(fieldRef);
        }
        return this.addRawOrder(String.valueOf(fieldRef.getFieldRef()) + dir.getSQL() + (nulls == null ? "" : nulls.getSQL()));
    }

    public SQLSelect addRawOrder(String selectItem) {
        this.order.add(selectItem);
        return this;
    }

    public SQLSelect addSelect(FieldRef f) {
        return this.addSelect(f, null);
    }

    public SQLSelect addSelect(FieldRef f, String function) {
        return this.addSelect(f, function, null);
    }

    public SQLSelect addSelect(FieldRef f, String function, String alias) {
        String defaultAlias;
        String s = f.getFieldRef();
        if (function != null) {
            s = String.valueOf(function) + "(" + s + ")";
            defaultAlias = function;
        } else {
            defaultAlias = f.getField().getName();
        }
        return this.addRawSelect(f, s, alias, defaultAlias);
    }

    public SQLSelect addRawSelect(String expr, String alias) {
        return this.addRawSelect(null, expr, alias, null);
    }

    private SQLSelect addRawSelect(FieldRef f, String expr, String alias, String defaultName) {
        if (alias != null) {
            expr = String.valueOf(expr) + " as " + SQLBase.quoteIdentifier(alias);
        }
        this.select.add(expr);
        if (f != null) {
            this.addIfNotExist(f.getTableRef());
        }
        this.selectFields.add(f);
        this.selectNames.add(alias != null ? alias : defaultName);
        return this;
    }

    public SQLSelect addSelectFunctionStar(String function) {
        return this.addRawSelect(String.valueOf(function) + "(*)", null);
    }

    public SQLSelect addSelectStar(TableRef table) {
        this.select.add(String.valueOf(SQLBase.quoteIdentifier(table.getAlias())) + ".*");
        this.addIfNotExist(table);
        List<SQLField> allFields = table.getTable().getOrderedFields();
        this.selectFields.addAll(allFields);
        for (SQLField f : allFields) {
            this.selectNames.add(f.getName());
        }
        return this;
    }

    public SQLSelect addFrom(SQLTable table, String alias) {
        return this.addFrom(AliasedTable.getTableRef(table, alias));
    }

    public SQLSelect addFrom(TableRef t) {
        this.addIfNotExist(t);
        return this;
    }

    public SQLSelect setWhere(Where w) {
        this.where = w;
        if (w != null) {
            for (FieldRef f : w.getFields()) {
                this.addIfNotExist(f.getTableRef());
            }
        }
        return this;
    }

    public SQLSelect andWhere(Where w) {
        return this.setWhere(Where.and(this.getWhere(), w));
    }

    public SQLSelectJoin addJoin(String joinType, String existingAlias, Step s, String joinedAlias) {
        TableRef existingTable = this.getTableRef(existingAlias != null ? existingAlias : s.getFrom().getName());
        AliasedTable joinedTable = new AliasedTable(s.getTo(), joinedAlias);
        return this.addJoin(new SQLSelectJoin(this, joinType, existingTable, s, joinedTable));
    }

    public SQLSelectJoin addBackwardJoin(String joinType, String joinAlias, SQLField ff, String foreignTableAlias) {
        return this.addBackwardJoin(joinType, new AliasedField(ff, joinAlias), foreignTableAlias);
    }

    public SQLSelectJoin addBackwardJoin(String joinType, FieldRef ff, String foreignTableAlias) {
        Step s = Step.create(ff.getField(), Link.Direction.REFERENT);
        return this.addJoin(joinType, foreignTableAlias, s, ff.getAlias());
    }

    private final SQLSelectJoin addJoin(SQLSelectJoin j) {
        boolean added = this.declaredTables.add(j.getJoinedTable(), true);
        assert (added);
        this.from.add(j);
        this.joinAliases.add(j.getAlias());
        this.joins.add(j);
        return j;
    }

    public final List<SQLSelectJoin> getJoins(String fromAlias, Step s, String joinedAlias) {
        if (s == null) {
            throw new NullPointerException("Null step");
        }
        ArrayList<SQLSelectJoin> res = new ArrayList<SQLSelectJoin>();
        for (SQLSelectJoin j : this.joins) {
            Step joinStep = j.getStep();
            if (!s.equals(joinStep) || fromAlias != null && !j.getExistingTable().getAlias().equals(fromAlias) || joinedAlias != null && !j.getAlias().equals(joinedAlias)) continue;
            res.add(j);
        }
        return res;
    }

    public TableRef followPath(String tableAlias, Path p) {
        return this.followPath(tableAlias, p, false);
    }

    public TableRef followPath(String tableAlias, Path p, boolean create) {
        TableRef firstTableRef = this.getTableRef(tableAlias);
        SQLTable firstTable = firstTableRef.getTable();
        if (!p.getFirst().equals(firstTable) && !p.getLast().equals(firstTable)) {
            throw new IllegalArgumentException("neither ends of " + p + " is " + firstTable);
        }
        if (!p.getFirst().equals(firstTable)) {
            return this.followPath(tableAlias, p.reverse(), create);
        }
        TableRef current = firstTableRef;
        int i = 0;
        while (i < p.length()) {
            Step step = p.getStep(i);
            List<SQLSelectJoin> joins = this.getJoins(current.getAlias(), step, null);
            if (joins.size() > 1) {
                throw new IllegalStateException("More than one join from " + current + " through " + step + " : " + joins);
            }
            if (joins.size() == 1) {
                current = joins.get(0).getJoinedTable();
            } else if (create) {
                String uniqAlias = this.getUniqueAlias("assurePath_" + i);
                SQLSelectJoin createdJoin = this.addJoin("LEFT", current.getAlias(), step, uniqAlias);
                current = createdJoin.getJoinedTable();
            } else {
                return null;
            }
            ++i;
        }
        return current;
    }

    public void setExcludeUndefined(boolean excludeUndefined) {
        this.generalExcludeUndefined = excludeUndefined;
    }

    public void setExcludeUndefined(boolean exclude, SQLTable table) {
        this.excludeUndefined.put(table, exclude);
    }

    public void setArchivedPolicy(ArchiveMode policy) {
        this.setArchivedPolicy(null, policy);
    }

    public void setArchivedPolicy(SQLTable t, ArchiveMode policy) {
        this.archivedPolicy.put(t, policy);
    }

    public final Integer getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (o instanceof SQLSelect) {
            return this.asString().equals(((SQLSelect)o).asString());
        }
        return false;
    }

    public int hashCode() {
        return this.select.hashCode() + this.from.getSQL().hashCode() + (this.where == null ? 0 : this.where.hashCode());
    }

    public final Map<String, TableRef> getTableRefs() {
        return this.declaredTables.getMap();
    }

    public final TableRef getTableRef(String alias) {
        TableRef res = this.declaredTables.getAliasedTable(alias);
        if (res == null) {
            throw new IllegalArgumentException("alias not in this select : " + alias);
        }
        return res;
    }

    public final String getUniqueAlias(String seed) {
        if (seed.length() > 63) {
            seed = seed.substring(0, 63);
        }
        if (!this.contains(seed)) {
            return seed;
        }
        long time = 1L;
        int i = 0;
        while (i < 50) {
            String cat = String.valueOf(seed) + "_" + time;
            String res = cat.length() > 63 ? String.valueOf(seed.substring(0, seed.length() - (cat.length() - 63))) + "_" + time : cat;
            if (!this.contains(res)) {
                return res;
            }
            ++time;
            ++i;
        }
        return null;
    }

    private final FieldRef createRef(String alias, SQLField f) {
        return this.createRef(alias, f, true);
    }

    private final FieldRef createRef(String alias, SQLField f, boolean mustExist) {
        if (mustExist && !this.contains(alias)) {
            throw new IllegalArgumentException("unknown alias " + alias);
        }
        return new AliasedField(f, alias);
    }

    public static enum ArchiveMode {
        UNARCHIVED,
        ARCHIVED,
        BOTH;

    }

    public static enum LockStrength {
        NONE,
        SHARE,
        UPDATE;

    }
}

