/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.State;
import org.openconcerto.sql.model.ColumnListHandler;
import org.openconcerto.sql.model.ConnectionHandler;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HandlersStack;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLResultSet;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TransactionPoint;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cache.ICacheSupport;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;

public final class SQLDataSource
extends BasicDataSource
implements Cloneable {
    public static final Map<SQLSystem, String> DRIVERS = new HashMap<SQLSystem, String>();
    public static int QUERY_TUNING;
    public static final IgnoringRowProcessor ROW_PROC;
    public static final ColumnListHandler COLUMN_LIST_HANDLER;
    public static final ArrayListHandler ARRAY_LIST_HANDLER;
    public static final ArrayHandler ARRAY_HANDLER;
    public static final ScalarHandler SCALAR_HANDLER;
    public static final MapListHandler MAP_LIST_HANDLER;
    public static final MapHandler MAP_HANDLER;
    private SQLCache<List<?>, Object> cache;
    private boolean cacheEnabled;
    private final PropertyChangeListener descL;
    private Set<SQLTable> tables;
    private static int count;
    private final DBSystemRoot sysRoot;
    private ConnectionFactory connectionFactory;
    private final Map<Thread, HandlersStack> handlers;
    private ExecutorService exec = null;
    private final Object setInitialShemaLock = new String("initialShemaWriteLock");
    private boolean initialShemaSet;
    private String initialShema;
    private final Map<Connection, Object> schemaUptodate;
    private final Map<Connection, Object> uptodate;
    private volatile int retryWait;
    private boolean blockWhenExhausted;
    private long softMinEvictableIdleTimeMillis;
    private int txIsolation;
    private Integer dbTxIsolation;
    private boolean checkOnceDBTxIsolation;
    private final ReentrantLock testLock = new ReentrantLock();
    private static int executorSerial;
    private static final String pgInterrupted;

    static {
        DRIVERS.put(SQLSystem.MYSQL, "com.mysql.jdbc.Driver");
        DRIVERS.put(SQLSystem.POSTGRESQL, "org.postgresql.Driver");
        DRIVERS.put(SQLSystem.DERBY, "org.apache.derby.jdbc.ClientDriver");
        DRIVERS.put(SQLSystem.H2, "org.h2.Driver");
        DRIVERS.put(SQLSystem.MSSQL, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        System.setProperty("h2.databaseToUpper", "false");
        QUERY_TUNING = 0;
        ROW_PROC = new IgnoringCSRowProcessor();
        COLUMN_LIST_HANDLER = new ColumnListHandler();
        ARRAY_LIST_HANDLER = new ArrayListHandler();
        ARRAY_HANDLER = new ArrayHandler();
        SCALAR_HANDLER = new ScalarHandler();
        MAP_LIST_HANDLER = new MapListHandler(ROW_PROC);
        MAP_HANDLER = new MapHandler(ROW_PROC);
        count = 0;
        executorSerial = 0;
        pgInterrupted = GT.tr("Interrupted while attempting to connect.");
    }

    public SQLDataSource(DBSystemRoot sysRoot, String base, String login, String pass) {
        this(sysRoot, sysRoot.getServer().getURL(base), login, pass, Collections.emptySet());
    }

    private SQLDataSource(DBSystemRoot sysRoot, String url, String login, String pass, Set<SQLTable> tables) {
        this(sysRoot);
        SQLSystem system = this.getSystem();
        if (!DRIVERS.containsKey((Object)system)) {
            throw new IllegalArgumentException("unknown database system: " + (Object)((Object)system));
        }
        this.setDriverClassName(DRIVERS.get((Object)system));
        this.setUrl("jdbc:" + system.getJDBCName() + ":" + url);
        this.setUsername(login);
        this.setPassword(pass);
        this.setTables(tables);
        if (system == SQLSystem.MYSQL) {
            this.addConnectionProperty("transformedBitIsBoolean", "true");
            this.addConnectionProperty("allowMultiQueries", "true");
        } else if (system == SQLSystem.MSSQL) {
            this.addConnectionProperty("xopenStates", "true");
            this.addConnectionProperty("selectMethod", "cursor");
        }
        this.setLoginTimeout(15);
        this.setSocketTimeout(480);
        this.setTCPKeepAlive(true);
        this.setRetryWait(3000);
    }

    @Override
    public final void setLoginTimeout(int timeout) {
        if (this.getSystem() == SQLSystem.MYSQL) {
            this.addConnectionProperty("connectTimeout", String.valueOf(timeout) + "000");
        } else if (this.getSystem() == SQLSystem.POSTGRESQL || this.getSystem() == SQLSystem.MSSQL) {
            this.addConnectionProperty("loginTimeout", String.valueOf(timeout));
        } else {
            Log.get().warning("Ignoring login timeout for " + this);
        }
    }

    public final void setSocketTimeout(int timeout) {
        if (this.getSystem() == SQLSystem.MYSQL) {
            this.addConnectionProperty("socketTimeout", String.valueOf(timeout) + "000");
        } else if (this.getSystem() == SQLSystem.H2) {
            this.addConnectionProperty("QUERY_TIMEOUT", String.valueOf(timeout) + "000");
        } else if (this.getSystem() == SQLSystem.POSTGRESQL) {
            this.addConnectionProperty("socketTimeout", String.valueOf(timeout));
        } else {
            Log.get().log(this.getLogLevelForIgnoredTCPParam(), "Ignoring socket timeout for " + this);
        }
    }

    private final Level getLogLevelForIgnoredTCPParam() {
        return SQLSyntax.get(this.sysRoot).isServerLocalhost(this.sysRoot.getServer()) ? Level.CONFIG : Level.WARNING;
    }

    public final void setTCPKeepAlive(boolean b) {
        if (this.getSystem() == SQLSystem.POSTGRESQL || this.getSystem() == SQLSystem.MYSQL) {
            this.addConnectionProperty("tcpKeepAlive", String.valueOf(b));
        } else {
            Log.get().log(this.getLogLevelForIgnoredTCPParam(), "Ignoring TCP keep alive for " + this);
        }
    }

    public final void setRetryWait(int retryWait) {
        this.retryWait = retryWait;
    }

    synchronized void setTables(Set<SQLTable> tables) {
        boolean update = this.cache == null || !tables.containsAll(this.tables);
        this.tables = Collections.unmodifiableSet(new HashSet<SQLTable>(tables));
        if (update) {
            this.updateCache();
        }
    }

    private synchronized void updateCache() {
        if (this.cache != null) {
            this.cache.getSupp().die();
        }
        this.cache = this.createCache(null);
        for (HandlersStack s : this.handlers.values()) {
            s.updateCache();
        }
    }

    final synchronized SQLCache<List<?>, Object> getCommittedCache() {
        return this.cache;
    }

    final SQLCache<List<?>, Object> getCache() {
        HandlersStack stack = this.getHandlersStack();
        if (stack != null && stack.hasTransaction()) {
            return stack.getCache();
        }
        return this.getCommittedCache();
    }

    synchronized SQLCache<List<?>, Object> createCache(TransactionPoint o) {
        SQLCache res;
        if (this.isCacheEnabled() && this.tables.size() > 0) {
            final boolean committedCache = o == null;
            Object desc = committedCache ? this : o;
            ICacheSupport cacheSupp = committedCache ? null : this.cache.getSupp();
            res = new SQLCache<List<?>, Object>(cacheSupp, 30, 30, "results of " + desc.toString(), o){

                @Override
                protected String getCacheSuppName(String cacheName) {
                    if (!$assertionsDisabled && !committedCache) {
                        throw new AssertionError((Object)"Creating extra ICacheSupport");
                    }
                    return SQLDataSource.this.toString();
                }
            };
        } else {
            res = null;
        }
        return res;
    }

    public final synchronized void setCacheEnabled(boolean b) {
        if (this.cacheEnabled != b) {
            this.cacheEnabled = b;
            this.updateCache();
        }
    }

    public final synchronized boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    private SQLDataSource(DBSystemRoot sysRoot) {
        this.sysRoot = sysRoot;
        this.handlers = new Hashtable<Thread, HandlersStack>();
        this.schemaUptodate = new WeakHashMap<Connection, Object>();
        this.uptodate = new WeakHashMap<Connection, Object>();
        this.initialShemaSet = false;
        this.initialShema = null;
        this.setValidationQuery("SELECT 1");
        this.setValidationQueryTimeout(6);
        this.setTestOnBorrow(false);
        this.setTestOnReturn(false);
        this.setTestWhileIdle(false);
        this.setInitialSize(3);
        this.setBlockWhenExhausted(true);
        this.setMaxActive(12);
        this.setMaxWait(5000L);
        this.setMinIdle(2);
        this.setMaxIdle(10);
        this.setTimeBetweenEvictionRunsMillis(4000L);
        this.setNumTestsPerEvictionRun(5);
        this.setSoftMinEvictableIdleTimeMillis(TimeUnit.SECONDS.toMillis(40L));
        this.setMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(30L));
        this.txIsolation = 2;
        this.dbTxIsolation = null;
        this.checkOnceDBTxIsolation = true;
        this.tables = Collections.emptySet();
        this.descL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("descendants")) {
                    SQLDataSource.this.setTables(((DBSystemRoot)evt.getSource()).getDescs(SQLTable.class));
                }
            }
        };
        this.sysRoot.addListener(this.descL);
        this.cache = null;
        this.cacheEnabled = false;
    }

    public List execute(String query) {
        return (List)this.execute(query, MAP_LIST_HANDLER);
    }

    public List executeCol(String query) {
        return (List)this.execute(query, COLUMN_LIST_HANDLER);
    }

    public Map execute1(String query) {
        return (Map)this.execute(query, MAP_HANDLER);
    }

    public Object[] executeA1(String query) {
        return (Object[])this.execute(query, ARRAY_HANDLER);
    }

    public Object executeScalar(String query) {
        return this.execute(query, SCALAR_HANDLER);
    }

    public Object execute(String query, ResultSetHandler rsh) {
        return this.execute(query, rsh, null);
    }

    public final Object execute(String query, ResultSetHandler rsh, boolean changeState) throws RTInterruptedException {
        return this.execute(query, rsh, changeState, null);
    }

    private Object execute(String query, ResultSetHandler rsh, Connection c) throws RTInterruptedException {
        return this.execute(query, rsh, false, c);
    }

    final List<Object> getCacheKey(String query, ResultSetHandler rsh) {
        return query.startsWith("SELECT") ? Arrays.asList(query, rsh) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(String query, ResultSetHandler rsh, boolean changeState, Connection passedConn) throws RTInterruptedException {
        long afterHandle;
        long afterExecute;
        long afterQueryInfo;
        CacheResult<Object> cacheRes;
        List<Object> key;
        long timeMs = System.currentTimeMillis();
        long time = System.nanoTime();
        if (query.length() == 0) {
            SQLRequestLog.log(query, "Pas de requ\u00eate.", timeMs, time);
            return null;
        }
        IResultSetHandler irsh = rsh instanceof IResultSetHandler ? (IResultSetHandler)rsh : null;
        boolean readCache = irsh == null || irsh.readCache();
        boolean canWriteCache = irsh == null || irsh.canWriteCache();
        SQLCache<List<?>, Object> cache = !readCache && !canWriteCache ? null : this.getCache();
        List<Object> list = key = cache == null ? null : this.getCacheKey(query, rsh);
        if (key != null) {
            Set<SQLData> data = irsh == null || irsh.getCacheModifiers() == null ? this.tables : irsh.getCacheModifiers();
            cacheRes = cache.check(key, readCache, canWriteCache, data);
            if (cacheRes.getState() == CacheResult.State.INTERRUPTED) {
                throw new RTInterruptedException("interrupted while waiting for the cache");
            }
            if (cacheRes.getState() == CacheResult.State.VALID) {
                State.INSTANCE.addCacheHit();
                SQLRequestLog.log(query, "En cache.", timeMs, time);
                return cacheRes.getRes();
            }
        } else {
            cacheRes = null;
        }
        Object result = null;
        QueryInfo info = null;
        long afterCache = System.nanoTime();
        try {
            info = new QueryInfo(query, changeState, passedConn);
            try {
                afterQueryInfo = System.nanoTime();
                Object[] res = this.executeTwice(info);
                Statement stmt = (Statement)res[0];
                ResultSet rs = (ResultSet)res[1];
                afterExecute = System.nanoTime();
                if (rsh != null && rs != null) {
                    if (this.getSystem() == SQLSystem.DERBY || this.getSystem() == SQLSystem.POSTGRESQL) {
                        rs = new SQLResultSet(rs);
                    }
                    result = rsh.handle(rs);
                }
                afterHandle = System.nanoTime();
                stmt.close();
                if (key != null) {
                    SQLDataSource sQLDataSource = this;
                    synchronized (sQLDataSource) {
                        this.putInCache(cache, irsh, cacheRes, result);
                    }
                }
                info.releaseConnection();
            }
            catch (SQLException exn) {
                throw new IllegalStateException("Impossible d'acc\u00e9der au r\u00e9sultat de " + query + "\n in " + this, exn);
            }
        }
        catch (RuntimeException e) {
            if (cacheRes != null) {
                cache.removeRunning((List<?>)((Object)cacheRes));
            }
            if (info != null) {
                info.releaseConnection(e);
            }
            throw e;
        }
        SQLRequestLog.log(query, "", info.getConnection(), timeMs, time, afterCache, afterQueryInfo, afterExecute, afterHandle, System.nanoTime());
        return result;
    }

    private synchronized void putInCache(SQLCache<List<?>, Object> cache, IResultSetHandler irsh, CacheResult<Object> cacheRes, Object result) {
        if (irsh != null && irsh.writeCache() || irsh == null && IResultSetHandler.shouldCache(result)) {
            cache.put(cacheRes, result);
        } else {
            cache.removeRunning((List<?>)((Object)cacheRes));
        }
    }

    private final synchronized ExecutorService getExec() {
        if (this.exec == null) {
            ThreadFactory factory = new ThreadFactory(String.valueOf(SQLDataSource.class.getSimpleName()) + " " + this.toString() + " exec n\u00b0 ", false);
            this.exec = new ThreadPoolExecutor(0, 32, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        }
        return this.exec;
    }

    public final boolean handlingConnection() {
        return this.handlers.containsKey(Thread.currentThread());
    }

    private final HandlersStack getHandlersStack() {
        return this.handlers.get(Thread.currentThread());
    }

    public final <T, X extends Exception> T useConnection(ConnectionHandler<T, X> handler) throws SQLException, X {
        return this.useConnection(handler, false);
    }

    private final <T, X extends Exception> T useConnection(ConnectionHandler<T, X> handler, boolean force) throws SQLException, X {
        boolean pristineState;
        HandlersStack h;
        Connection conn;
        boolean connOutsidePool = false;
        if (!this.handlingConnection()) {
            try {
                conn = this.getNewConnection();
            }
            catch (NoSuchElementException e) {
                if (force) {
                    conn = this.connectionFactory.createConnection();
                    connOutsidePool = true;
                }
                throw e;
            }
            h = new HandlersStack(this, conn, handler);
            this.handlers.put(h.getThread(), h);
        } else if (handler.canRestoreState()) {
            h = this.getHandlersStack().push(handler);
        } else {
            throw new IllegalStateException("this thread has already called useConnection() and thus expect its state, but the passed handler cannot restore state: " + handler);
        }
        conn = null;
        Exception beforeExn = null;
        Exception afterExn = null;
        Exception computeExn = null;
        try {
            conn = h.getConnection();
            h.setChangeAllowed(true);
            handler.setup(conn);
            h.setChangeAllowed(false);
            try {
                handler.compute(this);
            }
            catch (Exception e) {
                computeExn = e;
            }
        }
        catch (Exception e) {
            h.setChangeAllowed(false);
            beforeExn = e;
        }
        boolean bl = pristineState = conn == null;
        if (!pristineState && h.hasValidConnection() && handler.canRestoreState()) {
            h.setChangeAllowed(true);
            try {
                handler.restoreState(conn);
                pristineState = true;
            }
            catch (Exception e) {
                afterExn = e;
            }
            h.setChangeAllowed(false);
        }
        if (h.pop()) {
            this.handlers.remove(Thread.currentThread());
            if (connOutsidePool) {
                conn.close();
            } else if (pristineState) {
                this.returnConnection(h.getConnection());
            } else {
                this.closeConnection(h.invalidConnection());
            }
        } else {
            assert (!connOutsidePool);
            if (!pristineState) {
                this.closeConnection(h.invalidConnection());
            }
        }
        if (beforeExn != null) {
            assert (computeExn == null) : "Compute shouldn't be attempted if setup fails : " + beforeExn + " " + computeExn;
            if (afterExn != null) {
                throw new SQLException("could not restore state after failed setup : " + ExceptionUtils.getStackTrace(afterExn), beforeExn);
            }
            throw ExceptionUtils.throwExn(beforeExn, SQLException.class, RuntimeException.class);
        }
        if (afterExn != null) {
            if (computeExn != null) {
                throw new SQLException("could not restore state after successful setup : " + ExceptionUtils.getStackTrace(afterExn), computeExn);
            }
            throw ExceptionUtils.throwExn(afterExn, SQLException.class, RuntimeException.class);
        }
        return handler.get();
    }

    private Object[] executeTwice(QueryInfo queryInfo) throws SQLException {
        Object[] res;
        String query = queryInfo.getQuery();
        try {
            res = this.executeOnce(query, queryInfo.getConnection());
        }
        catch (SQLException exn) {
            State.INSTANCE.addFailedRequest(query);
            int retryWait = this.retryWait;
            if (retryWait < 0) {
                throw exn;
            }
            try {
                Thread.sleep(this.retryWait);
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(String.valueOf(e.getMessage()) + " : " + query, exn);
            }
            try {
                Connection otherConn = queryInfo.obtainNewConnection();
                if (otherConn == null) {
                    throw exn;
                }
                res = this.executeOnce(query, otherConn);
            }
            catch (Exception e) {
                if (e == exn) {
                    throw exn;
                }
                throw new SQLException("second exec failed: " + e.getLocalizedMessage(), exn);
            }
            Log.get().log(Level.INFO, "executeOnce() failed for " + queryInfo, exn);
        }
        return res;
    }

    private Object[] executeOnce(String query, Connection c) throws SQLException {
        Statement stmt = c.createStatement();
        ResultSet rs = this.execute(query, stmt);
        return new Object[]{stmt, rs};
    }

    private ResultSet execute(String query, Statement stmt) throws SQLException, RTInterruptedException {
        ResultSet rs;
        long t1;
        block14: {
            State.INSTANCE.beginRequest(query);
            boolean interrupted = false;
            if (QUERY_TUNING > 0) {
                try {
                    Thread.sleep(QUERY_TUNING);
                }
                catch (InterruptedException e1) {
                    interrupted = true;
                }
            } else {
                interrupted = Thread.currentThread().isInterrupted();
            }
            if (interrupted) {
                throw new RTInterruptedException("request interrupted : " + query);
            }
            t1 = System.currentTimeMillis();
            rs = null;
            try {
                if (query.startsWith("INSERT") || query.startsWith("UPDATE") || query.startsWith("DELETE") || query.startsWith("CREATE") || query.startsWith("ALTER") || query.startsWith("DROP") || query.startsWith("SET")) {
                    boolean returnGenK = query.startsWith("INSERT") && stmt.getConnection().getMetaData().supportsGetGeneratedKeys();
                    stmt.executeUpdate(query, returnGenK ? 1 : 2);
                    rs = returnGenK ? stmt.getGeneratedKeys() : null;
                    break block14;
                }
                ExecutorThread thr = new ExecutorThread(stmt, query);
                thr.start();
                try {
                    rs = thr.getRs();
                }
                catch (SQLException e) {
                    if (this.getSystem() == SQLSystem.MYSQL && e.getErrorCode() == 1317) {
                        thr.stopQuery();
                        throw new InterruptedQuery("request interrupted : " + query, e, thr);
                    }
                    throw e;
                }
                catch (InterruptedException e) {
                    thr.stopQuery();
                    throw new InterruptedQuery("request interrupted : " + query, e, thr);
                }
            }
            finally {
                State.INSTANCE.endRequest(query);
            }
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 1000L && query.length() < 1000) {
            System.err.println("Warning:" + (t2 - t1) + "ms pour :" + query);
        }
        ++count;
        return rs;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.sysRoot.rmListener(this.descL);
        GenericObjectPool pool = this.connectionPool;
        super.close();
        this.connectionPool = pool;
        if (this.exec != null) {
            this.exec.shutdownNow();
            this.exec = null;
        }
        if (this.getBorrowedConnectionCount() == 0) {
            this.noConnectionIsOpen();
        }
    }

    private synchronized void noConnectionIsOpen() {
        assert (this.connectionPool == null || this.connectionPool.getNumIdle() + this.getBorrowedConnectionCount() == 0);
        if (this.cache != null) {
            this.cache.getSupp().die();
        }
    }

    @Override
    public final Connection getConnection() {
        HandlersStack res = this.getHandlersStack();
        if (res == null) {
            throw new IllegalStateException("useConnection() wasn't called");
        }
        return res.getConnection();
    }

    public final TransactionPoint getTransactionPoint() {
        HandlersStack handlersStack = this.getHandlersStack();
        if (handlersStack == null) {
            return null;
        }
        return handlersStack.getLastTxPoint();
    }

    protected final Connection getNewConnection() throws NoSuchElementException {
        try {
            return this.borrowConnection(false);
        }
        catch (RTInterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof NoSuchElementException) {
                throw (NoSuchElementException)e;
            }
            return this.borrowConnection(true);
        }
    }

    private final Connection borrowConnection(boolean test) throws NoSuchElementException {
        if (test) {
            this.testLock.lock();
            this.setTestOnBorrow(true);
        }
        try {
            Connection res = this.getRawConnection(!test);
            try {
                this.initConnection(res);
                Connection connection = res;
                return connection;
            }
            catch (RuntimeException e) {
                this.closeConnection(res);
                throw e;
            }
        }
        finally {
            if (test) {
                this.setTestOnBorrow(false);
                this.testLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initConnection(Connection res) {
        boolean setSchema = false;
        String schemaToSet = null;
        SQLDataSource sQLDataSource = this;
        synchronized (sQLDataSource) {
            if (!this.schemaUptodate.containsKey(res)) {
                if (this.initialShemaSet) {
                    setSchema = true;
                    schemaToSet = this.initialShema;
                }
                this.schemaUptodate.put(res, null);
            }
            this.uptodate.put(res, null);
        }
        if (setSchema) {
            this.setSchema(schemaToSet, res);
        }
    }

    private void getRawConnectionThrow(Exception e1, Exception e2) throws NoSuchElementException {
        if (e1.getCause() instanceof NoSuchElementException) {
            throw (NoSuchElementException)e1.getCause();
        }
        if (e2 == null) {
            throw new IllegalStateException("Impossible d'obtenir une connexion sur " + this, e1);
        }
        throw new IllegalStateException("Impossible d'obtenir une connexion sur " + this + "apr\u00e8s 2 essais\nexception 2 :" + e2.getLocalizedMessage(), e1);
    }

    private Connection getRawConnection(boolean retry) throws NoSuchElementException {
        assert (!Thread.holdsLock(this)) : "super.getConnection() might block (see setWhenExhaustedAction()), and since return/closeConnection() need this lock, this method cannot wait while holding the lock";
        Connection result = null;
        try {
            result = super.getConnection();
        }
        catch (Exception e1) {
            int retryWait;
            if (e1.getCause() instanceof InterruptedException || e1 instanceof PSQLException && e1.getMessage().equals(pgInterrupted)) {
                throw new RTInterruptedException(e1);
            }
            int n = retryWait = retry ? this.retryWait : -1;
            if (retryWait < 0) {
                this.getRawConnectionThrow(e1, null);
            }
            try {
                Thread.sleep(retryWait);
                result = super.getConnection();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException("interrupted while waiting for a second try", e);
            }
            catch (Exception e) {
                this.getRawConnectionThrow(e1, e);
            }
        }
        State.INSTANCE.connectionCreated();
        return result;
    }

    public final int getBorrowedConnectionCount() {
        return this.connectionPool == null ? 0 : this.connectionPool.getNumActive();
    }

    public synchronized void setBlockWhenExhausted(boolean block) {
        this.blockWhenExhausted = block;
        if (this.connectionPool != null) {
            this.connectionPool.setWhenExhaustedAction(block ? (byte)1 : 2);
        }
    }

    public final synchronized void setSoftMinEvictableIdleTimeMillis(long millis) {
        this.softMinEvictableIdleTimeMillis = millis;
        if (this.connectionPool != null) {
            this.connectionPool.setSoftMinEvictableIdleTimeMillis(millis);
        }
    }

    final synchronized void setTransactionIsolation(Connection conn) throws SQLException {
        if (this.dbTxIsolation == null) {
            this.dbTxIsolation = conn.getTransactionIsolation();
            assert (this.dbTxIsolation != null);
        }
        if (!(this.dbTxIsolation == 0 || this.checkOnceDBTxIsolation && this.dbTxIsolation == this.txIsolation)) {
            if (this.checkOnceDBTxIsolation) {
                Log.get().config("Setting transaction isolation to " + this.txIsolation);
            }
            conn.setTransactionIsolation(this.txIsolation);
        }
    }

    @Override
    protected void createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory, KeyedObjectPoolFactory statementPoolFactory, AbandonedConfig configuration) throws SQLException {
        PoolableConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new PoolableConnectionFactory(driverConnectionFactory, this.connectionPool, statementPoolFactory, this.validationQuery, this.validationQueryTimeout, this.connectionInitSqls, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, configuration){

                @Override
                public Object makeObject() throws Exception {
                    Connection conn = this._connFactory.createConnection();
                    if (conn == null) {
                        throw new IllegalStateException("Connection factory returned null from createConnection");
                    }
                    this.initializeConnection(conn);
                    SQLDataSource.this.setTransactionIsolation(conn);
                    if (this._stmtPoolFactory != null) {
                        KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
                        conn = new PoolingConnection(conn, stmtpool);
                        stmtpool.setFactory((PoolingConnection)conn);
                    }
                    return new TransactionPoolableConnection(conn, this._pool, this._config);
                }
            };
            SQLDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Cannot create PoolableConnectionFactory", e);
        }
    }

    @Override
    protected void createConnectionPool() {
        super.createConnectionPool();
        this.connectionPool.setLifo(true);
        this.setBlockWhenExhausted(this.blockWhenExhausted);
        this.connectionPool.setSoftMinEvictableIdleTimeMillis(this.softMinEvictableIdleTimeMillis);
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws SQLException {
        ConnectionFactory res;
        this.connectionFactory = res = super.createConnectionFactory();
        return res;
    }

    @Override
    protected void createDataSourceInstance() throws SQLException {
        this.dataSource = new PoolingDataSource(this.connectionPool){

            @Override
            public Connection getConnection() throws SQLException {
                try {
                    return (Connection)this._pool.borrowObject();
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (NoSuchElementException e) {
                    throw new SQLNestedException("Cannot get a connection, pool exhausted", e);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLNestedException("Cannot get a connection, general error", e);
                }
            }

            @Override
            public Connection getConnection(String username, String password) throws SQLException {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(Connection con) {
        if (con != null) {
            boolean unrecoverableOutOfDate;
            SQLDataSource sQLDataSource = this;
            synchronized (sQLDataSource) {
                unrecoverableOutOfDate = !this.uptodate.containsKey(con) || !this.initialShemaSet && !this.schemaUptodate.containsKey(con);
            }
            if (this.isClosed() || unrecoverableOutOfDate) {
                this.closeConnection(con);
            } else {
                try {
                    con.close();
                }
                catch (Exception e) {
                    Log.get().log(Level.FINE, "Could not return " + con, e);
                }
                State.INSTANCE.connectionRemoved();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Connection con) {
        if (con != null) {
            SQLDataSource sQLDataSource = this;
            synchronized (sQLDataSource) {
                this.uptodate.remove(con);
                this.schemaUptodate.remove(con);
            }
            try {
                this.connectionPool.invalidateObject(con);
            }
            catch (Exception e) {
                Log.get().log(Level.FINE, "Could not close " + con, e);
            }
            if (this.isClosed() && this.getBorrowedConnectionCount() == 0) {
                this.noConnectionIsOpen();
            }
        }
    }

    public void setInitialSchema(String schemaName) {
        if (schemaName != null || this.getSystem().isClearingPathSupported()) {
            this.setInitialSchema(true, schemaName);
        } else if (this.getSystem().isDBPathEmpty()) {
            this.unsetInitialSchema();
        } else {
            throw new IllegalArgumentException(this + " cannot have no default schema");
        }
    }

    public void unsetInitialSchema() {
        this.setInitialSchema(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setInitialSchema(boolean set, String schemaName) {
        Object object = this.setInitialShemaLock;
        synchronized (object) {
            Connection newConn;
            SQLDataSource sQLDataSource = this;
            synchronized (sQLDataSource) {
                if (this.initialShemaSet == set && CompareUtils.equals(this.initialShema, schemaName)) {
                    return;
                }
            }
            if (set) {
                newConn = this.getNewConnection();
                try {
                    this.setSchema(schemaName, newConn);
                }
                catch (RuntimeException e) {
                    this.closeConnection(newConn);
                    throw e;
                }
            } else {
                newConn = null;
            }
            SQLDataSource sQLDataSource2 = this;
            synchronized (sQLDataSource2) {
                this.initialShemaSet = set;
                this.initialShema = schemaName;
                this.schemaUptodate.clear();
                if (!set) {
                    this.connectionPool.clear();
                } else {
                    this.schemaUptodate.put(newConn, null);
                }
            }
            this.returnConnection(newConn);
        }
    }

    private void setSchema(String schemaName, Connection c) {
        String q;
        if (this.getSystem() == SQLSystem.MYSQL) {
            if (schemaName == null) {
                if (this.getSchema(c) != null) {
                    throw new IllegalArgumentException("cannot unset DATABASE in MySQL");
                }
                q = null;
            } else {
                q = "USE " + schemaName;
            }
        } else if (this.getSystem() == SQLSystem.DERBY) {
            q = "SET SCHEMA " + SQLBase.quoteIdentifier(schemaName);
        } else if (this.getSystem() == SQLSystem.H2) {
            q = "SET SCHEMA " + SQLBase.quoteIdentifier(schemaName);
        } else if (this.getSystem() == SQLSystem.POSTGRESQL) {
            q = schemaName == null ? "select set_config('search_path', '', false)" : "set session search_path to " + SQLBase.quoteIdentifier(schemaName);
        } else if (this.getSystem() == SQLSystem.MSSQL) {
            if (schemaName == null) {
                throw new IllegalArgumentException("cannot unset default schema in " + (Object)((Object)this.getSystem()));
            }
            q = "ALTER USER " + SQLBase.quoteIdentifier(this.getUsername()) + " with default_schema = " + SQLBase.quoteIdentifier(schemaName);
        } else {
            throw new UnsupportedOperationException();
        }
        if (q != null) {
            this.execute(q, null, true, c);
        }
    }

    public final String getSchema() {
        return this.getSchema(null);
    }

    private String getSchema(Connection c) {
        String q;
        if (this.getSystem() == SQLSystem.MYSQL) {
            q = "select DATABASE(); ";
        } else if (this.getSystem() == SQLSystem.DERBY) {
            q = "select CURRENT SCHEMA;";
        } else if (this.getSystem() == SQLSystem.POSTGRESQL) {
            q = "select (current_schemas(false))[1];";
        } else if (this.getSystem() == SQLSystem.H2) {
            q = "select SCHEMA();";
        } else if (this.getSystem() == SQLSystem.MSSQL) {
            q = "select SCHEMA_NAME();";
        } else {
            throw new UnsupportedOperationException();
        }
        return (String)this.execute(q, (ResultSetHandler)SCALAR_HANDLER, c);
    }

    public String toString() {
        return this.getUrl();
    }

    public final SQLSystem getSystem() {
        return this.sysRoot.getServer().getSQLSystem();
    }

    public Object clone() {
        SQLDataSource ds = new SQLDataSource(this.sysRoot);
        ds.setUrl(this.getUrl());
        ds.setUsername(this.getUsername());
        ds.setPassword(this.getPassword());
        ds.setDriverClassName(this.getDriverClassName());
        return ds;
    }

    private final class ExecutorThread
    extends Thread {
        private final Statement stmt;
        private final String query;
        private ResultSet rs;
        private Exception exn;
        private boolean canceled;

        public ExecutorThread(Statement stmt, String query) {
            int n = executorSerial;
            executorSerial = n + 1;
            super(String.valueOf(n) + " ExecutorThread on " + query);
            this.stmt = stmt;
            this.query = query;
            this.canceled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExecutorThread executorThread = this;
            synchronized (executorThread) {
                if (this.canceled) {
                    return;
                }
            }
            ResultSet rs = null;
            try {
                this.stmt.execute(this.query);
                ExecutorThread executorThread2 = this;
                synchronized (executorThread2) {
                    if (this.canceled) {
                        return;
                    }
                }
                rs = this.stmt.getResultSet();
            }
            catch (Exception e) {
                this.exn = e;
            }
            this.rs = rs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopQuery() throws SQLException {
            if (!this.stmt.isClosed()) {
                this.stmt.cancel();
            }
            ExecutorThread executorThread = this;
            synchronized (executorThread) {
                this.canceled = true;
            }
        }

        public ResultSet getRs() throws SQLException, InterruptedException {
            this.join();
            if (this.exn != null) {
                if (this.exn instanceof SQLException) {
                    throw (SQLException)this.exn;
                }
                throw (RuntimeException)this.exn;
            }
            return this.rs;
        }
    }

    private static class IgnoringCSRowProcessor
    extends BasicRowProcessor
    implements IgnoringRowProcessor {
        private IgnoringCSRowProcessor() {
        }

        @Override
        public Map<String, Object> toMap(ResultSet rs) throws SQLException {
            return this.toMap(rs, Collections.<String>emptySet());
        }

        @Override
        public Map<String, Object> toMap(ResultSet rs, Set<String> toIgnore) throws SQLException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            int i = 1;
            while (i <= cols) {
                String label = rsmd.getColumnLabel(i);
                if (!toIgnore.contains(label)) {
                    result.put(label, rs.getObject(i));
                }
                ++i;
            }
            return result;
        }
    }

    public static interface IgnoringRowProcessor
    extends RowProcessor {
        @Override
        public Map<String, Object> toMap(ResultSet var1) throws SQLException;

        public Map<String, Object> toMap(ResultSet var1, Set<String> var2) throws SQLException;
    }

    private final class InterruptedQuery
    extends RTInterruptedException {
        private final ExecutorThread thread;

        InterruptedQuery(String message, Throwable cause, ExecutorThread thr) {
            super(message, cause);
            this.thread = thr;
        }

        public final ExecutorThread getThread() {
            return this.thread;
        }
    }

    private final class QueryInfo {
        private final String query;
        private final boolean changeState;
        private Connection c;
        private final boolean privateConnection;

        QueryInfo(String query, boolean changeState, Connection passedConn) {
            Connection foundConn;
            this.query = query;
            this.changeState = changeState;
            boolean acquiredConnection = false;
            if (passedConn != null) {
                foundConn = passedConn;
            } else if (!SQLDataSource.this.handlingConnection()) {
                foundConn = SQLDataSource.this.getNewConnection();
                acquiredConnection = true;
            } else {
                HandlersStack threadHandlers = SQLDataSource.this.getHandlersStack();
                if (!changeState || threadHandlers.isChangeAllowed()) {
                    foundConn = threadHandlers.getConnection();
                } else {
                    throw new IllegalStateException("the passed query change the connection's state and the current thread has a connection which will thus be changed. A possible solution is to execute it in the setup() of a ConnectionHandler\n" + query);
                }
            }
            this.privateConnection = acquiredConnection;
            this.c = foundConn;
        }

        public final Connection getConnection() {
            return this.c;
        }

        public final String getQuery() {
            return this.query;
        }

        void releaseConnection(RuntimeException e) {
            if (e instanceof InterruptedQuery && SQLDataSource.this.getSystem() == SQLSystem.MYSQL) {
                final ExecutorThread thread = ((InterruptedQuery)e).getThread();
                if (this.privateConnection) {
                    if (this.changeState) {
                        this.releaseConnection();
                    } else {
                        SQLDataSource.this.getExec().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    thread.join(1500L);
                                    if (thread.isAlive()) {
                                        Log.get().warning(QueryInfo.this.getFailedCancelMsg());
                                        SQLDataSource.this.closeConnection(QueryInfo.this.getConnection());
                                    } else {
                                        SQLDataSource.this.returnConnection(QueryInfo.this.getConnection());
                                    }
                                }
                                catch (InterruptedException e) {
                                    Log.get().fine("Interrupted while joining " + QueryInfo.this.getQuery());
                                    SQLDataSource.this.closeConnection(QueryInfo.this.getConnection());
                                }
                            }
                        });
                    }
                } else {
                    try {
                        Thread.interrupted();
                        thread.join(500L);
                    }
                    catch (InterruptedException e2) {
                        System.err.println("ignore, we are already interrupted");
                        e2.printStackTrace();
                    }
                    Thread.currentThread().interrupt();
                    if (thread.isAlive()) {
                        throw new IllegalStateException(this.getFailedCancelMsg(), e);
                    }
                    this.releaseConnection();
                }
            } else {
                this.releaseConnection();
            }
        }

        void releaseConnection() {
            if (this.privateConnection) {
                if (this.changeState) {
                    SQLDataSource.this.closeConnection(this.getConnection());
                } else {
                    SQLDataSource.this.returnConnection(this.getConnection());
                }
            }
        }

        private final String getFailedCancelMsg() {
            return "cancel of " + System.identityHashCode(this.getConnection()) + " failed for " + this.getQuery();
        }

        final Connection obtainNewConnection() {
            if (!this.privateConnection) {
                return null;
            }
            SQLDataSource.this.closeConnection(this.getConnection());
            this.c = SQLDataSource.this.borrowConnection(true);
            return this.getConnection();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " private connection: " + this.privateConnection + " query: " + this.getQuery();
        }
    }

    private final class TransactionPoolableConnection
    extends PoolableConnection {
        private boolean autoCommit;

        private TransactionPoolableConnection(Connection conn, ObjectPool pool, AbandonedConfig config) {
            super(conn, pool, config);
            this.autoCommit = true;
        }

        private HandlersStack getNonNullHandlersStack() throws SQLException {
            HandlersStack res = SQLDataSource.this.getHandlersStack();
            if (res == null) {
                throw new SQLException("Unsafe transaction, call useConnection() or SQLUtils.executeAtomic()");
            }
            return res;
        }

        @Override
        public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
            if (this.autoCommit != autoCommit) {
                HandlersStack handlersStack = this.getNonNullHandlersStack();
                super.setAutoCommit(autoCommit);
                this.autoCommit = autoCommit;
                if (this.autoCommit) {
                    handlersStack.commit(null);
                } else {
                    handlersStack.addTxPoint(new TransactionPoint(this));
                }
            }
        }

        @Override
        public synchronized void commit() throws SQLException {
            super.commit();
            assert (!this.autoCommit);
            HandlersStack handlersStack = this.getNonNullHandlersStack();
            handlersStack.commit(new TransactionPoint(this));
        }

        @Override
        public synchronized void rollback() throws SQLException {
            super.rollback();
            assert (!this.autoCommit);
            HandlersStack handlersStack = this.getNonNullHandlersStack();
            handlersStack.rollback(new TransactionPoint(this));
        }

        @Override
        public synchronized Savepoint setSavepoint() throws SQLException {
            HandlersStack handlersStack = this.getNonNullHandlersStack();
            Savepoint res = super.setSavepoint();
            handlersStack.addTxPoint(new TransactionPoint(this, res, SQLDataSource.this.getSystem() == SQLSystem.MYSQL));
            return res;
        }

        @Override
        public synchronized Savepoint setSavepoint(String name) throws SQLException {
            HandlersStack handlersStack = this.getNonNullHandlersStack();
            Savepoint res = super.setSavepoint(name);
            handlersStack.addTxPoint(new TransactionPoint(this, res, true));
            return res;
        }

        @Override
        public synchronized void rollback(Savepoint savepoint) throws SQLException {
            super.rollback(savepoint);
            this.getNonNullHandlersStack().rollback(savepoint);
        }

        @Override
        public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
            super.releaseSavepoint(savepoint);
            this.getNonNullHandlersStack().releaseSavepoint(savepoint);
        }
    }
}

