/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.utils.cc.IClosure;

public class PGSQLBase
extends SQLBase {
    static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\", 16);
    static final String TWO_BACKSLASH_REPLACEMENT = Matcher.quoteReplacement("\\\\");

    PGSQLBase(SQLServer server, String name, IClosure<? super DBSystemRoot> systemRootInit, String login, String pass, IClosure<? super SQLDataSource> dsInit) {
        super(server, name, systemRootInit, login, pass, dsInit);
    }

    @Override
    public final String quoteString(String s) {
        String res = super.quoteString(s);
        if (s == null) {
            return res;
        }
        Matcher matcher = BACKSLASH_PATTERN.matcher(res);
        return matcher.find() ? "E" + matcher.replaceAll(TWO_BACKSLASH_REPLACEMENT) : res;
    }
}

