/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.util.EnumSet;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;

public class FixSerial
extends Changer<SQLTable> {
    public FixSerial(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.of(SQLSystem.POSTGRESQL);
    }

    @Override
    protected void changeImpl(SQLTable t) {
        this.getStream().print(t + "... ");
        if (!t.isRowable()) {
            this.getStream().println("not rowable");
        } else {
            SQLName seqName = FixSerial.getPrimaryKeySeq(t);
            if (seqName != null) {
                SQLSelect sel = new SQLSelect(true);
                sel.addSelect(t.getKey(), "max");
                Number maxID = (Number)this.getDS().executeScalar(sel.asString());
                long nextID = maxID == null ? 1L : maxID.longValue() + 1L;
                String s = "ALTER SEQUENCE " + seqName.quote() + " RESTART WITH " + nextID;
                this.getDS().executeScalar(s);
                this.getStream().println("done");
            } else {
                this.getStream().println("no sequence: " + t.getKey().getDefaultValue());
            }
        }
    }

    public static SQLName getPrimaryKeySeq(SQLTable t) throws IllegalStateException {
        if (!t.isRowable()) {
            return null;
        }
        SQLField key = t.getKey();
        if (key == null) {
            return null;
        }
        return key.getOwnedSequence();
    }
}

