/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.File;
import java.util.concurrent.ExecutorService;
import org.openconcerto.sql.model.DBRoot;

public abstract class Configuration {
    private static Configuration instance;
    private ExecutorService nonInteractiveSQLExecutor;

    public static File getDefaultConfDir() {
        return new File(System.getProperty("user.home"), ".java/ilm/sql-config/");
    }

    public static Configuration getInstance() {
        return instance;
    }

    public abstract DBRoot getRoot();

    public abstract String getAppName();

    public final String getAppID() {
        String appName = this.getAppName();
        if (appName == null || appName.length() == 0) {
            return null;
        }
        return String.valueOf(appName) + this.getAppIDSuffix();
    }

    protected String getAppIDSuffix() {
        return "";
    }

    public File getConfDir() {
        return new File(Configuration.getDefaultConfDir(), this.getAppID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.nonInteractiveSQLExecutor != null) {
                this.nonInteractiveSQLExecutor.shutdown();
            }
        }
    }
}

