/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.openconcerto.erp.core.sales.pos.io.AbstractESCPrinter;

public class ESCSerialPrinter
extends AbstractESCPrinter {
    private String port;

    public ESCSerialPrinter(String port) {
        port = port.trim();
        if (port.endsWith(":")) {
            port = port.substring(0, port.length() - 1);
        }
        this.port = port;
    }

    @Override
    public synchronized void printBuffer() throws Exception {
        byte[] byteArray = this.getPrintBufferBytes();
        SerialPort serialPort = this.getSerialPort();
        OutputStream out = serialPort.getOutputStream();
        out.write(byteArray);
        out.close();
        serialPort.close();
    }

    private SerialPort getSerialPort() throws Exception {
        if (this.port == null || this.port.length() == 0) {
            throw new IllegalStateException("Invalid serial port name: " + this.port);
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IllegalAccessError("Port " + this.port + " is currently in use");
        }
        int timeOutMs = 2000;
        CommPort commPort = portIdentifier.open("ESCSerialPrinter", 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IllegalStateException("Invalid serial port: " + this.port);
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }

    public static List<String> getSerialPortNames() {
        ArrayList<String> r = new ArrayList<String>();
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            System.out.println("Port: " + portIdentifier.getName() + " Type: " + ESCSerialPrinter.getPortTypeName(portIdentifier.getPortType()));
            if (portIdentifier.getPortType() != 1) continue;
            r.add(portIdentifier.getName());
        }
        return r;
    }

    private static String getPortTypeName(int portType) {
        switch (portType) {
            case 3: {
                return "I2C";
            }
            case 2: {
                return "Parallel";
            }
            case 5: {
                return "Raw";
            }
            case 4: {
                return "RS485";
            }
            case 1: {
                return "Serial";
            }
        }
        return "unknown type";
    }
}

