/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.ui;

import java.util.HashMap;
import java.util.Map;
import org.openconcerto.utils.i18n.TranslationManager;

public enum EtatCommandeClient {
    A_PREPARER(1, "sales.order.state.waiting"),
    RUPTURE(2, "sales.order.state.noStock"),
    EN_PREPARATION(3, "sales.order.state.running"),
    A_LIVRER(4, "sales.order.state.toDeliver"),
    LIVREE(5, "sales.order.state.delivered"),
    BLOQUE(6, "sales.order.state.block"),
    ANNULEE(7, "sales.order.state.cancelled");

    private final int id;
    private final String translationID;
    private static final Map<Integer, EtatCommandeClient> idToEnum;

    static {
        idToEnum = new HashMap<Integer, EtatCommandeClient>();
        EtatCommandeClient[] etatCommandeClientArray = EtatCommandeClient.values();
        int n = etatCommandeClientArray.length;
        int n2 = 0;
        while (n2 < n) {
            EtatCommandeClient e = etatCommandeClientArray[n2];
            idToEnum.put(e.getId(), e);
            ++n2;
        }
    }

    private EtatCommandeClient(int id, String translationID) {
        this.id = id;
        this.translationID = translationID;
    }

    public int getId() {
        return this.id;
    }

    public String getTranslation() {
        String translationForItem = TranslationManager.getInstance().getTranslationForItem(this.translationID);
        return translationForItem == null || translationForItem.trim().length() == 0 ? this.translationID : translationForItem;
    }

    public String toString() {
        return this.getTranslation();
    }
}

