/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.io.File;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.PropertiesUtils;
import org.openconcerto.utils.cc.IClosure;

public class ServerFinderConfig {
    public static final SQLSystem H2 = SQLSystem.H2;
    public static final SQLSystem POSTGRESQL = SQLSystem.POSTGRESQL;
    public static final SQLSystem MYSQL = SQLSystem.MYSQL;
    private final Properties props;
    private SQLSystem type = POSTGRESQL;
    private String ip;
    private File file;
    private String port;
    private String systemRoot = "OpenConcerto";
    private String dbLogin = "openconcerto";
    private String dbPassword = "openconcerto";
    private String product;
    private String error;

    public ServerFinderConfig() {
        this(new Properties());
    }

    public ServerFinderConfig(Properties props) {
        this.props = props;
    }

    public String getSystemRoot() {
        return this.systemRoot;
    }

    public void setSystemRoot(String systemRoot) {
        this.systemRoot = systemRoot;
    }

    public SQLSystem getType() {
        return this.getSystem();
    }

    public SQLSystem getSystem() {
        return this.type;
    }

    public void setType(SQLSystem type) {
        this.type = type;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public File getFile() {
        return this.file;
    }

    public void resetFile() {
        this.file = null;
    }

    public void setFile(File file) {
        String err = ServerFinderPanel.testH2DBDir(file);
        if (err != null) {
            JOptionPane.showMessageDialog(null, err);
        }
        this.file = file;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbLogin() {
        return this.dbLogin;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public String getProduct() {
        return this.product;
    }

    public void setError(String string) {
        this.error = ServerFinderConfig.getFixedString(string);
    }

    static String getFixedString(String string) {
        char errorUTF = '\ufffd';
        String errorUTF2 = String.valueOf(errorUTF) + errorUTF;
        int length = string.length();
        boolean needFix = false;
        int i = 0;
        while (i < length) {
            if (string.charAt(i) == errorUTF) {
                needFix = true;
                break;
            }
            ++i;
        }
        if (needFix) {
            string = string.replace(" " + errorUTF + "chou" + errorUTF + "e ", " \u00e9chou\u00e9e ");
            string = string.replace(" " + errorUTF2 + "chou" + errorUTF2 + "e ", " \u00e9chou\u00e9e ");
            string = string.replace(errorUTF, ' ');
        }
        return string;
    }

    public String getError() {
        return this.error;
    }

    public String test() {
        String result;
        block7: {
            result = "Erreur de connexion. \n";
            ComptaPropsConfiguration conf = this.createConf();
            try {
                try {
                    DBSystemRoot r = conf.getSystemRoot();
                    boolean ok = CompareUtils.equals(1, r.getDataSource().executeScalar("SELECT 1"));
                    if (ok) {
                        result = "Connexion r\u00e9ussie sur la base " + conf.getSystemRootName() + ".";
                        if (r.getChildrenNames().size() == 0) {
                            result = "Attention: la base " + conf.getSystemRootName() + " est vide";
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = String.valueOf(result) + e.getMessage();
                    conf.destroy();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                conf.destroy();
                throw throwable;
            }
            conf.destroy();
        }
        return ServerFinderConfig.getFixedString(result);
    }

    public boolean isOnline() {
        ComptaPropsConfiguration server = this.createConf(true);
        try {
            DBSystemRoot sysRoot = server.getSystemRoot();
            assert (sysRoot.isMappingNoRoots());
            boolean bl = CompareUtils.equals(1, sysRoot.getDataSource().executeScalar("SELECT 1"));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            server.destroy();
        }
    }

    public ComptaPropsConfiguration createConf() {
        return this.createConf(false);
    }

    private ComptaPropsConfiguration createConf(boolean mapNoRoots) {
        Properties props = new Properties(ComptaPropsConfiguration.createDefaults());
        PropertiesUtils.load(props, this.props);
        props.setProperty("server.driver", this.getSystem().name());
        props.setProperty("server.ip", this.getHost());
        props.setProperty("server.login", this.getDbLogin());
        props.setProperty("server.password", this.getDbPassword());
        props.setProperty("systemRoot", this.getSystemRoot());
        if (mapNoRoots) {
            props.setProperty("base.root", PropsConfiguration.EMPTY_PROP_VALUE);
            props.setProperty("systemRoot.rootsToMap", "");
        }
        return new ComptaPropsConfiguration(props, false, false);
    }

    private String getHost() {
        String host = this.getType().equals((Object)H2) ? "file:" + this.getFile().getAbsolutePath() + "/" : String.valueOf(this.getIp()) + ":" + this.getPort();
        return host;
    }

    public boolean createUserIfNeeded(String user, String password) throws Exception {
        String host = this.getType().equals((Object)H2) ? "file:" + this.getFile().getAbsolutePath() + "/" : this.getIp();
        if (this.getType().equals((Object)POSTGRESQL)) {
            SQLServer server = new SQLServer(this.getSystem(), host, String.valueOf(this.getPort()), user, password, (IClosure<? super DBSystemRoot>)new IClosure<DBSystemRoot>(){

                public void executeChecked(DBSystemRoot input) {
                    input.setRootToMap("postgres");
                }
            }, null);
            Number n = (Number)server.getOrCreateBase("postgres").getDataSource().executeScalar("SELECT COUNT(*) FROM pg_user WHERE usename='openconcerto'");
            if (n.intValue() > 0) {
                return false;
            }
            server.getBase("postgres").getDataSource().execute("CREATE ROLE openconcerto LOGIN ENCRYPTED PASSWORD 'md51d6fb5ca62757af27ed31f93fc7751a7' SUPERUSER CREATEDB VALID UNTIL 'infinity'");
            server.destroy();
        } else {
            System.err.println("Not supported for this database");
        }
        return true;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + ":" + this.getHost() + " [" + this.getDbLogin() + "/" + this.getDbPassword() + "] systemRoot:" + this.getSystemRoot();
    }
}

