/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openconcerto.erp.config.DSNUpdateRubrique;
import org.openconcerto.erp.config.DsnBrutCode;
import org.openconcerto.erp.config.DsnUrssafCode;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.Inserter;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.utils.Tuple2;

public class DSNInstallationUtils {
    private void insertUndef(SQLCreateTable ct) throws SQLException {
        if (ct.getPrimaryKey().size() != 1) {
            throw new IllegalStateException("Not one and only one field in the PK : " + ct.getPrimaryKey());
        }
        Inserter.Insertion<?> insertion = new Inserter(ct).insertReturnFirstField("(" + SQLBase.quoteIdentifier("ORDRE") + ") VALUES(" + ReOrder.MIN_ORDER + ")", false);
        assert (insertion.getCount() == 1);
        if (insertion.getRows().size() != 1) {
            throw new IllegalStateException("Missing ID " + insertion.getRows());
        }
        SQLTable.setUndefID(ct.getRoot().getSchema(), ct.getName(), ((Number)insertion.getRows().get(0)).intValue());
    }

    private void insertValues(List<Tuple2<String, String>> values, SQLTable table) throws SQLException {
        for (Tuple2<String, String> tuple2 : values) {
            SQLRowValues rowVals = new SQLRowValues(table);
            rowVals.put("CODE", tuple2.get0());
            rowVals.put("NOM", tuple2.get1());
            rowVals.commit();
        }
    }

    public void updateDSNCommonTable(DBRoot root) throws SQLException {
        ArrayList<Tuple2<String, String>> v;
        SQLTable table;
        SQLCreateTable createTableMotif;
        SQLTable tableRubBrut;
        SQLCreateTable createTableCodeBase;
        ArrayList<Tuple2<String, String>> v2;
        SQLTable table2;
        SQLTable tableRubCot;
        AlterTable t;
        SQLTable societeCommonT = root.getTable("SOCIETE_COMMON");
        if (!societeCommonT.contains("IBAN")) {
            t = new AlterTable(societeCommonT);
            t.addVarCharColumn("IBAN", 256);
            t.addVarCharColumn("BIC", 256);
            root.getBase().getDataSource().execute(t.asString());
            root.refetchTable("SOCIETE_COMMON");
            root.getSchema().updateVersion();
        }
        if (!societeCommonT.contains("ORG_PROTECTION_SOCIAL_ID")) {
            t = new AlterTable(societeCommonT);
            t.addVarCharColumn("ORG_PROTECTION_SOCIAL_ID", 256);
            root.getBase().getDataSource().execute(t.asString());
            root.refetchTable("SOCIETE_COMMON");
            root.getSchema().updateVersion();
        }
        if (!(tableRubCot = root.getTable("RUBRIQUE_COTISATION")).contains("ASSIETTE_PLAFONNEE")) {
            AlterTable tableRub = new AlterTable(tableRubCot);
            tableRub.addBooleanColumn("ASSIETTE_PLAFONNEE", false, false);
            root.getBase().getDataSource().execute(tableRub.asString());
            root.refetchTable("RUBRIQUE_COTISATION");
            root.getSchema().updateVersion();
        }
        if (!root.contains("CODE_CAISSE_TYPE_RUBRIQUE")) {
            SQLCreateTable createTableCode = new SQLCreateTable(root, "CODE_CAISSE_TYPE_RUBRIQUE");
            createTableCode.addVarCharColumn("CODE", 25);
            createTableCode.addVarCharColumn("NOM", 512);
            createTableCode.addVarCharColumn("CAISSE_COTISATION", 512);
            try {
                root.getBase().getDataSource().execute(createTableCode.asString());
                this.insertUndef(createTableCode);
                root.refetchTable("CODE_CAISSE_TYPE_RUBRIQUE");
                table2 = root.getTable("CODE_CAISSE_TYPE_RUBRIQUE");
                DsnUrssafCode codeUrssaf = new DsnUrssafCode();
                codeUrssaf.insertCode(table2);
                List<String> tableRubName = Arrays.asList("RUBRIQUE_BRUT", "RUBRIQUE_COTISATION", "RUBRIQUE_NET");
                for (String t2 : tableRubName) {
                    AlterTable tableRub = new AlterTable(root.getTable(t2));
                    tableRub.addForeignColumn("ID_CODE_CAISSE_TYPE_RUBRIQUE", table2);
                    root.getBase().getDataSource().execute(tableRub.asString());
                    root.refetchTable(t2);
                }
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_CAISSE_TYPE_RUBRIQUE", ex);
            }
        }
        if (!root.contains("MOTIF_ARRET_TRAVAIL")) {
            SQLCreateTable createTableMotif2 = new SQLCreateTable(root, "MOTIF_ARRET_TRAVAIL");
            createTableMotif2.addVarCharColumn("CODE", 25);
            createTableMotif2.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif2.asString());
                this.insertUndef(createTableMotif2);
                root.refetchTable("MOTIF_ARRET_TRAVAIL");
                root.getSchema().updateVersion();
                table2 = root.getTable("MOTIF_ARRET_TRAVAIL");
                v2 = new ArrayList<Tuple2<String, String>>();
                v2.add(Tuple2.create("01", "maladie"));
                v2.add(Tuple2.create("02", "maternit\u00e9 /adoption"));
                v2.add(Tuple2.create("03", "paternit\u00e9 / accueil de l\u2019enfant"));
                v2.add(Tuple2.create("04", "cong\u00e9 suite \u00e0 un accident de trajet"));
                v2.add(Tuple2.create("05", "cong\u00e9 suite \u00e0 maladie professionnelle"));
                v2.add(Tuple2.create("06", "cong\u00e9 suite \u00e0 accident de travail ou de service"));
                v2.add(Tuple2.create("07", "femme enceinte dispens\u00e9e de travail"));
                v2.add(Tuple2.create("99", "annulation"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MOTIF_ARRET_TRAVAIL", ex);
            }
        }
        if (!root.contains("CODE_BASE_ASSUJETTIE")) {
            createTableCodeBase = new SQLCreateTable(root, "CODE_BASE_ASSUJETTIE");
            createTableCodeBase.addVarCharColumn("CODE", 25);
            createTableCodeBase.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableCodeBase.asString());
                this.insertUndef(createTableCodeBase);
                root.refetchTable("CODE_BASE_ASSUJETTIE");
                root.getSchema().updateVersion();
                table2 = root.getTable("CODE_BASE_ASSUJETTIE");
                v2 = new ArrayList();
                v2.add(Tuple2.create("02", "Assiette brute plafonn\u00e9e"));
                v2.add(Tuple2.create("03", "Assiette brute d\u00e9plafonn\u00e9e"));
                v2.add(Tuple2.create("04", "Assiette de la contribution sociale g\u00e9n\u00e9ralis\u00e9e"));
                v2.add(Tuple2.create("07", "Assiette des contributions d'Assurance Ch\u00f4mage"));
                v2.add(Tuple2.create("08", "Assiette retraite CPRP SNCF"));
                v2.add(Tuple2.create("09", "Assiette de compensation bilat\u00e9rale maladie CPRP SNCF"));
                v2.add(Tuple2.create("10", "Base brute fiscale"));
                v2.add(Tuple2.create("11", "Base forfaitaire soumise aux cotisations de S\u00e9curit\u00e9 Sociale"));
                v2.add(Tuple2.create("12", "Assiette du cr\u00e9dit d'imp\u00f4t comp\u00e9titivit\u00e9-emploi"));
                v2.add(Tuple2.create("13", "Assiette du forfait social \u00e0 8%"));
                v2.add(Tuple2.create("14", "Assiette du forfait social \u00e0 20%"));
                this.insertValues(v2, table2);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_BASE_ASSUJETTIE", ex);
            }
        }
        if (!tableRubCot.contains("ID_CODE_BASE_ASSUJETTIE")) {
            AlterTable alterTableCot = new AlterTable(tableRubCot);
            alterTableCot.addForeignColumn("ID_CODE_BASE_ASSUJETTIE", root.getTable("CODE_BASE_ASSUJETTIE"));
            root.getBase().getDataSource().execute(alterTableCot.asString());
            root.refetchTable("RUBRIQUE_COTISATION");
            root.getSchema().updateVersion();
        }
        if (!root.contains("CODE_TYPE_RUBRIQUE_BRUT")) {
            createTableCodeBase = new SQLCreateTable(root, "CODE_TYPE_RUBRIQUE_BRUT");
            createTableCodeBase.addVarCharColumn("CODE", 25);
            createTableCodeBase.addVarCharColumn("NOM", 512);
            createTableCodeBase.addVarCharColumn("TYPE", 512);
            try {
                root.getBase().getDataSource().execute(createTableCodeBase.asString());
                this.insertUndef(createTableCodeBase);
                root.refetchTable("CODE_TYPE_RUBRIQUE_BRUT");
                root.getSchema().updateVersion();
                DsnBrutCode brutCode = new DsnBrutCode();
                brutCode.insertCode(root.getTable("CODE_TYPE_RUBRIQUE_BRUT"));
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_BASE_ASSUJETTIE", ex);
            }
        }
        if (!(tableRubBrut = root.getTable("RUBRIQUE_BRUT")).contains("ID_CODE_TYPE_RUBRIQUE_BRUT")) {
            AlterTable alterTableBrut = new AlterTable(tableRubBrut);
            alterTableBrut.addForeignColumn("ID_CODE_TYPE_RUBRIQUE_BRUT", root.getTable("CODE_TYPE_RUBRIQUE_BRUT"));
            root.getBase().getDataSource().execute(alterTableBrut.asString());
            root.refetchTable("RUBRIQUE_BRUT");
            root.getSchema().updateVersion();
        }
        if (!root.contains("DSN_REGIME_LOCAL")) {
            createTableMotif = new SQLCreateTable(root, "DSN_REGIME_LOCAL");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("DSN_REGIME_LOCAL");
                root.getSchema().updateVersion();
                table = root.getTable("DSN_REGIME_LOCAL");
                v = new ArrayList<Tuple2<String, String>>();
                v.add(Tuple2.create("99", "non applicable"));
                v.add(Tuple2.create("01", "r\u00e9gime local Alsace Moselle"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DSN_REGIME_LOCAL", ex);
            }
        }
        if (!root.contains("CONTRAT_MODALITE_TEMPS")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_MODALITE_TEMPS");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_MODALITE_TEMPS");
                root.getSchema().updateVersion();
                table = root.getTable("CONTRAT_MODALITE_TEMPS");
                v = new ArrayList();
                v.add(Tuple2.create("10", "temps plein"));
                v.add(Tuple2.create("20", "temps partiel"));
                v.add(Tuple2.create("21", "temps partiel th\u00e9rapeutique"));
                v.add(Tuple2.create("99", "salari\u00e9 non concern\u00e9"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_MODALITE_TEMPS", ex);
            }
        }
        if (!root.contains("CONTRAT_REGIME_MALADIE")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_REGIME_MALADIE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_REGIME_MALADIE");
                root.getSchema().updateVersion();
                table = root.getTable("CONTRAT_REGIME_MALADIE");
                v = new ArrayList();
                v.add(Tuple2.create("134", "r\u00e9gime sp\u00e9cial de la SNCF"));
                v.add(Tuple2.create("135", "r\u00e9gime sp\u00e9cial de la RATP"));
                v.add(Tuple2.create("136", "\u00e9tablissement des invalides de la marine (ENIM)"));
                v.add(Tuple2.create("137", "mineurs ou assimil\u00e9s (CANMSS)"));
                v.add(Tuple2.create("138", "militaires de carri\u00e8re (CNMSS)"));
                v.add(Tuple2.create("140", "clercs et employ\u00e9s de notaires (CRPCEN)"));
                v.add(Tuple2.create("141", "chambre de commerce et d'industrie de Paris"));
                v.add(Tuple2.create("144", "Assembl\u00e9e Nationale"));
                v.add(Tuple2.create("145", "S\u00e9nat"));
                v.add(Tuple2.create("146", "port autonome de Bordeaux"));
                v.add(Tuple2.create("147", "industries \u00e9lectriques et gazi\u00e8res (CAMIEG)"));
                v.add(Tuple2.create("149", "r\u00e9gimes des cultes (CAVIMAC)"));
                v.add(Tuple2.create("200", "r\u00e9gime g\u00e9n\u00e9ral (CNAM)"));
                v.add(Tuple2.create("300", "r\u00e9gime agricole (MSA)"));
                v.add(Tuple2.create("400", "r\u00e9gime sp\u00e9cial Banque de France"));
                v.add(Tuple2.create("900", "autre r\u00e9gime (r\u00e9serv\u00e9 Polyn\u00e9sie Fran\u00e7aise, Nouvelle Cal\u00e9donie)"));
                v.add(Tuple2.create("999", "autre"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_REGIME_MALADIE", ex);
            }
        }
        if (!root.contains("CONTRAT_REGIME_VIEILLESSE")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_REGIME_VIEILLESSE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_REGIME_VIEILLESSE");
                root.getSchema().updateVersion();
                table = root.getTable("CONTRAT_REGIME_VIEILLESSE");
                v = new ArrayList();
                v.add(Tuple2.create("120", "retraite des agents des collectivit\u00e9s locales (CNRACL)"));
                v.add(Tuple2.create("121", "pensions des ouvriers des \u00e9tablissements industriels de l'Etat (FSPOEIE)"));
                v.add(Tuple2.create("122", "pensions civiles et militaires de retraite de l'Etat (SRE)"));
                v.add(Tuple2.create("134", "r\u00e9gime sp\u00e9cial de la SNCF"));
                v.add(Tuple2.create("135", "r\u00e9gime sp\u00e9cial de la RATP"));
                v.add(Tuple2.create("136", "\u00e9tablissement des invalides de la marine (ENIM)"));
                v.add(Tuple2.create("137", "mineurs ou assimil\u00e9s (fonds Caisse des D\u00e9p\u00f4ts)"));
                v.add(Tuple2.create("139", "Banque de France"));
                v.add(Tuple2.create("140", "clercs et employ\u00e9s de notaires (CRPCEN)"));
                v.add(Tuple2.create("141", "chambre de commerce et d'industrie de Paris"));
                v.add(Tuple2.create("144", "Assembl\u00e9e Nationale"));
                v.add(Tuple2.create("145", "S\u00e9nat"));
                v.add(Tuple2.create("147", "industries \u00e9lectriques et gazi\u00e8res (CNIEG)"));
                v.add(Tuple2.create("149", "r\u00e9gime des cultes (CAVIMAC)"));
                v.add(Tuple2.create("157", "r\u00e9gime de retraite des avocats (CNBF)"));
                v.add(Tuple2.create("158", "SEITA"));
                v.add(Tuple2.create("159", "Com\u00e9die Fran\u00e7aise"));
                v.add(Tuple2.create("160", "Op\u00e9ra de Paris"));
                v.add(Tuple2.create("200", "r\u00e9gime g\u00e9n\u00e9ral (CNAV)"));
                v.add(Tuple2.create("300", "r\u00e9gime agricole (MSA)"));
                v.add(Tuple2.create("900", "autre r\u00e9gime (r\u00e9serv\u00e9 Polyn\u00e9sie Fran\u00e7aise, Nouvelle Cal\u00e9donie, Principaut\u00e9 de Monaco)"));
                v.add(Tuple2.create("903", "salari\u00e9s \u00e9trangers exempt\u00e9s d'affiliation pour le risque vieillesse"));
                v.add(Tuple2.create("999", "cas particuliers d'affiliation"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_REGIME_VIEILLESSE", ex);
            }
        }
        if (!root.contains("CONTRAT_MOTIF_RECOURS")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_MOTIF_RECOURS");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_MOTIF_RECOURS");
                root.getSchema().updateVersion();
                table = root.getTable("CONTRAT_MOTIF_RECOURS");
                v = new ArrayList();
                v.add(Tuple2.create("01", "Remplacement d'un salari\u00e9"));
                v.add(Tuple2.create("02", "Accroissement temporaire de l'activit\u00e9 de l'entreprise"));
                v.add(Tuple2.create("03", "Emplois \u00e0 caract\u00e8re saisonnier"));
                v.add(Tuple2.create("04", "Contrat vendanges"));
                v.add(Tuple2.create("05", "Contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e d\u2019usage"));
                v.add(Tuple2.create("06", "Contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e \u00e0 objet d\u00e9fini"));
                v.add(Tuple2.create("07", "Remplacement d'un chef d'entreprise"));
                v.add(Tuple2.create("08", "Remplacement du chef d'une exploitation agricole"));
                v.add(Tuple2.create("09", "Recrutement de personnes sans emploi rencontrant des difficult\u00e9s sociales et professionnelles particuli\u00e8res"));
                v.add(Tuple2.create("10", "Compl\u00e9ment de formation professionnelle au salari\u00e9"));
                v.add(Tuple2.create("11", "Formation professionnelle au salari\u00e9 par la voie de l'apprentissage, en vue de l'obtention d'une qualification professionnelle sanctionn\u00e9e par un dipl\u00f4me ou un titre \u00e0 finalit\u00e9 professionnelle enregistr\u00e9 au r\u00e9pertoire national des certifications professionnelles"));
                v.add(Tuple2.create("12", "Remplacement d\u2019un salari\u00e9 pass\u00e9 provisoirement \u00e0 temps partiel"));
                v.add(Tuple2.create("13", "Attente de la suppression d\u00e9finitive du poste du salari\u00e9 ayant quitt\u00e9 d\u00e9finitivement l\u2019entreprise"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_MOTIF_RECOURS", ex);
            }
        }
        if (!root.contains("CONTRAT_DETACHE_EXPATRIE")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_DETACHE_EXPATRIE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_DETACHE_EXPATRIE");
                root.getSchema().updateVersion();
                table = root.getTable("CONTRAT_DETACHE_EXPATRIE");
                v = new ArrayList();
                v.add(Tuple2.create("01", "D\u00e9tach\u00e9"));
                v.add(Tuple2.create("02", "Expatri\u00e9"));
                v.add(Tuple2.create("03", "Frontalier"));
                v.add(Tuple2.create("99", "Salari\u00e9 non concern\u00e9"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_DETACHE_EXPATRIE", ex);
            }
        }
        if (!root.contains("DSN_NATURE")) {
            createTableMotif = new SQLCreateTable(root, "DSN_NATURE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("DSN_NATURE");
                root.getSchema().updateVersion();
                table = root.getTable("DSN_NATURE");
                v = new ArrayList();
                v.add(Tuple2.create("01", "DSN Mensuelle"));
                v.add(Tuple2.create("02", "Signalement Fin du contrat de travail"));
                v.add(Tuple2.create("04", "Signalement Arr\u00eat de travail"));
                v.add(Tuple2.create("05", "Signalement Reprise suite \u00e0 arr\u00eat de travail"));
                v.add(Tuple2.create("06", "DSN reprise d'historique"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DSN_NATURE", ex);
            }
        }
        if (!root.contains("DSN_TYPE")) {
            createTableMotif = new SQLCreateTable(root, "DSN_TYPE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("DSN_TYPE");
                root.getSchema().updateVersion();
                table = root.getTable("DSN_TYPE");
                v = new ArrayList();
                v.add(Tuple2.create("01", "d\u00e9claration normale"));
                v.add(Tuple2.create("02", "d\u00e9claration normale n\u00e9ant"));
                v.add(Tuple2.create("03", "d\u00e9claration annule et remplace int\u00e9gral"));
                v.add(Tuple2.create("04", "d\u00e9claration annule"));
                v.add(Tuple2.create("05", "annule et remplace n\u00e9ant"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DSN_TYPE", ex);
            }
        }
        if (!root.contains("CONTRAT_DISPOSITIF_POLITIQUE")) {
            createTableMotif = new SQLCreateTable(root, "CONTRAT_DISPOSITIF_POLITIQUE");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("CONTRAT_DISPOSITIF_POLITIQUE");
                root.getSchema().updateVersion();
                table = root.getTable("CONTRAT_DISPOSITIF_POLITIQUE");
                v = new ArrayList();
                v.add(Tuple2.create("21", "CUI - Contrat Initiative Emploi"));
                v.add(Tuple2.create("41", "CUI - Contrat d'Accompagnement dans l'Emploi"));
                v.add(Tuple2.create("42", "CUI - Contrat d'acc\u00e8s \u00e0 l'emploi - DOM"));
                v.add(Tuple2.create("50", "Emploi d'avenir secteur marchand"));
                v.add(Tuple2.create("51", "Emploi d'avenir secteur non marchand"));
                v.add(Tuple2.create("61", "Contrat de Professionnalisation"));
                v.add(Tuple2.create("64", "Contrat d'apprentissage entreprises artisanales ou de moins de 11 salari\u00e9s (loi du 3 janvier 1979)"));
                v.add(Tuple2.create("65", "Contrat d\u2019apprentissage entreprises non inscrites au r\u00e9pertoire des m\u00e9tiers d\u2019au moins 11 salari\u00e9s (loi de 1987)"));
                v.add(Tuple2.create("70", "Contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e pour les s\u00e9niors"));
                v.add(Tuple2.create("71", "Contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e d\u2019insertion"));
                v.add(Tuple2.create("80", "Contrat de g\u00e9n\u00e9ration"));
                v.add(Tuple2.create("81", "Contrat d'apprentissage secteur public (Loi de 1992)"));
                v.add(Tuple2.create("82", "Contrat \u00e0 dur\u00e9e ind\u00e9termin\u00e9e int\u00e9rimaire"));
                v.add(Tuple2.create("99", "Non concern\u00e9"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CONTRAT_DISPOSITIF_POLITIQUE", ex);
            }
        }
        if (!root.contains("MOTIF_REPRISE_ARRET_TRAVAIL")) {
            createTableMotif = new SQLCreateTable(root, "MOTIF_REPRISE_ARRET_TRAVAIL");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("MOTIF_REPRISE_ARRET_TRAVAIL");
                root.getSchema().updateVersion();
                table = root.getTable("MOTIF_REPRISE_ARRET_TRAVAIL");
                v = new ArrayList();
                v.add(Tuple2.create("01", "reprise normale"));
                v.add(Tuple2.create("02", "reprise temps partiel th\u00e9rapeutique"));
                v.add(Tuple2.create("03", "reprise temps partiel raison personnelle"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MOTIF_REPRISE_ARRET_TRAVAIL", ex);
            }
        }
        if (!root.contains("MOTIF_FIN_CONTRAT")) {
            createTableMotif = new SQLCreateTable(root, "MOTIF_FIN_CONTRAT");
            createTableMotif.addVarCharColumn("CODE", 25);
            createTableMotif.addVarCharColumn("NOM", 512);
            try {
                root.getBase().getDataSource().execute(createTableMotif.asString());
                this.insertUndef(createTableMotif);
                root.refetchTable("MOTIF_FIN_CONTRAT");
                root.getSchema().updateVersion();
                table = root.getTable("MOTIF_FIN_CONTRAT");
                v = new ArrayList();
                v.add(Tuple2.create("011", "licenciement suite \u00e0 liquidation judiciaire ou \u00e0 redressement judiciaire"));
                v.add(Tuple2.create("012", "licenciement suite \u00e0 fermeture d\u00e9finitive de l'\u00e9tablissement"));
                v.add(Tuple2.create("014", "licenciement pour motif \u00e9conomique"));
                v.add(Tuple2.create("015", "licenciement pour fin de chantier"));
                v.add(Tuple2.create("020", "licenciement pour autre motif"));
                v.add(Tuple2.create("025", "autre fin de contrat pour motif \u00e9conomique"));
                v.add(Tuple2.create("026", "rupture pour motif \u00e9conomique dans le cadre d\u2019un contrat de s\u00e9curisation professionnelle CSP"));
                v.add(Tuple2.create("031", "fin de contrat \u00e0 dur\u00e9e d\u00e9termin\u00e9e ou fin d'accueil occasionnel"));
                v.add(Tuple2.create("032", "fin de mission d'int\u00e9rim"));
                v.add(Tuple2.create("033", "rupture anticip\u00e9e d\u2019un CDD ou d\u2019un contrat de mission en cas d\u2019inaptitude physique constat\u00e9e par le m\u00e9decin du travail"));
                v.add(Tuple2.create("034", "fin de p\u00e9riode d'essai \u00e0 l'initiative de l'employeur"));
                v.add(Tuple2.create("035", "fin de p\u00e9riode d'essai \u00e0 l'initiative du salari\u00e9"));
                v.add(Tuple2.create("036", " rupture anticip\u00e9e d'un CDD, d'un contrat d'apprentissage ou d\u2019un contrat de mission \u00e0 l'initiative de l'employeur"));
                v.add(Tuple2.create("037", "rupture anticip\u00e9e d'un CDD, d'un contrat d'apprentissage ou d\u2019un contrat de mission \u00e0 l'initiative du salari\u00e9"));
                v.add(Tuple2.create("038", "mise \u00e0 la retraite par l'employeur"));
                v.add(Tuple2.create("039", "d\u00e9part \u00e0 la retraite \u00e0 l'initiative du salari\u00e9"));
                v.add(Tuple2.create("043", "rupture conventionnelle"));
                v.add(Tuple2.create("058", "prise d'acte de la rupture de contrat de travail"));
                v.add(Tuple2.create("059", "d\u00e9mission"));
                v.add(Tuple2.create("065", "d\u00e9c\u00e8s de l'employeur ou internement / conduit \u00e0 un licenciement autre motif"));
                v.add(Tuple2.create("066", "d\u00e9c\u00e8s du salari\u00e9 / rupture force majeure"));
                v.add(Tuple2.create("081", "fin de contrat d'apprentissage"));
                v.add(Tuple2.create("082", "r\u00e9siliation judiciaire du contrat de travail"));
                v.add(Tuple2.create("083", "rupture de contrat de travail ou d\u2019un contrat de mission pour force majeure"));
                v.add(Tuple2.create("084", "rupture d'un commun accord du CDD, du contrat d'apprentissage ou d\u2019un contrat de mission"));
                v.add(Tuple2.create("085", "fin de mandat"));
                v.add(Tuple2.create("086", "licenciement convention CATS"));
                v.add(Tuple2.create("087", "licenciement pour faute grave"));
                v.add(Tuple2.create("088", "licenciement pour faute lourde"));
                v.add(Tuple2.create("089", "licenciement pour force majeure"));
                v.add(Tuple2.create("091", "licenciement pour inaptitude physique d'origine non professionnelle"));
                v.add(Tuple2.create("092", "licenciement pour inaptitude physique d'origine professionnelle"));
                v.add(Tuple2.create("093", "licenciement suite \u00e0 d\u00e9cision d'une autorit\u00e9 administrative"));
                v.add(Tuple2.create("094", "rupture anticip\u00e9e du contrat de travail pour arr\u00eat de tournage"));
                v.add(Tuple2.create("095", "rupture anticip\u00e9e du contrat de travail ou d\u2019un contrat de mission pour faute grave"));
                v.add(Tuple2.create("096", "rupture anticip\u00e9e du contrat de travail ou d\u2019un contrat de mission pour faute lourde"));
                v.add(Tuple2.create("097", "rupture anticip\u00e9e d\u2019un contrat de travail ou d\u2019un contrat de mission suite \u00e0 fermeture de l'\u00e9tablissement"));
                v.add(Tuple2.create("098", "retrait d'enfant"));
                v.add(Tuple2.create("998", "transfert du contrat de travail sans rupture du contrat vers un autre \u00e9tablissement n'effectuant pas encore de DSN"));
                v.add(Tuple2.create("999", "fin de relation avec l\u2019employeur (autres que contrat de travail) pour les cas ne portant aucun impact sur l\u2019Assurance ch\u00f4mage"));
                this.insertValues(v, table);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MOTIF_FIN_CONTRAT", ex);
            }
        }
        DSNUpdateRubrique dsnUpdateRubrique = new DSNUpdateRubrique(root);
        dsnUpdateRubrique.updateRubriqueCotisation();
    }

    public void updateDSN(DBRoot root) throws SQLException {
        AlterTable alter;
        AlterTable alter2;
        SQLTable tableContrat;
        AlterTable alter3;
        SQLTable tableDsn;
        SQLTable tableArret;
        SQLCreateTable createTable;
        SQLRow rowSansStatut;
        SQLTable tableCodeStatutCat = root.getTable("CODE_STATUT_CATEGORIEL");
        SQLRow rowNonCadre = tableCodeStatutCat.getRow(4);
        if (rowNonCadre != null) {
            rowNonCadre.createEmptyUpdateRow().put("CODE", "04").commit();
        }
        if ((rowSansStatut = tableCodeStatutCat.getRow(4)) != null) {
            rowSansStatut.createEmptyUpdateRow().put("CODE", "99").commit();
        }
        if (!root.contains("ARRET_TRAVAIL")) {
            createTable = new SQLCreateTable(root, "ARRET_TRAVAIL");
            createTable.addForeignColumn("SALARIE");
            createTable.addDateAndTimeColumn("DATE_DERNIER_JOUR_TRAV");
            createTable.addDateAndTimeColumn("DATE_FIN_PREV");
            createTable.addBooleanColumn("SUBROGATION", Boolean.FALSE, false);
            createTable.addDateAndTimeColumn("DATE_DEBUT_SUBROGATION");
            createTable.addDateAndTimeColumn("DATE_FIN_SUBROGATION");
            createTable.addForeignColumn("ID_MOTIF_ARRET_TRAVAIL", root.findTable("MOTIF_ARRET_TRAVAIL"));
            createTable.addForeignColumn("ID_MOTIF_REPRISE_ARRET_TRAVAIL", root.findTable("MOTIF_REPRISE_ARRET_TRAVAIL"));
            createTable.addDateAndTimeColumn("DATE_REPRISE");
            createTable.addDateAndTimeColumn("DATE_ACCIDENT");
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                this.insertUndef(createTable);
                root.refetchTable("ARRET_TRAVAIL");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARRET_TRAVAIL", ex);
            }
        }
        if (!root.contains("REPRISE_TRAVAIL")) {
            createTable = new SQLCreateTable(root, "REPRISE_TRAVAIL");
            createTable.addForeignColumn("SALARIE");
            createTable.addDateAndTimeColumn("DATE_DERNIER_JOUR_TRAV");
            createTable.addDateAndTimeColumn("DATE_FIN_PREV");
            createTable.addBooleanColumn("SUBROGATION", Boolean.FALSE, false);
            createTable.addDateAndTimeColumn("DATE_DEBUT_SUBROGATION");
            createTable.addDateAndTimeColumn("DATE_FIN_SUBROGATION");
            createTable.addForeignColumn("ID_MOTIF_ARRET_TRAVAIL", root.findTable("MOTIF_ARRET_TRAVAIL"));
            createTable.addForeignColumn("ID_MOTIF_REPRISE_ARRET_TRAVAIL", root.findTable("MOTIF_REPRISE_ARRET_TRAVAIL"));
            createTable.addDateAndTimeColumn("DATE_REPRISE");
            createTable.addDateAndTimeColumn("DATE_ACCIDENT");
            createTable.addDateAndTimeColumn("DATE");
            createTable.addVarCharColumn("COMMENTAIRES", 2048);
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                this.insertUndef(createTable);
                root.refetchTable("REPRISE_TRAVAIL");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table REPRISE_TRAVAIL", ex);
            }
        }
        if (!root.contains("DECLARATION_DSN")) {
            createTable = new SQLCreateTable(root, "DECLARATION_DSN");
            createTable.addForeignColumn("ID_DSN_NATURE", root.findTable("DSN_NATURE"));
            createTable.addDateAndTimeColumn("DATE");
            createTable.addDateAndTimeColumn("DATE_ENVOI");
            createTable.addBooleanColumn("TEST", Boolean.FALSE, false);
            createTable.addBooleanColumn("ENVOYE", Boolean.FALSE, false);
            createTable.addVarCharColumn("COMMENTAIRE", 1024);
            createTable.addVarCharColumn("DSN_FILE", 75000);
            createTable.addIntegerColumn("NUMERO", 1);
            createTable.addIntegerColumn("ANNEE", 2016);
            createTable.addForeignColumn("MOIS");
            try {
                root.getBase().getDataSource().execute(createTable.asString());
                this.insertUndef(createTable);
                root.refetchTable("DECLARATION_DSN");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DECLARATION_DSN", ex);
            }
        }
        if (!(tableArret = root.getTable("ARRET_TRAVAIL")).contains("DATE")) {
            AlterTable alter4 = new AlterTable(tableArret);
            alter4.addDateAndTimeColumn("DATE");
            alter4.addVarCharColumn("COMMENTAIRES", 2048);
            root.getBase().getDataSource().execute(alter4.asString());
            root.refetchTable("ARRET_TRAVAIL");
            root.getSchema().updateVersion();
        }
        if (!(tableDsn = root.getTable("DECLARATION_DSN")).contains("ID_ARRET_TRAVAIL")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addForeignColumn("ID_ARRET_TRAVAIL", root.findTable("ARRET_TRAVAIL"));
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("ID_REPRISE_TRAVAIL")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addForeignColumn("ID_REPRISE_TRAVAIL", root.findTable("REPRISE_TRAVAIL"));
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("ID_MOIS_REGUL")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addForeignColumn("ID_MOIS_REGUL", root.findTable("MOIS"));
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!tableDsn.contains("ANNULE_REMPLACE")) {
            alter3 = new AlterTable(tableDsn);
            alter3.addBooleanColumn("ANNULE_REMPLACE", Boolean.FALSE, false);
            root.getBase().getDataSource().execute(alter3.asString());
            root.getSchema().updateVersion();
        }
        if (!(tableContrat = root.getTable("CONTRAT_SALARIE")).contains("NUMERO")) {
            alter2 = new AlterTable(tableContrat);
            alter2.addColumn("NUMERO", "varchar(128) default '00000' NOT NULL");
            root.getBase().getDataSource().execute(alter2.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("CODE_REGIME_RETRAITE_DSN")) {
            alter2 = new AlterTable(tableContrat);
            alter2.addColumn("CODE_REGIME_RETRAITE_DSN", "varchar(128) default '00000' NOT NULL");
            root.getBase().getDataSource().execute(alter2.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("DATE_PREV_FIN")) {
            alter2 = new AlterTable(tableContrat);
            alter2.addDateAndTimeColumn("DATE_PREV_FIN");
            root.getBase().getDataSource().execute(alter2.asString());
            root.getSchema().updateVersion();
        }
        boolean updateContrat = false;
        if (!tableContrat.contains("ID_CONTRAT_MODALITE_TEMPS")) {
            updateContrat = true;
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_MODALITE_TEMPS", root.findTable("CONTRAT_MODALITE_TEMPS"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_REGIME_MALADIE")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_REGIME_MALADIE", root.findTable("CONTRAT_REGIME_MALADIE"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_REGIME_VIEILLESSE")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_REGIME_VIEILLESSE", root.findTable("CONTRAT_REGIME_VIEILLESSE"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_MOTIF_RECOURS")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_MOTIF_RECOURS", root.findTable("CONTRAT_MOTIF_RECOURS"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_DETACHE_EXPATRIE")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_DETACHE_EXPATRIE", root.findTable("CONTRAT_DETACHE_EXPATRIE"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (!tableContrat.contains("ID_CONTRAT_DISPOSITIF_POLITIQUE")) {
            alter = new AlterTable(tableContrat);
            alter.addForeignColumn("ID_CONTRAT_DISPOSITIF_POLITIQUE", root.findTable("CONTRAT_DISPOSITIF_POLITIQUE"));
            root.getBase().getDataSource().execute(alter.asString());
            root.getSchema().updateVersion();
        }
        if (updateContrat) {
            root.refetchTable("CONTRAT_SALARIE");
            tableContrat = root.findTable("CONTRAT_SALARIE");
            SQLSelect sel = new SQLSelect();
            sel.addSelectStar(tableContrat);
            List<SQLRow> contrats = SQLRowListRSH.execute(sel);
            SQLSelect selModal = new SQLSelect();
            SQLTable tableModaliteTemps = root.findTable("CONTRAT_MODALITE_TEMPS");
            selModal.addSelectStar(tableModaliteTemps);
            selModal.setWhere(new Where((FieldRef)tableModaliteTemps.getField("CODE"), "=", (Object)"10"));
            SQLRow contratModalite = SQLRowListRSH.execute(selModal).get(0);
            SQLSelect selMaladie = new SQLSelect();
            SQLTable tableMaladie = root.findTable("CONTRAT_REGIME_MALADIE");
            selMaladie.addSelectStar(tableMaladie);
            selMaladie.setWhere(new Where((FieldRef)tableMaladie.getField("CODE"), "=", (Object)"200"));
            SQLRow contratMaladie = SQLRowListRSH.execute(selMaladie).get(0);
            SQLSelect selViel = new SQLSelect();
            SQLTable tableViel = root.findTable("CONTRAT_REGIME_VIEILLESSE");
            selViel.addSelectStar(tableViel);
            selViel.setWhere(new Where((FieldRef)tableViel.getField("CODE"), "=", (Object)"200"));
            SQLRow contratViel = SQLRowListRSH.execute(selViel).get(0);
            SQLSelect selDetacheExp = new SQLSelect();
            SQLTable tableDetacheExp = root.findTable("CONTRAT_DETACHE_EXPATRIE");
            selDetacheExp.addSelectStar(tableDetacheExp);
            selDetacheExp.setWhere(new Where((FieldRef)tableDetacheExp.getField("CODE"), "=", (Object)"99"));
            SQLRow contratDetacheExp = SQLRowListRSH.execute(selDetacheExp).get(0);
            SQLSelect selDispoPolitique = new SQLSelect();
            SQLTable tableDispoPol = root.findTable("CONTRAT_DISPOSITIF_POLITIQUE");
            selDispoPolitique.addSelectStar(tableDispoPol);
            selDispoPolitique.setWhere(new Where((FieldRef)tableDispoPol.getField("CODE"), "=", (Object)"99"));
            SQLRow contratDispoPol = SQLRowListRSH.execute(selDispoPolitique).get(0);
            for (SQLRow contrat : contrats) {
                SQLRowValues createEmptyUpdateRow = contrat.createEmptyUpdateRow();
                createEmptyUpdateRow.put("ID_CONTRAT_MODALITE_TEMPS", contratModalite.getID());
                createEmptyUpdateRow.put("ID_CONTRAT_REGIME_MALADIE", contratMaladie.getID());
                createEmptyUpdateRow.put("ID_CONTRAT_REGIME_VIEILLESSE", contratViel.getID());
                createEmptyUpdateRow.put("ID_CONTRAT_DETACHE_EXPATRIE", contratDetacheExp.getID());
                createEmptyUpdateRow.put("ID_CONTRAT_DISPOSITIF_POLITIQUE", contratDispoPol.getID());
                createEmptyUpdateRow.commit();
            }
        }
    }
}

