/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConstraintReferential
extends Constraint {
    private IndexColumn[] columns;
    private IndexColumn[] refColumns;
    private int deleteAction;
    private int updateAction;
    private Table refTable;
    private Index index;
    private Index refIndex;
    private boolean indexOwner;
    private boolean refIndexOwner;
    private String deleteSQL;
    private String updateSQL;
    private boolean skipOwnTable;

    public ConstraintReferential(Schema schema, int n, String string, Table table) {
        super(schema, n, string, table);
    }

    @Override
    public String getConstraintType() {
        return "REFERENTIAL";
    }

    private static void appendAction(StatementBuilder statementBuilder, int n) {
        switch (n) {
            case 1: {
                statementBuilder.append("CASCADE");
                break;
            }
            case 2: {
                statementBuilder.append("SET DEFAULT");
                break;
            }
            case 3: {
                statementBuilder.append("SET NULL");
                break;
            }
            default: {
                DbException.throwInternalError("action=" + n);
            }
        }
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, this.refTable, string, true);
    }

    /*
     * WARNING - void declaration
     */
    public String getCreateSQLForCopy(Table table, Table table2, String string, boolean bl) {
        void var9_12;
        StatementBuilder statementBuilder = new StatementBuilder("ALTER TABLE ");
        String string2 = table.getSQL();
        statementBuilder.append(string2).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            statementBuilder.append("IF NOT EXISTS ");
        }
        statementBuilder.append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        IndexColumn[] indexColumnArray = this.columns;
        IndexColumn[] indexColumnArray2 = this.refColumns;
        statementBuilder.append(" FOREIGN KEY(");
        for (IndexColumn indexColumn : indexColumnArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(')');
        if (bl && this.indexOwner && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.index.getSQL());
        }
        statementBuilder.append(" REFERENCES ");
        if (this.table == this.refTable) {
            String string3 = table.getSQL();
        } else {
            String string4 = table2.getSQL();
        }
        statementBuilder.append((String)var9_12).append('(');
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : indexColumnArray2) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(')');
        if (bl && this.refIndexOwner && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.refIndex.getSQL());
        }
        if (this.deleteAction != 0) {
            statementBuilder.append(" ON DELETE ");
            ConstraintReferential.appendAction(statementBuilder, this.deleteAction);
        }
        if (this.updateAction != 0) {
            statementBuilder.append(" ON UPDATE ");
            ConstraintReferential.appendAction(statementBuilder, this.updateAction);
        }
        return statementBuilder.append(" NOCHECK").toString();
    }

    private String getShortDescription(Index index, SearchRow searchRow) {
        StatementBuilder statementBuilder = new StatementBuilder(this.getName());
        statementBuilder.append(": ").append(this.table.getSQL()).append(" FOREIGN KEY(");
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(") REFERENCES ").append(this.refTable.getSQL()).append('(');
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.refColumns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(')');
        if (index != null && searchRow != null) {
            statementBuilder.append(" (");
            statementBuilder.resetCount();
            Object[] objectArray = index.getColumns();
            int n = Math.min(this.columns.length, objectArray.length);
            for (int i = 0; i < n; ++i) {
                int n2 = ((Column)objectArray[i]).getColumnId();
                Value value = searchRow.getValue(n2);
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(value == null ? "" : value.toString());
            }
            statementBuilder.append(')');
        }
        return statementBuilder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.refTable, this.getSQL(), false);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.columns = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> hashSet;
        block3: {
            block2: {
                hashSet = New.hashSet();
                if (table != this.table) break block2;
                for (IndexColumn indexColumn : this.columns) {
                    hashSet.add(indexColumn.column);
                }
                break block3;
            }
            if (table != this.refTable) break block3;
            for (IndexColumn indexColumn : this.refColumns) {
                hashSet.add(indexColumn.column);
            }
        }
        return hashSet;
    }

    public void setRefColumns(IndexColumn[] indexColumnArray) {
        this.refColumns = indexColumnArray;
    }

    public IndexColumn[] getRefColumns() {
        return this.refColumns;
    }

    public void setRefTable(Table table) {
        this.refTable = table;
        if (table.isTemporary()) {
            this.setTemporary(true);
        }
    }

    public void setIndex(Index index, boolean bl) {
        this.index = index;
        this.indexOwner = bl;
    }

    public void setRefIndex(Index index, boolean bl) {
        this.refIndex = index;
        this.refIndexOwner = bl;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.refTable.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        if (this.refIndexOwner) {
            this.refTable.removeIndexOrTransferOwnership(session, this.refIndex);
        }
        this.database.removeMeta(session, this.getId());
        this.refTable = null;
        this.index = null;
        this.refIndex = null;
        this.columns = null;
        this.refColumns = null;
        this.deleteSQL = null;
        this.updateSQL = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table table, Row row, Row row2) {
        if (!this.database.getReferentialIntegrity()) {
            return;
        }
        if (!this.table.getCheckForeignKeyConstraints() || !this.refTable.getCheckForeignKeyConstraints()) {
            return;
        }
        if (table == this.table && !this.skipOwnTable) {
            this.checkRowOwnTable(session, row, row2);
        }
        if (table == this.refTable) {
            this.checkRowRefTable(session, row, row2);
        }
    }

    private void checkRowOwnTable(Session session, Row row, Row row2) {
        int n;
        int n2;
        int n3;
        Object object;
        if (row2 == null) {
            return;
        }
        boolean bl = row != null;
        for (IndexColumn indexColumn : this.columns) {
            int n4 = indexColumn.column.getColumnId();
            object = row2.getValue(n4);
            if (object == ValueNull.INSTANCE) {
                return;
            }
            if (!bl || this.database.areEqual((Value)object, row.getValue(n4))) continue;
            bl = false;
        }
        if (bl) {
            return;
        }
        if (this.refTable == this.table) {
            boolean bl2 = true;
            n3 = this.columns.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = this.columns[n2].column.getColumnId();
                Value value = row2.getValue(n5);
                object = this.refColumns[n2].column;
                n = ((Column)object).getColumnId();
                Value value2 = row2.getValue(n);
                if (this.database.areEqual(value2, value)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                return;
            }
        }
        Row row3 = this.refTable.getTemplateRow();
        n3 = this.columns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = this.columns[n2].column.getColumnId();
            Value value = row2.getValue(n6);
            object = this.refColumns[n2].column;
            n = ((Column)object).getColumnId();
            row3.setValue(n, ((Column)object).convert(value));
        }
        if (!this.existsRow(session, this.refIndex, row3, null)) {
            throw DbException.get(23506, this.getShortDescription(this.refIndex, row3));
        }
    }

    private boolean existsRow(Session session, Index index, SearchRow searchRow, Row row) {
        Table table = index.getTable();
        table.lock(session, false, false);
        Cursor cursor = index.find(session, searchRow, searchRow);
        while (cursor.next()) {
            SearchRow searchRow2 = cursor.getSearchRow();
            if (row != null && searchRow2.getKey() == row.getKey()) continue;
            Column[] columnArray = index.getColumns();
            boolean bl = true;
            int n = Math.min(this.columns.length, columnArray.length);
            for (int i = 0; i < n; ++i) {
                Value value;
                int n2 = columnArray[i].getColumnId();
                Value value2 = searchRow.getValue(n2);
                if (table.compareTypeSave(value2, value = searchRow2.getValue(n2)) == 0) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean isEqual(Row row, Row row2) {
        return this.refIndex.compareRows(row, row2) == 0;
    }

    private void checkRow(Session session, Row row) {
        Row row2;
        SearchRow searchRow = this.table.getTemplateSimpleRow(false);
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            Column column = this.columns[i].column;
            Column column2 = this.refColumns[i].column;
            int n2 = column2.getColumnId();
            Value value = column.convert(row.getValue(n2));
            if (value == ValueNull.INSTANCE) {
                return;
            }
            searchRow.setValue(column.getColumnId(), value);
        }
        Row row3 = row2 = this.refTable == this.table ? row : null;
        if (this.existsRow(session, this.index, searchRow, row2)) {
            throw DbException.get(23503, this.getShortDescription(this.index, searchRow));
        }
    }

    private void checkRowRefTable(Session session, Row row, Row row2) {
        if (row == null) {
            return;
        }
        if (row2 != null && this.isEqual(row, row2)) {
            return;
        }
        if (row2 == null) {
            if (this.deleteAction == 0) {
                this.checkRow(session, row);
            } else {
                int n = this.deleteAction == 1 ? 0 : this.columns.length;
                Prepared prepared = this.getDelete(session);
                this.setWhere(prepared, n, row);
                this.updateWithSkipCheck(prepared);
            }
        } else if (this.updateAction == 0) {
            this.checkRow(session, row);
        } else {
            Prepared prepared = this.getUpdate(session);
            if (this.updateAction == 1) {
                ArrayList<Parameter> arrayList = prepared.getParameters();
                int n = this.columns.length;
                for (int i = 0; i < n; ++i) {
                    Parameter parameter = arrayList.get(i);
                    Column column = this.refColumns[i].column;
                    parameter.setValue(row2.getValue(column.getColumnId()));
                }
            }
            this.setWhere(prepared, this.columns.length, row);
            this.updateWithSkipCheck(prepared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWithSkipCheck(Prepared prepared) {
        try {
            this.skipOwnTable = true;
            prepared.update();
        }
        finally {
            this.skipOwnTable = false;
        }
    }

    private void setWhere(Prepared prepared, int n, Row row) {
        int n2 = this.refColumns.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.refColumns[i].column.getColumnId();
            Value value = row.getValue(n3);
            ArrayList<Parameter> arrayList = prepared.getParameters();
            Parameter parameter = arrayList.get(n + i);
            parameter.setValue(value);
        }
    }

    public int getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(int n) {
        if (n == this.deleteAction && this.deleteSQL == null) {
            return;
        }
        if (this.deleteAction != 0) {
            throw DbException.get(90045, "ON DELETE");
        }
        this.deleteAction = n;
        this.buildDeleteSQL();
    }

    private void buildDeleteSQL() {
        if (this.deleteAction == 0) {
            return;
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        if (this.deleteAction == 1) {
            statementBuilder.append("DELETE FROM ").append(this.table.getSQL());
        } else {
            this.appendUpdate(statementBuilder);
        }
        this.appendWhere(statementBuilder);
        this.deleteSQL = statementBuilder.toString();
    }

    private Prepared getUpdate(Session session) {
        return this.prepare(session, this.updateSQL, this.updateAction);
    }

    private Prepared getDelete(Session session) {
        return this.prepare(session, this.deleteSQL, this.deleteAction);
    }

    public int getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(int n) {
        if (n == this.updateAction && this.updateSQL == null) {
            return;
        }
        if (this.updateAction != 0) {
            throw DbException.get(90045, "ON UPDATE");
        }
        this.updateAction = n;
        this.buildUpdateSQL();
    }

    private void buildUpdateSQL() {
        if (this.updateAction == 0) {
            return;
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        this.appendUpdate(statementBuilder);
        this.appendWhere(statementBuilder);
        this.updateSQL = statementBuilder.toString();
    }

    @Override
    public void rebuild() {
        this.buildUpdateSQL();
        this.buildDeleteSQL();
    }

    private Prepared prepare(Session session, String string, int n) {
        Prepared prepared = session.prepare(string);
        if (n != 1) {
            ArrayList<Parameter> arrayList = prepared.getParameters();
            int n2 = this.columns.length;
            for (int i = 0; i < n2; ++i) {
                Value value;
                Column column = this.columns[i].column;
                Parameter parameter = arrayList.get(i);
                if (n == 3) {
                    value = ValueNull.INSTANCE;
                } else {
                    Expression expression = column.getDefaultExpression();
                    if (expression == null) {
                        throw DbException.get(23507, column.getName());
                    }
                    value = expression.getValue(session);
                }
                parameter.setValue(value);
            }
        }
        return prepared;
    }

    private void appendUpdate(StatementBuilder statementBuilder) {
        statementBuilder.append("UPDATE ").append(this.table.getSQL()).append(" SET ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(" , ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName())).append("=?");
        }
    }

    private void appendWhere(StatementBuilder statementBuilder) {
        statementBuilder.append(" WHERE ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName())).append("=?");
        }
    }

    @Override
    public Table getRefTable() {
        return this.refTable;
    }

    @Override
    public boolean usesIndex(Index index) {
        return index == this.index || index == this.refIndex;
    }

    @Override
    public void setIndexOwner(Index index) {
        if (this.index == index) {
            this.indexOwner = true;
        } else if (this.refIndex == index) {
            this.refIndexOwner = true;
        } else {
            DbException.throwInternalError();
        }
    }

    @Override
    public boolean isBefore() {
        return false;
    }

    @Override
    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        session.startStatementWithinTransaction();
        StatementBuilder statementBuilder = new StatementBuilder("SELECT 1 FROM (SELECT ");
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(" FROM ").append(this.table.getSQL()).append(" WHERE ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(indexColumn.getSQL()).append(" IS NOT NULL ");
        }
        statementBuilder.append(" ORDER BY ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(") C WHERE NOT EXISTS(SELECT 1 FROM ").append(this.refTable.getSQL()).append(" P WHERE ");
        statementBuilder.resetCount();
        int n = 0;
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append("C.").append(indexColumn.getSQL()).append('=').append("P.").append(this.refColumns[n++].getSQL());
        }
        statementBuilder.append(')');
        String string = statementBuilder.toString();
        ResultInterface resultInterface = session.prepare(string).query(1);
        if (resultInterface.next()) {
            throw DbException.get(23506, this.getShortDescription(null, null));
        }
    }

    @Override
    public Index getUniqueIndex() {
        return this.refIndex;
    }
}

