/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.CalendarUtil;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.MissingResourceException;

class CalendarServiceShim
extends Calendar.CalendarShim {
    private static ICULocaleService service = new CalService();

    CalendarServiceShim() {
    }

    Calendar createInstance(ULocale desiredLocale) {
        ULocale useLocale;
        ULocale[] actualLoc = new ULocale[1];
        if (desiredLocale.equals(ULocale.ROOT)) {
            desiredLocale = ULocale.ROOT;
        }
        if (desiredLocale.getKeywordValue("calendar") == null) {
            String calType = CalendarUtil.getCalendarType(desiredLocale);
            useLocale = desiredLocale.setKeywordValue("calendar", calType);
        } else {
            useLocale = desiredLocale;
        }
        Calendar cal = (Calendar)service.get(useLocale, actualLoc);
        if (cal == null) {
            throw new MissingResourceException("Unable to construct Calendar", "", "");
        }
        cal = (Calendar)cal.clone();
        return cal;
    }

    private static class CalService
    extends ICULocaleService {
        CalService() {
            super("Calendar");
            class RBCalendarFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                RBCalendarFactory() {
                }

                protected Object handleCreate(ULocale loc, int kind, ICUService sercice) {
                    return Calendar.createInstance(loc);
                }
            }
            this.registerFactory(new RBCalendarFactory());
            this.markDefault();
        }
    }
}

