/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project.element;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.modules.project.element.ProjectStateSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.ExceptionHandler;

public class ProjectSQLElement
extends ComptaSQLConfElement {
    public ProjectSQLElement() {
        super("AFFAIRE", "une affaire", "affaires");
    }

    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_CLIENT");
        l.add("ID_TYPE_AFFAIRE");
        l.add("NUMERO");
        l.add("ID_ETAT_AFFAIRE");
        l.add("ID_COMMERCIAL");
        l.add("INFOS");
        return l;
    }

    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("ID_CLIENT");
        return l;
    }

    public CollectionMap<String, String> getShowAs() {
        return CollectionMap.singleton(null, this.getComboFields());
    }

    public Set<String> getInsertOnlyFields() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("ID_DEVIS");
        return s;
    }

    public SQLComponent createComponent() {
        return new UISQLComponent((SQLElement)this, 2){
            final JUniqueTextField field;
            {
                this.field = new JUniqueTextField();
            }

            protected void addViews() {
                this.addView((JComponent)this.field, "NUMERO", "1");
                this.addView((JComponent)new JDate(true), "DATE", "1");
                this.addView("ID_CLIENT", "1;required");
                this.addView("ID_COMMERCIAL", "1");
                this.addView("ID_DEVIS", "1");
                this.addView("ID_TYPE_AFFAIRE", "1;left");
                ElementComboBox boxEtatAffaire = new ElementComboBox();
                this.addView((JComponent)boxEtatAffaire, "ID_ETAT_AFFAIRE", "1;left;required");
                this.addView((JComponent)new ITextArea(), "INFOS", "2");
            }

            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    this.field.setIdSelected(r.getID());
                }
            }

            public void update() {
                if (!this.field.checkValidation()) {
                    ExceptionHandler.handle((String)"Impossible d'ajouter, num\u00e9ro d'affaire existant.");
                    Component root = SwingUtilities.getRoot((Component)((Object)this));
                    if (root instanceof EditFrame) {
                        EditFrame frame = (EditFrame)root;
                        frame.getPanel().setAlwaysVisible(true);
                    }
                    return;
                }
                super.update();
            }

            public int insert(SQLRow order) {
                SQLRow row;
                SQLRow rowDevis;
                int idCommande = this.getSelectedID();
                if (this.field.checkValidation()) {
                    idCommande = super.insert(order);
                    if (NumerotationAutoSQLElement.getNextNumero(ProjectSQLElement.class).equalsIgnoreCase(this.field.getText().trim())) {
                        SQLTable tableNum = Configuration.getInstance().getRoot().findTable("NUMEROTATION_AUTO");
                        SQLRowValues rowVals = new SQLRowValues(tableNum);
                        int val = tableNum.getRow(2).getInt("AFFAIRE_START");
                        rowVals.put("AFFAIRE_START", (Object)new Integer(++val));
                        try {
                            rowVals.update(2);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    ExceptionHandler.handle((String)"Impossible d'ajouter, num\u00e9ro d'affaire existant.");
                    Component root = SwingUtilities.getRoot((Component)((Object)this));
                    if (root instanceof EditFrame) {
                        EditFrame frame = (EditFrame)root;
                        frame.getPanel().setAlwaysVisible(true);
                    }
                }
                if ((rowDevis = (row = this.getTable().getRow(idCommande)).getForeign("ID_DEVIS")) != null && !rowDevis.isUndefined()) {
                    SQLRowValues rowVals = rowDevis.asRowValues();
                    rowVals.put("ID_AFFAIRE", idCommande);
                    try {
                        rowVals.update();
                    }
                    catch (SQLException exn) {
                        exn.printStackTrace();
                    }
                }
                return idCommande;
            }

            protected SQLRowValues createDefaults() {
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                rowVals.put("NUMERO", (Object)NumerotationAutoSQLElement.getNextNumero(ProjectSQLElement.class));
                rowVals.put("ID_ETAT_AFFAIRE", ProjectStateSQLElement.EN_COURS);
                return rowVals;
            }
        };
    }
}

