/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project;

import java.awt.FlowLayout;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JLabel;
import org.openconcerto.modules.project.OrderColumnRowRenderer;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.column.ColumnHeaderRenderer;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.GestionDevise;

public class TotalHeaderRenderer
extends ColumnHeaderRenderer {
    private JLabel label = new JLabelBold("Total : en cours de calcul");

    public TotalHeaderRenderer() {
        this.setLayout(new FlowLayout(0));
        this.add(this.label);
        this.setOpaque(false);
    }

    public void setContent(List<? extends SQLRowAccessor> rows) {
        String s = "Total :";
        long totalHT = 0L;
        long h = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            totalHT += sQLRowAccessor.getBigDecimal("T_PV_HT").setScale(2, 4).movePointRight(2).longValue();
            h += (long)OrderColumnRowRenderer.getHours(sQLRowAccessor);
        }
        if (h > 0L) {
            s = String.valueOf(s) + " " + h + " heures pr\u00e9vues,";
        }
        if (rows.size() > 0 && rows.get(0).getTable().getDBRoot().contains("AFFAIRE_TEMPS")) {
            double d = 0.0;
            for (SQLRowAccessor sQLRowAccessor : rows) {
                d += OrderColumnRowRenderer.getTimeSpent(sQLRowAccessor);
            }
            if (d > 0.0) {
                s = String.valueOf(s) + " " + TotalHeaderRenderer.hourFormater(d) + " heures pass\u00e9es,";
            }
        }
        s = String.valueOf(s) + " " + GestionDevise.currencyToString((long)totalHT, (boolean)true) + " \u20ac HT";
        this.label.setText(s);
    }

    public static String hourFormater(double h) {
        DecimalFormat f = new DecimalFormat("#0.00");
        String s = f.format(h);
        if (s.endsWith(".00") || s.endsWith(",00")) {
            s = s.substring(0, s.length() - 3);
        }
        return s;
    }
}

