/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openconcerto.modules.project.QuoteColumnRowRenderer;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.column.ColumnFooterRenderer;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.utils.GestionDevise;

public class QuoteColumnFooterRenderer
implements ColumnFooterRenderer {
    public JComponent getRenderer(List<? extends SQLRowAccessor> rows, int maxWidth) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout((LayoutManager)new VFlowLayout());
        long totalHT = 0L;
        long h = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            totalHT += sQLRowAccessor.getBigDecimal("T_PV_HT").setScale(2, 4).movePointRight(2).longValue();
            h += (long)QuoteColumnRowRenderer.getHours(sQLRowAccessor);
        }
        if (h > 0L) {
            p.add((Component)new JLabelBold(String.valueOf(h) + " heures"));
        }
        p.add((Component)new JLabelBold("Total : " + GestionDevise.currencyToString((long)totalHT, (boolean)true) + " \u20ac HT"));
        return p;
    }
}

