/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project;

import java.awt.GridLayout;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.modules.project.OrderColumnRowRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.utils.GestionDevise;

public class ProjectHistoryDevisBottomPanel
extends JPanel {
    private long montantDevis = 0L;
    private final JLabel labelDevis = new JLabel("", 4);
    private double timeDevis = 0.0;
    private final JLabel labelTimeDevis = new JLabel("", 4);

    public ProjectHistoryDevisBottomPanel() {
        this.setLayout(new GridLayout(2, 3));
        this.setOpaque(false);
        this.labelTimeDevis.setFont(this.labelTimeDevis.getFont().deriveFont(1));
        this.labelDevis.setFont(this.labelDevis.getFont().deriveFont(1));
        this.add(this.labelTimeDevis);
        this.add(this.labelDevis);
        this.updateLabels();
    }

    public synchronized void updateDevis(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        long montantDevis = 0L;
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            montantDevis += sqlRowAccessor.getLong("T_HT");
            ++i;
        }
        this.montantDevis = montantDevis;
        this.updateLabels();
    }

    public synchronized void updateTimeDevis(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        double timeDevis = 0.0;
        SQLTable tableEltDevis = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT").getTable();
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            Collection rows = sqlRowAccessor.getReferentRows(tableEltDevis);
            for (SQLRowAccessor sqlRowAccessor2 : rows) {
                timeDevis += (double)OrderColumnRowRenderer.getHours(sqlRowAccessor2);
            }
            ++i;
        }
        this.timeDevis = timeDevis;
        this.updateLabels();
    }

    private void updateLabels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectHistoryDevisBottomPanel.this.labelDevis.setText("Total devis : " + GestionDevise.currencyToString((long)ProjectHistoryDevisBottomPanel.this.montantDevis) + "\u20ac");
                ProjectHistoryDevisBottomPanel.this.labelTimeDevis.setText("Total temps  : " + ProjectHistoryDevisBottomPanel.this.timeDevis + " h");
            }
        });
    }
}

