/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project;

import java.awt.GridLayout;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.modules.project.OrderColumnRowRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.utils.GestionDevise;

public class ProjectHistoryCmdBottomPanel
extends JPanel {
    private long montantCmd = 0L;
    private final JLabel labelCmd = new JLabel("", 4);
    private double timeCmd = 0.0;
    private final JLabel labelTimeCmd = new JLabel("", 4);

    public ProjectHistoryCmdBottomPanel() {
        this.setLayout(new GridLayout(2, 1));
        this.setOpaque(false);
        this.add(this.labelTimeCmd);
        this.labelTimeCmd.setFont(this.labelTimeCmd.getFont().deriveFont(1));
        this.labelCmd.setFont(this.labelCmd.getFont().deriveFont(1));
        this.add(this.labelCmd);
        this.updateLabels();
    }

    public synchronized void updateTimeCmd(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        double timeCmd = 0.0;
        SQLTable tableEltCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT").getTable();
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            Collection rows = sqlRowAccessor.getReferentRows(tableEltCmd);
            for (SQLRowAccessor sqlRowAccessor2 : rows) {
                timeCmd += (double)OrderColumnRowRenderer.getHours(sqlRowAccessor2);
            }
            ++i;
        }
        this.timeCmd = timeCmd;
        this.updateLabels();
    }

    public synchronized void updateCmd(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        long montantCmd = 0L;
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            montantCmd += sqlRowAccessor.getLong("T_HT");
            ++i;
        }
        this.montantCmd = montantCmd;
        this.updateLabels();
    }

    private void updateLabels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectHistoryCmdBottomPanel.this.labelTimeCmd.setText("Total temps pr\u00e9vu : " + ProjectHistoryCmdBottomPanel.this.timeCmd + " h");
                ProjectHistoryCmdBottomPanel.this.labelCmd.setText("Total commande : " + GestionDevise.currencyToString((long)ProjectHistoryCmdBottomPanel.this.montantCmd) + "\u20ac");
            }
        });
    }
}

