/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project;

import java.awt.GridLayout;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.modules.project.OrderColumnRowRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.utils.GestionDevise;

public class ProjectHistoryBottomPanel
extends JPanel {
    private long montantCmd = 0L;
    private final JLabel labelCmd = new JLabel("", 2);
    private long montantDevis = 0L;
    private final JLabel labelDevis = new JLabel("", 2);
    private double timeCmd = 0.0;
    private final JLabel labelTimeCmd = new JLabel("", 2);
    private double timeDevis = 0.0;
    private final JLabel labelTimeDevis = new JLabel("", 2);
    private double time = 0.0;
    private final JLabel labelTime = new JLabel("", 2);

    public ProjectHistoryBottomPanel() {
        this.setLayout(new GridLayout(2, 3));
        this.add(this.labelTimeDevis);
        this.add(this.labelTimeCmd);
        this.add(this.labelTime);
        this.add(this.labelDevis);
        this.add(this.labelCmd);
    }

    public synchronized void updateDevis(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        long montantDevis = 0L;
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            montantDevis += sqlRowAccessor.getLong("T_HT");
            ++i;
        }
        this.montantDevis = montantDevis;
        this.updateLabels();
    }

    public synchronized void updateTimeDevis(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        SQLTable tableEltDevis = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT").getTable();
        double timeDevis = 0.0;
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            Collection rows = sqlRowAccessor.getReferentRows(tableEltDevis);
            for (SQLRowAccessor sqlRowAccessor2 : rows) {
                timeDevis += (double)OrderColumnRowRenderer.getHours(sqlRowAccessor2);
            }
            ++i;
        }
        this.timeDevis = timeDevis;
        this.updateLabels();
    }

    public synchronized void updateTimeCmd(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        double timeCmd = 0.0;
        SQLTable tableEltCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT").getTable();
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            Collection rows = sqlRowAccessor.getReferentRows(tableEltCmd);
            for (SQLRowAccessor sqlRowAccessor2 : rows) {
                timeCmd += (double)OrderColumnRowRenderer.getHours(sqlRowAccessor2);
            }
            ++i;
        }
        this.timeCmd = timeCmd;
        this.updateLabels();
    }

    public synchronized void updateCmd(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        long montantCmd = 0L;
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            montantCmd += sqlRowAccessor.getLong("T_HT");
            ++i;
        }
        this.montantCmd = montantCmd;
        this.updateLabels();
    }

    public synchronized void updateTime(IListe liste) {
        if (liste.isDead()) {
            return;
        }
        double time = 0.0;
        int rowCount = liste.getRowCount();
        int i = 0;
        while (i < rowCount) {
            SQLRowValues sqlRowAccessor = liste.getModel().getRow(i).getRow();
            time += (double)sqlRowAccessor.getFloat("TEMPS");
            ++i;
        }
        this.time = time;
        this.updateLabels();
    }

    private void updateLabels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectHistoryBottomPanel.this.labelDevis.setText("Total devis : " + GestionDevise.currencyToString((long)ProjectHistoryBottomPanel.this.montantDevis) + "\u20ac");
                ProjectHistoryBottomPanel.this.labelTimeDevis.setText("Total temps  : " + ProjectHistoryBottomPanel.this.timeDevis + " h");
                ProjectHistoryBottomPanel.this.labelTimeCmd.setText("Total temps pr\u00e9vu : " + ProjectHistoryBottomPanel.this.timeCmd + " h");
                ProjectHistoryBottomPanel.this.labelCmd.setText("Total commande : " + GestionDevise.currencyToString((long)ProjectHistoryBottomPanel.this.montantCmd) + "\u20ac");
                ProjectHistoryBottomPanel.this.labelTime.setText("Total temps r\u00e9alis\u00e9s : " + ProjectHistoryBottomPanel.this.time + " h");
            }
        });
    }
}

