/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.reports.history.ui.ListeHistoriquePanel;
import org.openconcerto.modules.project.ProjectHistoryCmdBottomPanel;
import org.openconcerto.modules.project.ProjectHistoryDevisBottomPanel;
import org.openconcerto.modules.project.ProjectHistoryTimeBottomPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.state.WindowStateManager;

public class ProjectHistory {
    private PanelFrame panelFrame;
    private ListeHistoriquePanel listPanel;

    public ListeHistoriquePanel getHistoriquePanel() {
        return this.listPanel;
    }

    public ProjectHistory() {
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        SQLBase b = comptaPropsConfiguration.getSQLBaseSociete();
        LinkedHashMap<String, List<String>> mapList = new LinkedHashMap<String, List<String>>();
        mapList.put("Devis", Arrays.asList("DEVIS"));
        mapList.put("Bons de commande", Arrays.asList("COMMANDE_CLIENT"));
        mapList.put("Factures", Arrays.asList("SAISIE_VENTE_FACTURE"));
        mapList.put("Avoirs", Arrays.asList("AVOIR_CLIENT"));
        if (Configuration.getInstance().getRoot().findTable("AFFAIRE_TEMPS") != null) {
            mapList.put("Temps", Arrays.asList("AFFAIRE_TEMPS"));
        }
        ComboSQLRequest request = new ComboSQLRequest(b.getTable("AFFAIRE"), Arrays.asList("NUMERO", "ID_CLIENT"));
        request.setUndefLabel("Toutes les affaires");
        request.setFieldSeparator(" ");
        this.listPanel = new ListeHistoriquePanel("Affaires", request, mapList, null, null, "Toutes les affaires", true, null);
        final IListPanel listeDevis = this.listPanel.getIListePanelFromTableName("DEVIS");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy = 4;
        c.fill = 1;
        final ProjectHistoryDevisBottomPanel devisPanel = new ProjectHistoryDevisBottomPanel();
        listeDevis.add((Component)devisPanel, (Object)c);
        listeDevis.getListe().getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                devisPanel.updateDevis(listeDevis.getListe());
                devisPanel.updateTimeDevis(listeDevis.getListe());
            }
        });
        final IListPanel listeCmd = this.listPanel.getIListePanelFromTableName("COMMANDE_CLIENT");
        final ProjectHistoryCmdBottomPanel cmdPanel = new ProjectHistoryCmdBottomPanel();
        listeCmd.add((Component)cmdPanel, (Object)c);
        listeCmd.getListe().getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                cmdPanel.updateCmd(listeCmd.getListe());
                cmdPanel.updateTimeCmd(listeCmd.getListe());
            }
        });
        final IListPanel listeTemps = this.listPanel.getIListePanelFromTableName("AFFAIRE_TEMPS");
        if (listeTemps != null) {
            final ProjectHistoryTimeBottomPanel timePanel = new ProjectHistoryTimeBottomPanel();
            listeTemps.add((Component)timePanel, (Object)c);
            listeTemps.getListe().getTableModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    timePanel.updateTime(listeTemps.getListe());
                }
            });
        }
        this.panelFrame = new PanelFrame((Container)this.listPanel, "Historique affaires");
        this.panelFrame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProjectHistory.this.listPanel.removeAllTableListener();
            }
        });
        this.panelFrame.setDefaultCloseOperation(2);
    }

    public PanelFrame getFrame() {
        this.panelFrame.setIconImages(Gestion.getFrameIcon());
        WindowStateManager stateManager = new WindowStateManager((Window)this.panelFrame, new File(Configuration.getInstance().getConfDir(), "Configuration" + File.separator + "Frame" + File.separator + "HistoAffaires.xml"), true);
        this.panelFrame.setDefaultCloseOperation(2);
        this.panelFrame.pack();
        this.panelFrame.setLocationRelativeTo(null);
        stateManager.loadState();
        return this.panelFrame;
    }
}

