/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.column.ColumnRowRenderer;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.utils.GestionDevise;

public class OrderColumnRowRenderer
implements ColumnRowRenderer {
    public JComponent getRenderer(final SQLRowAccessor row, int maxWidth) {
        JPanel p = new JPanel();
        p.setLayout((LayoutManager)new VFlowLayout(0, 2, 2, true));
        p.setBorder(BorderFactory.createLineBorder(new Color(206, 226, 255)));
        String number = row.getForeign("ID_COMMANDE_CLIENT").getString("NUMERO");
        String customer = row.getForeign("ID_COMMANDE_CLIENT").getForeign("ID_CLIENT").getString("NOM");
        long amount = row.getBigDecimal("T_PV_HT").setScale(2, 4).movePointRight(2).longValue();
        String total = String.valueOf(GestionDevise.currencyToString((long)amount, (boolean)true)) + " \u20ac HT";
        long totalAmount = row.getForeign("ID_COMMANDE_CLIENT").getLong("T_HT");
        if (totalAmount != amount) {
            total = String.valueOf(total) + ", commande de " + GestionDevise.currencyToString((long)totalAmount, (boolean)true) + " \u20ac HT";
        }
        int h = OrderColumnRowRenderer.getHours(row);
        p.add((Component)new JLabelBold(String.valueOf(number) + " " + customer));
        p.add(new JLabel(total));
        if (h > 0) {
            p.add(new JLabel(String.valueOf(h) + " heures pr\u00e9vues"));
        }
        if (row.getTable().getDBRoot().contains("AFFAIRE_TEMPS")) {
            double time = OrderColumnRowRenderer.getTimeSpent(row);
            JLabel lTime = new JLabel(String.valueOf(time) + " heures pass\u00e9es");
            if (time > (double)h) {
                lTime.setFont(lTime.getFont().deriveFont(1));
                lTime.setForeground(new Color(255, 135, 30));
            }
            if (time > 0.0) {
                p.add(lTime);
            }
        }
        p.setBackground(new Color(239, 243, 248));
        p.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    SQLRowAccessor foreign = row.getForeign("ID_COMMANDE_CLIENT");
                    EditFrame frame = new EditFrame(ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(foreign.getTable()), EditPanel.MODIFICATION);
                    frame.selectionId(foreign.getID());
                    FrameUtil.showPacked((Frame)frame);
                }
            }
        });
        return p;
    }

    public static double getTimeSpent(SQLRowAccessor row) {
        double time = 0.0;
        Collection rTimes = row.getReferentRows(row.getTable().getTable("AFFAIRE_TEMPS"));
        for (SQLRowAccessor r : rTimes) {
            time += (double)r.getFloat("TEMPS");
        }
        return time;
    }

    public static int getHours(SQLRowAccessor row) {
        int h = 0;
        String code = row.getForeign("ID_UNITE_VENTE").getString("CODE");
        if (code.equals("h")) {
            h = (int)((long)h + row.getLong("QTE_UNITAIRE") * row.getLong("QTE"));
        } else if (code.equals("j")) {
            h = (int)((long)h + row.getLong("QTE_UNITAIRE") * row.getLong("QTE") * 8L);
        }
        return h;
    }
}

