/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.project;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.sales.invoice.ui.SaisieVenteFactureItemTable;
import org.openconcerto.erp.core.sales.order.ui.CommandeClientItemTable;
import org.openconcerto.erp.core.sales.quote.component.DevisSQLComponent;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.AlterTableRestricted;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.modules.project.OrderColumnFooterRenderer;
import org.openconcerto.modules.project.OrderColumnRowRenderer;
import org.openconcerto.modules.project.OrderToInvoiceSQLInjector;
import org.openconcerto.modules.project.ProjectHistory;
import org.openconcerto.modules.project.QuoteColumnFooterRenderer;
import org.openconcerto.modules.project.QuoteColumnRowRenderer;
import org.openconcerto.modules.project.QuoteToInvoiceSQLInjector;
import org.openconcerto.modules.project.QuoteToOrderSQLInjector;
import org.openconcerto.modules.project.TotalHeaderRenderer;
import org.openconcerto.modules.project.element.ProjectSQLElement;
import org.openconcerto.modules.project.element.ProjectStateSQLElement;
import org.openconcerto.modules.project.element.ProjectTypeSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.column.ColumnFooterRenderer;
import org.openconcerto.sql.view.column.ColumnHeaderRenderer;
import org.openconcerto.sql.view.column.ColumnPanel;
import org.openconcerto.sql.view.column.ColumnPanelFetcher;
import org.openconcerto.sql.view.column.ColumnRowRenderer;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.TranslationManager;

public final class Module
extends AbstractModule {
    public static final String PROJECT_TABLENAME = "AFFAIRE";
    private List<String> listTableAffaire = Arrays.asList("SAISIE_VENTE_FACTURE", "AVOIR_CLIENT", "BON_DE_LIVRAISON", "COMMANDE_CLIENT", "DEVIS", "COMMANDE", "SAISIE_ACHAT", "AVOIR_FOURNISSEUR");

    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) {
        super.install(ctxt);
        if (ctxt.getLastInstalledVersion() == null && ctxt.getRoot().getTable(PROJECT_TABLENAME) == null) {
            SQLCreateTable createTableEtatAff = ctxt.getCreateTable("ETAT_AFFAIRE");
            createTableEtatAff.addVarCharColumn("NOM", 128);
            SQLCreateTable createTableType = ctxt.getCreateTable("TYPE_AFFAIRE");
            createTableType.addVarCharColumn("NOM", 256);
            SQLCreateTable createTable = ctxt.getCreateTable(PROJECT_TABLENAME);
            createTable.addVarCharColumn("NUMERO", 256);
            createTable.addVarCharColumn("NOM", 1024);
            createTable.addVarCharColumn("INFOS", 1024);
            createTable.addForeignColumn("ID_CLIENT", ctxt.getRoot().getTable("CLIENT"));
            createTable.addForeignColumn("ID_DEVIS", ctxt.getRoot().getTable("DEVIS"));
            createTable.addColumn("DATE", "date");
            createTable.addForeignColumn("ID_COMMERCIAL", ctxt.getRoot().getTable("COMMERCIAL"));
            createTable.addForeignColumn("ID_ETAT_AFFAIRE", (SQLCreateTableBase)createTableEtatAff);
            createTable.addForeignColumn("ID_TYPE_AFFAIRE", (SQLCreateTableBase)createTableType);
            for (String table : this.listTableAffaire) {
                SQLTable tableDevis = ctxt.getRoot().getTable(table);
                if (tableDevis.getFieldsName().contains("ID_AFFAIRE")) continue;
                AlterTableRestricted alter = ctxt.getAlterTable(table);
                alter.addForeignColumn("ID_AFFAIRE", (SQLCreateTableBase)createTable);
            }
            ctxt.manipulateData((IClosure)new IClosure<DBRoot>(){

                public void executeChecked(DBRoot input) {
                    SQLTable tableAff = input.getTable(Module.PROJECT_TABLENAME);
                    SQLRowValues rowVals = new SQLRowValues(tableAff);
                    try {
                        rowVals.insert();
                    }
                    catch (SQLException exn) {
                        exn.printStackTrace();
                    }
                    SQLTable tableTypeAffaire = input.getTable("TYPE_AFFAIRE");
                    rowVals = new SQLRowValues(tableTypeAffaire);
                    try {
                        rowVals.put("NOM", (Object)"Ind\u00e9fini");
                        rowVals.insert();
                    }
                    catch (SQLException exn) {
                        exn.printStackTrace();
                    }
                    SQLTable tableEtatAffaire = input.getTable("ETAT_AFFAIRE");
                    rowVals = new SQLRowValues(tableEtatAffaire);
                    try {
                        rowVals.put("NOM", (Object)"Ind\u00e9fini");
                        rowVals.insert();
                        rowVals.clear();
                        rowVals.put("NOM", (Object)"A traiter");
                        rowVals.insert();
                        rowVals.clear();
                        rowVals.put("NOM", (Object)"En cours");
                        rowVals.insert();
                        rowVals.clear();
                        rowVals.put("NOM", (Object)"Traitement termin\u00e9");
                        rowVals.insert();
                        rowVals.clear();
                        rowVals.put("NOM", (Object)"A facturer");
                        rowVals.insert();
                        rowVals.clear();
                        rowVals.put("NOM", (Object)"Dossier clos");
                        rowVals.insert();
                    }
                    catch (SQLException exn) {
                        exn.printStackTrace();
                    }
                }
            });
        }
    }

    protected void setupElements(SQLElementDirectory dir) {
        super.setupElements(dir);
        TranslationManager.getInstance().addTranslationStreamFromClass(((Object)((Object)this)).getClass());
        dir.addSQLElement(ProjectSQLElement.class);
        dir.addSQLElement(ProjectStateSQLElement.class);
        dir.addSQLElement(ProjectTypeSQLElement.class);
        final SQLElement element = dir.getElement("DEVIS");
        DevisSQLElement eltDevis = (DevisSQLElement)dir.getElement(DevisSQLElement.class);
        eltDevis.getRowActions().clear();
        eltDevis.addListColumn((SQLTableModelColumn)new BaseSQLTableModelColumn("Temps Total", Double.class){
            SQLTable tableDevisElt;
            {
                this.tableDevisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT").getTable();
            }

            protected Object show_(SQLRowAccessor r) {
                Collection rows = r.getReferentRows(this.tableDevisElt);
                double time = 0.0;
                for (SQLRowAccessor sqlRowAccessor : rows) {
                    time += (double)OrderColumnRowRenderer.getHours(sqlRowAccessor);
                }
                return time;
            }

            public Set<FieldPath> getPaths() {
                SQLTable table = Configuration.getInstance().getDirectory().getElement("DEVIS").getTable();
                Path p = (Path)new Path(table).add(this.tableDevisElt.getField("ID_DEVIS"));
                Path p2 = (Path)((Path)new Path(table).add(this.tableDevisElt.getField("ID_DEVIS"))).addForeignField("ID_UNITE_VENTE");
                return CollectionUtils.createSet((Object[])new FieldPath[]{new FieldPath(p, "QTE"), new FieldPath(p, "QTE_UNITAIRE"), new FieldPath(p2, "CODE")});
            }
        });
        RowAction factureAction = eltDevis.getDevis2FactureAction();
        eltDevis.getRowActions().add(factureAction);
        RowAction commandeAction = eltDevis.getDevis2CmdCliAction();
        eltDevis.getRowActions().add(commandeAction);
        RowAction accepteAction = this.getAcceptAction();
        eltDevis.getRowActions().add(accepteAction);
        RowAction refuseAction = eltDevis.getRefuseAction();
        eltDevis.getRowActions().add(refuseAction);
        RowAction cloneAction = eltDevis.getCloneAction();
        eltDevis.getRowActions().add(cloneAction);
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener(DevisXmlSheet.class);
        mouseSheetXmlListeListener.setGenerateHeader(true);
        mouseSheetXmlListeListener.setShowHeader(true);
        eltDevis.getRowActions().addAll(mouseSheetXmlListeListener.getRowActions());
        element.addComponentFactory("default component code", (ITransformer)new ITransformer<Tuple2<SQLElement, String>, SQLComponent>(){

            public SQLComponent transformChecked(Tuple2<SQLElement, String> input) {
                return new DevisSQLComponent(element){

                    public int insert(SQLRow order) {
                        int id = super.insert(order);
                        Module.this.checkAffaire(id);
                        return id;
                    }

                    public void update() {
                        super.update();
                        Module.this.checkAffaire(this.getSelectedID());
                    }
                };
            }
        });
        final SQLElement elementCmd = dir.getElement("COMMANDE_CLIENT");
        elementCmd.addListColumn((SQLTableModelColumn)new BaseSQLTableModelColumn("Temps Total", Double.class, dir){
            SQLTable tableCmdElt;
            {
                super($anonymous0, $anonymous1);
                this.tableCmdElt = sQLElementDirectory.getElement("COMMANDE_CLIENT_ELEMENT").getTable();
            }

            protected Object show_(SQLRowAccessor r) {
                Collection rows = r.getReferentRows(this.tableCmdElt);
                double time = 0.0;
                for (SQLRowAccessor sqlRowAccessor : rows) {
                    time += (double)OrderColumnRowRenderer.getHours(sqlRowAccessor);
                }
                return time;
            }

            public Set<FieldPath> getPaths() {
                SQLTable table = elementCmd.getTable();
                Path p = (Path)new Path(table).add(this.tableCmdElt.getField("ID_COMMANDE_CLIENT"));
                Path p2 = (Path)((Path)new Path(table).add(this.tableCmdElt.getField("ID_COMMANDE_CLIENT"))).addForeignField("ID_UNITE_VENTE");
                return CollectionUtils.createSet((Object[])new FieldPath[]{new FieldPath(p, "QTE"), new FieldPath(p, "QTE_UNITAIRE"), new FieldPath(p2, "CODE")});
            }
        });
        NumerotationAutoSQLElement.addClass(ProjectSQLElement.class, (String)PROJECT_TABLENAME);
        new QuoteToOrderSQLInjector();
        new QuoteToInvoiceSQLInjector();
        new OrderToInvoiceSQLInjector();
    }

    public void checkAffaire(int id) {
        SQLTable tableDevis = Configuration.getInstance().getRoot().findTable("DEVIS");
        SQLTable tableNum = Configuration.getInstance().getRoot().findTable("NUMEROTATION_AUTO");
        SQLRow row = tableDevis.getRow(id);
        SQLRow rowAffaire = row.getForeign("ID_AFFAIRE");
        if (rowAffaire == null || rowAffaire.isUndefined()) {
            if (row.getInt("ID_ETAT_DEVIS") == 4) {
                SQLTable table = tableDevis.getTable(PROJECT_TABLENAME);
                SQLRowValues rowVals = new SQLRowValues(table);
                String nextNumero = NumerotationAutoSQLElement.getNextNumero(ProjectSQLElement.class);
                rowVals.put("NUMERO", (Object)nextNumero);
                SQLRowValues rowValsNum = new SQLRowValues(tableNum);
                int val = tableNum.getRow(2).getInt(NumerotationAutoSQLElement.getLabelNumberFor(ProjectSQLElement.class));
                rowValsNum.put(NumerotationAutoSQLElement.getLabelNumberFor(ProjectSQLElement.class), (Object)new Integer(++val));
                try {
                    rowValsNum.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                rowVals.put("ID_DEVIS", row.getID());
                rowVals.put("ID_CLIENT", row.getObject("ID_CLIENT"));
                rowVals.put("ID_COMMERCIAL", row.getObject("ID_COMMERCIAL"));
                rowVals.put("DATE", (Object)new Date());
                rowVals.put("ID_ETAT_AFFAIRE", ProjectStateSQLElement.EN_COURS);
                SQLRowValues rowValsDevis = row.asRowValues();
                rowValsDevis.put("ID_AFFAIRE", (Object)rowVals);
                try {
                    rowVals.commit();
                }
                catch (SQLException exn) {
                    exn.printStackTrace();
                }
            }
        } else {
            SQLRowValues rowVals = rowAffaire.asRowValues();
            rowVals.putEmptyLink("ID_DEVIS");
            try {
                rowVals.update();
            }
            catch (SQLException exn) {
                exn.printStackTrace();
            }
        }
    }

    public RowAction getAcceptAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get((EventObject)e).getSelectedRow().asRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                selectedRow.getTable().fireTableModified(selectedRow.getID());
                Module.this.checkAffaire(selectedRow.getID());
            }
        }, false, "project.accept"){

            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    protected void setupComponents(ComponentsContext ctxt) {
        for (String table : this.listTableAffaire) {
            if (table.equalsIgnoreCase("DEVIS")) continue;
            ctxt.putAdditionalField(table, "ID_AFFAIRE");
        }
    }

    protected void setupMenu(final MenuContext ctxt) {
        ctxt.addMenuItem((Action)new CreateFrameAbstractAction("Liste des affaires"){

            public JFrame createFrame() {
                IListFrame frame = new IListFrame((IListPanel)new ListeAddPanel(ctxt.getElement(Module.PROJECT_TABLENAME)));
                return frame;
            }
        }, "menu.list");
        ctxt.addMenuItem((Action)new CreateFrameAbstractAction("Historique des affaires"){

            public JFrame createFrame() {
                ProjectHistory histo = new ProjectHistory();
                return histo.getFrame();
            }
        }, "menu.list");
        ctxt.addMenuItem((Action)new CreateFrameAbstractAction("Saisie affaire"){

            public JFrame createFrame() {
                return new EditFrame(ctxt.getElement(Module.PROJECT_TABLENAME));
            }
        }, "menu.create");
    }

    protected void start() {
        JComponent quoteComponent = this.createQuotePanel();
        JComponent orderComponent = this.createOrderPanel();
        MainFrame.getInstance().getTabbedPane().addTab("Commandes en cours", orderComponent);
        MainFrame.getInstance().getTabbedPane().addTab("Devis en attente", quoteComponent);
        MainFrame.getInstance().getTabbedPane().addTab("Affaires", (JComponent)new ListeAddPanel(Configuration.getInstance().getDirectory().getElement(PROJECT_TABLENAME)));
        quoteComponent.setOpaque(true);
        quoteComponent.setBackground(Color.WHITE);
        orderComponent.setOpaque(true);
        orderComponent.setBackground(Color.WHITE);
        MainFrame.getInstance().getTabbedPane().setSelectedIndex(1);
        CommandeClientItemTable.getVisibilityMap().put("POURCENT_ACOMPTE", Boolean.TRUE);
        SaisieVenteFactureItemTable.getVisibilityMap().put("POURCENT_ACOMPTE", Boolean.TRUE);
        AccountingRecordsProvider p = new AccountingRecordsProvider(){

            public void putLabel(SQLRowAccessor rowSource, Map<String, Object> values) {
                values.put("NOM", "Fact. vente " + rowSource.getString("NUMERO"));
            }

            public void putPieceLabel(SQLRowAccessor rowSource, SQLRowValues rowValsPiece) {
                rowValsPiece.put("NOM", (Object)rowSource.getString("NUMERO"));
            }
        };
        AccountingRecordsProviderManager.put((String)"accounting.records.invoice.sales", (AccountingRecordsProvider)p);
    }

    private JComponent createQuotePanel() {
        QuoteColumnRowRenderer cRenderer = new QuoteColumnRowRenderer();
        QuoteColumnFooterRenderer fRenderer = new QuoteColumnFooterRenderer();
        ColumnPanel columnPanel = new ColumnPanel(220, (ColumnRowRenderer)cRenderer, (ColumnFooterRenderer)fRenderer);
        columnPanel.setOpaque(false);
        SQLElement element = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        Path p = (Path)((Path)Path.get((SQLTable)element.getTable()).addForeignField("ID_ARTICLE")).addForeignField("ID_FAMILLE_ARTICLE");
        SQLRowValues values = new SQLRowValues(element.getTable());
        values.put("NOM", null);
        values.put("T_PV_HT", null);
        SQLRowValues rowValsClient = new SQLRowValues(element.getTable().getTable("CLIENT"));
        rowValsClient.put("NOM", null);
        final SQLTable tableDevis = element.getTable().getTable("DEVIS");
        SQLRowValues rowValsDevis = new SQLRowValues(tableDevis);
        rowValsDevis.put("NUMERO", null);
        rowValsDevis.put("DATE", null);
        rowValsDevis.put("T_HT", null);
        rowValsDevis.put("ID_CLIENT", (Object)rowValsClient);
        values.put("ID_DEVIS", (Object)rowValsDevis);
        values.put("ID_ARTICLE", (Object)new SQLRowValues(element.getTable().getTable("ARTICLE")).put("ID_FAMILLE_ARTICLE", (Object)new SQLRowValues(element.getTable().getTable("FAMILLE_ARTICLE"))));
        SQLRowValues rowValsUnite = new SQLRowValues(element.getTable().getTable("UNITE_VENTE"));
        rowValsUnite.put("CODE", null);
        values.put("ID_UNITE_VENTE", (Object)rowValsUnite);
        values.put("QTE", null);
        values.put("QTE_UNITAIRE", null);
        ITransformer<SQLSelect, SQLSelect> t = new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect input) {
                input.andWhere(new Where(input.getAlias(tableDevis.getField("ID_ETAT_DEVIS")), "=", 2));
                return input;
            }
        };
        ColumnPanelFetcher projectFetcher = new ColumnPanelFetcher(values, new FieldPath(p, "NOM"), (ITransformer)t);
        columnPanel.setHeaderRenderer((ColumnHeaderRenderer)new TotalHeaderRenderer());
        columnPanel.setFetch(projectFetcher);
        JScrollPane comp = new JScrollPane((Component)columnPanel);
        comp.setBorder(null);
        comp.getViewport().setOpaque(false);
        return comp;
    }

    private JComponent createOrderPanel() {
        OrderColumnRowRenderer cRenderer = new OrderColumnRowRenderer();
        OrderColumnFooterRenderer fRenderer = new OrderColumnFooterRenderer();
        ColumnPanel columnPanel = new ColumnPanel(220, (ColumnRowRenderer)cRenderer, (ColumnFooterRenderer)fRenderer);
        columnPanel.setOpaque(false);
        SQLElement element = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
        SQLTable tableOrder = element.getTable();
        Path p = (Path)((Path)Path.get((SQLTable)tableOrder).addForeignField("ID_ARTICLE")).addForeignField("ID_FAMILLE_ARTICLE");
        SQLRowValues values = new SQLRowValues(tableOrder);
        values.put("NOM", null);
        values.put("T_PV_HT", null);
        SQLRowValues rowValsClient = new SQLRowValues(tableOrder.getTable("CLIENT"));
        rowValsClient.put("NOM", null);
        SQLRowValues rowValsCmd = new SQLRowValues(tableOrder.getTable("COMMANDE_CLIENT"));
        rowValsCmd.put("NUMERO", null);
        rowValsCmd.put("DATE", null);
        rowValsCmd.put("T_HT", null);
        rowValsCmd.put("ID_CLIENT", (Object)rowValsClient);
        values.put("ID_COMMANDE_CLIENT", (Object)rowValsCmd);
        values.put("ID_ARTICLE", (Object)new SQLRowValues(tableOrder.getTable("ARTICLE")).put("ID_FAMILLE_ARTICLE", (Object)new SQLRowValues(tableOrder.getTable("FAMILLE_ARTICLE"))));
        SQLRowValues rowValsUnite = new SQLRowValues(tableOrder.getTable("UNITE_VENTE"));
        rowValsUnite.put("CODE", null);
        values.put("ID_UNITE_VENTE", (Object)rowValsUnite);
        values.put("QTE", null);
        values.put("QTE_UNITAIRE", null);
        final SQLTable tableAffaire = tableOrder.getTable(PROJECT_TABLENAME);
        SQLRowValues rowValsAffaire = new SQLRowValues(tableAffaire);
        rowValsAffaire.put("NUMERO", null);
        rowValsAffaire.put("DATE", null);
        rowValsCmd.put("ID_AFFAIRE", (Object)rowValsAffaire);
        if (tableOrder.getDBRoot().contains("AFFAIRE_TEMPS")) {
            SQLTable tableAffaireTemps = tableOrder.getTable("AFFAIRE_TEMPS");
            SQLRowValues rowValsAffaireTemps = new SQLRowValues(tableAffaireTemps);
            rowValsAffaireTemps.put("TEMPS", null);
            rowValsAffaireTemps.put("ID_COMMANDE_CLIENT_ELEMENT", (Object)values);
        }
        ITransformer<SQLSelect, SQLSelect> t = new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect input) {
                input.andWhere(new Where(input.getAlias(tableAffaire.getField("ID_ETAT_AFFAIRE")), "=", ProjectStateSQLElement.EN_COURS));
                return input;
            }
        };
        ColumnPanelFetcher projectFetcher = new ColumnPanelFetcher(values, new FieldPath(p, "NOM"), (ITransformer)t);
        columnPanel.setHeaderRenderer((ColumnHeaderRenderer)new TotalHeaderRenderer());
        columnPanel.setFetch(projectFetcher);
        JScrollPane comp = new JScrollPane((Component)columnPanel);
        comp.setBorder(null);
        comp.getViewport().setOpaque(false);
        return comp;
    }

    protected void stop() {
    }
}

