/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.google.docs;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModulePreferencePanelDesc;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.erp.storage.StorageEngines;
import org.openconcerto.modules.google.docs.GoogleDocsListAction;
import org.openconcerto.modules.google.docs.GoogleDocsPreferencePanel;
import org.openconcerto.modules.google.docs.GoogleDocsStorageEngine;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.ui.preferences.PreferencePanel;

public final class Module
extends AbstractModule {
    private final GoogleDocsStorageEngine engine = new GoogleDocsStorageEngine();

    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) throws SQLException, IOException {
        super.install(ctxt);
    }

    protected void setupElements(SQLElementDirectory dir) {
        super.setupElements(dir);
    }

    protected void setupComponents(ComponentsContext ctxt) {
        ctxt.addListAction("SAISIE_VENTE_FACTURE", (IListeAction)new GoogleDocsListAction());
        ctxt.addListAction("DEVIS", (IListeAction)new GoogleDocsListAction());
    }

    protected void start() {
        StorageEngines.getInstance().addEngine((StorageEngine)this.engine);
    }

    public List<ModulePreferencePanelDesc> getPrefDescriptors(DBRoot root) {
        return Arrays.asList(new ModulePreferencePanelDesc("Google Docs"){

            protected PreferencePanel createPanel() {
                return new GoogleDocsPreferencePanel();
            }
        });
    }

    protected void stop() {
        StorageEngines.getInstance().removeEngine((StorageEngine)this.engine);
    }
}

