/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.google.docs;

import com.google.gdata.client.GoogleAuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Query;
import com.google.gdata.client.docs.DocsService;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.client.media.ResumableGDataFileUploader;
import com.google.gdata.client.uploader.ProgressListener;
import com.google.gdata.client.uploader.ResumableHttpFileUploader;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.acl.AclEntry;
import com.google.gdata.data.acl.AclFeed;
import com.google.gdata.data.acl.AclRole;
import com.google.gdata.data.acl.AclScope;
import com.google.gdata.data.docs.DocumentEntry;
import com.google.gdata.data.docs.DocumentListEntry;
import com.google.gdata.data.docs.DocumentListFeed;
import com.google.gdata.data.docs.FolderEntry;
import com.google.gdata.data.docs.PresentationEntry;
import com.google.gdata.data.docs.RevisionFeed;
import com.google.gdata.data.docs.SpreadsheetEntry;
import com.google.gdata.data.media.IMediaContent;
import com.google.gdata.data.media.MediaFileSource;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class GoogleDocsUtils {
    public DocsService service;
    public GoogleService spreadsheetsService;
    public static final String DEFAULT_HOST = "docs.google.com";
    public static final String SPREADSHEETS_SERVICE_NAME = "wise";
    public static final String SPREADSHEETS_HOST = "spreadsheets.google.com";
    private final String URL_FEED = "/feeds";
    private final String URL_DOWNLOAD = "/download";
    private final String URL_DOCLIST_FEED = "/private/full";
    private final String URL_DEFAULT = "/default";
    private final String URL_FOLDERS = "/contents";
    private final String URL_ACL = "/acl";
    private final String URL_REVISIONS = "/revisions";
    private final String URL_CATEGORY_DOCUMENT = "/-/document";
    private final String URL_CATEGORY_SPREADSHEET = "/-/spreadsheet";
    private final String URL_CATEGORY_PDF = "/-/pdf";
    private final String URL_CATEGORY_PRESENTATION = "/-/presentation";
    private final String URL_CATEGORY_STARRED = "/-/starred";
    private final String URL_CATEGORY_TRASHED = "/-/trashed";
    private final String URL_CATEGORY_FOLDER = "/-/folder";
    private final String URL_CATEGORY_EXPORT = "/Export";
    private final String PARAMETER_SHOW_FOLDERS = "showfolders=true";
    private String host;
    private final Map<String, String> DOWNLOAD_DOCUMENT_FORMATS = new HashMap<String, String>();
    private final Map<String, String> DOWNLOAD_PRESENTATION_FORMATS;
    private final Map<String, String> DOWNLOAD_SPREADSHEET_FORMATS;

    public GoogleDocsUtils(String applicationName) {
        this(applicationName, DEFAULT_HOST);
    }

    public GoogleDocsUtils(String applicationName, String host) {
        this.DOWNLOAD_DOCUMENT_FORMATS.put("doc", "doc");
        this.DOWNLOAD_DOCUMENT_FORMATS.put("txt", "txt");
        this.DOWNLOAD_DOCUMENT_FORMATS.put("odt", "odt");
        this.DOWNLOAD_DOCUMENT_FORMATS.put("pdf", "pdf");
        this.DOWNLOAD_DOCUMENT_FORMATS.put("png", "png");
        this.DOWNLOAD_DOCUMENT_FORMATS.put("rtf", "rtf");
        this.DOWNLOAD_DOCUMENT_FORMATS.put("html", "html");
        this.DOWNLOAD_DOCUMENT_FORMATS.put("zip", "zip");
        this.DOWNLOAD_PRESENTATION_FORMATS = new HashMap<String, String>();
        this.DOWNLOAD_PRESENTATION_FORMATS.put("pdf", "pdf");
        this.DOWNLOAD_PRESENTATION_FORMATS.put("png", "png");
        this.DOWNLOAD_PRESENTATION_FORMATS.put("ppt", "ppt");
        this.DOWNLOAD_PRESENTATION_FORMATS.put("swf", "swf");
        this.DOWNLOAD_PRESENTATION_FORMATS.put("txt", "txt");
        this.DOWNLOAD_SPREADSHEET_FORMATS = new HashMap<String, String>();
        this.DOWNLOAD_SPREADSHEET_FORMATS.put("xls", "xls");
        this.DOWNLOAD_SPREADSHEET_FORMATS.put("ods", "ods");
        this.DOWNLOAD_SPREADSHEET_FORMATS.put("pdf", "pdf");
        this.DOWNLOAD_SPREADSHEET_FORMATS.put("csv", "csv");
        this.DOWNLOAD_SPREADSHEET_FORMATS.put("tsv", "tsv");
        this.DOWNLOAD_SPREADSHEET_FORMATS.put("html", "html");
        if (host == null) {
            throw new IllegalArgumentException("null passed in required parameters");
        }
        this.service = new DocsService(applicationName);
        this.spreadsheetsService = new GoogleService(SPREADSHEETS_SERVICE_NAME, applicationName);
        this.host = host;
    }

    public void login(String user, String pass) throws AuthenticationException {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Identifiant manquant");
        }
        if (pass == null || pass.isEmpty()) {
            throw new IllegalArgumentException("Mot de passe manquant");
        }
        this.service.setUserCredentials(user, pass);
        this.spreadsheetsService.setUserCredentials(user, pass);
    }

    public void loginWithAuthSubToken(String token) throws AuthenticationException {
        if (token == null) {
            throw new IllegalArgumentException("null login credentials");
        }
        this.service.setAuthSubToken(token);
        this.spreadsheetsService.setAuthSubToken(token);
    }

    public DocumentListEntry createNew(String title, String type) throws MalformedURLException, IOException, ServiceException {
        DocumentEntry newEntry;
        if (title == null || type == null) {
            throw new IllegalArgumentException("null title or type");
        }
        if (type.equals("document")) {
            newEntry = new DocumentEntry();
        } else if (type.equals("presentation")) {
            newEntry = new PresentationEntry();
        } else if (type.equals("spreadsheet")) {
            newEntry = new SpreadsheetEntry();
        } else if (type.equals("folder")) {
            newEntry = new FolderEntry();
        } else {
            throw new IllegalArgumentException("unsupported type");
        }
        newEntry.setTitle((TextConstruct)new PlainTextConstruct(title));
        return (DocumentListEntry)this.service.insert(this.buildUrl("/default/private/full"), (IEntry)newEntry);
    }

    public DocumentListFeed getDocsListFeed(String category) throws IOException, MalformedURLException, ServiceException {
        URL url;
        if (category == null) {
            throw new IllegalArgumentException("null category");
        }
        if (category.equals("all")) {
            url = this.buildUrl("/default/private/full");
        } else if (category.equals("folders")) {
            String[] parameters = new String[]{"showfolders=true"};
            url = this.buildUrl("/default/private/full/-/folder", parameters);
        } else if (category.equals("documents")) {
            url = this.buildUrl("/default/private/full/-/document");
        } else if (category.equals("spreadsheets")) {
            url = this.buildUrl("/default/private/full/-/spreadsheet");
        } else if (category.equals("pdfs")) {
            url = this.buildUrl("/default/private/full/-/pdf");
        } else if (category.equals("presentations")) {
            url = this.buildUrl("/default/private/full/-/presentation");
        } else if (category.equals("starred")) {
            url = this.buildUrl("/default/private/full/-/starred");
        } else if (category.equals("trashed")) {
            url = this.buildUrl("/default/private/full/-/trashed");
        } else {
            return null;
        }
        return (DocumentListFeed)this.service.getFeed(url, DocumentListFeed.class);
    }

    public DocumentListEntry getDocsListEntry(String resourceId) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null) {
            throw new IllegalArgumentException("null resourceId");
        }
        URL url = this.buildUrl("/default/private/full/" + resourceId);
        return (DocumentListEntry)this.service.getEntry(url, DocumentListEntry.class);
    }

    public DocumentListFeed getFolderDocsListFeed(String folderResourceId) throws IOException, MalformedURLException, ServiceException {
        if (folderResourceId == null) {
            throw new IllegalArgumentException("null folderResourceId");
        }
        URL url = this.buildUrl("/default/private/full/" + folderResourceId + "/contents");
        return (DocumentListFeed)this.service.getFeed(url, DocumentListFeed.class);
    }

    public RevisionFeed getRevisionsFeed(String resourceId) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null) {
            throw new IllegalArgumentException("null resourceId");
        }
        URL url = this.buildUrl("/default/private/full/" + resourceId + "/revisions");
        return (RevisionFeed)this.service.getFeed(url, RevisionFeed.class);
    }

    public DocumentListFeed search(Map<String, String> searchParameters) throws IOException, MalformedURLException, ServiceException {
        return this.search(searchParameters, null);
    }

    public DocumentListFeed search(Map<String, String> searchParameters, String category) throws IOException, MalformedURLException, ServiceException {
        URL url;
        if (searchParameters == null) {
            throw new IllegalArgumentException("searchParameters null");
        }
        if (category == null || category.equals("")) {
            url = this.buildUrl("/default/private/full");
        } else if (category.equals("documents")) {
            url = this.buildUrl("/default/private/full/-/document");
        } else if (category.equals("spreadsheets")) {
            url = this.buildUrl("/default/private/full/-/spreadsheet");
        } else if (category.equals("presentations")) {
            url = this.buildUrl("/default/private/full/-/presentation");
        } else if (category.equals("starred")) {
            url = this.buildUrl("/default/private/full/-/starred");
        } else if (category.equals("trashed")) {
            url = this.buildUrl("/default/private/full/-/trashed");
        } else if (category.equals("folders")) {
            url = this.buildUrl("/default/private/full/-/folder");
        } else {
            throw new IllegalArgumentException("invaild category");
        }
        Query qry = new Query(url);
        for (String key : searchParameters.keySet()) {
            qry.setStringCustomParameter(key, searchParameters.get(key));
        }
        return (DocumentListFeed)this.service.query(qry, DocumentListFeed.class);
    }

    public DocumentListEntry uploadFile(File file, String remotePath, String title, boolean synchronous) throws Exception {
        if (file == null || title == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        p.add((Component)new JLabel(String.valueOf(remotePath) + "/" + title), c);
        ++c.gridx;
        final JProgressBar bar = new JProgressBar(0, 100);
        p.add((Component)bar, c);
        final JFrame f = new JFrame("Envoi vers Google Docs");
        f.setIconImage(new ImageIcon(this.getClass().getResource("icon.png")).getImage());
        f.setContentPane(p);
        f.setResizable(false);
        f.pack();
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        int j = 0;
        while (j < gs.length) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            int i = 0;
            while (i < gc.length) {
                virtualBounds = virtualBounds.union(gc[i].getBounds());
                ++i;
            }
            ++j;
        }
        int x = (int)virtualBounds.getMaxX();
        int y = (int)(virtualBounds.getMaxY() - 32.0);
        f.setLocation(x - f.getWidth(), y - f.getHeight());
        f.setVisible(true);
        ProgressListener listener = new ProgressListener(){

            public void progressChanged(final ResumableHttpFileUploader uploader) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        bar.setValue((int)(uploader.getProgress() * 100.0));
                        if (uploader.getProgress() >= 1.0 || uploader.isDone()) {
                            f.dispose();
                        }
                    }
                });
            }
        };
        DocumentListEntry rFolder = this.getRemoteFolderByPath(remotePath);
        DocumentEntry newDocument = new DocumentEntry();
        newDocument.setTitle((TextConstruct)new PlainTextConstruct(title));
        DocumentListEntry existingDocumentEntry = this.findDocumentIn(rFolder, newDocument.getTitle());
        if (existingDocumentEntry != null) {
            this.trashObject(existingDocumentEntry.getResourceId(), false);
        }
        String mimeType = DocumentListEntry.MediaType.fromFileName((String)file.getName()).getMimeType();
        MediaFileSource ms = new MediaFileSource(file, mimeType);
        int PROGRESS_UPDATE_INTERVAL = 500;
        String spec = "https://docs.google.com/feeds/upload/create-session/default/private/full/" + rFolder.getResourceId() + "/contents";
        ResumableGDataFileUploader.Builder builder = new ResumableGDataFileUploader.Builder((MediaService)this.service, new URL(spec), ms, (IEntry)newDocument);
        builder.title(title);
        builder.requestType(ResumableGDataFileUploader.RequestType.INSERT);
        builder.trackProgress(listener, 500L).build();
        ResumableGDataFileUploader uploader = builder.build();
        uploader.start();
        if (synchronous) {
            while (!uploader.isDone()) {
                Thread.sleep(500L);
            }
        }
        return newDocument;
    }

    public DocumentListEntry findDocumentIn(DocumentListEntry rFolder, TextConstruct title) throws MalformedURLException, IOException, ServiceException {
        DocumentListFeed feed = this.getFolderDocsListFeed(rFolder.getResourceId());
        List entries = feed.getEntries();
        for (DocumentListEntry documentListEntry : entries) {
            if (!documentListEntry.getTitle().getPlainText().equals(title.getPlainText())) continue;
            return documentListEntry;
        }
        return null;
    }

    public void trashObject(String resourceId, boolean delete) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null) {
            throw new IllegalArgumentException("null resourceId");
        }
        String feedUrl = "/default/private/full/" + resourceId;
        if (delete) {
            feedUrl = String.valueOf(feedUrl) + "?delete=true";
        }
        this.service.delete(this.buildUrl(feedUrl), this.getDocsListEntry(resourceId).getEtag());
    }

    public void removeFromFolder(String resourceId, String folderResourceId) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null || folderResourceId == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        URL url = this.buildUrl("/default/private/full/" + folderResourceId + "/contents" + "/" + resourceId);
        this.service.delete(url, this.getDocsListEntry(resourceId).getEtag());
    }

    public void downloadFile(URL exportUrl, String filepath) throws IOException, MalformedURLException, ServiceException {
        if (exportUrl == null || filepath == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        MediaContent mc = new MediaContent();
        mc.setUri(exportUrl.toString());
        MediaSource ms = this.service.getMedia((IMediaContent)mc);
        InputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            int c;
            inStream = ms.getInputStream();
            outStream = new FileOutputStream(filepath);
            while ((c = inStream.read()) != -1) {
                outStream.write(c);
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
    }

    public void downloadSpreadsheet(String resourceId, String filepath, String format) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null || filepath == null || format == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        GoogleAuthTokenFactory.UserToken docsToken = (GoogleAuthTokenFactory.UserToken)this.service.getAuthTokenFactory().getAuthToken();
        GoogleAuthTokenFactory.UserToken spreadsheetsToken = (GoogleAuthTokenFactory.UserToken)this.spreadsheetsService.getAuthTokenFactory().getAuthToken();
        this.service.setUserToken(spreadsheetsToken.getValue());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", resourceId.substring(resourceId.lastIndexOf(58) + 1));
        parameters.put("exportFormat", format);
        if (format.equals(this.DOWNLOAD_SPREADSHEET_FORMATS.get("csv")) || format.equals(this.DOWNLOAD_SPREADSHEET_FORMATS.get("tsv"))) {
            parameters.put("gid", "0");
        }
        URL url = this.buildUrl(SPREADSHEETS_HOST, "/download/spreadsheets/Export", parameters);
        this.downloadFile(url, filepath);
        this.service.setUserToken(docsToken.getValue());
    }

    public void downloadDocument(String resourceId, String filepath, String format) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null || filepath == null || format == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        String[] parameters = new String[]{"docID=" + resourceId, "exportFormat=" + format};
        URL url = this.buildUrl("/download/documents/Export", parameters);
        this.downloadFile(url, filepath);
    }

    public void downloadPresentation(String resourceId, String filepath, String format) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null || filepath == null || format == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        String[] parameters = new String[]{"docID=" + resourceId, "exportFormat=" + format};
        URL url = this.buildUrl("/download/presentations/Export", parameters);
        this.downloadFile(url, filepath);
    }

    public DocumentListEntry moveObjectToFolder(String resourceId, String folderId) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null || folderId == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        DocumentListEntry doc = new DocumentListEntry();
        doc.setId(this.buildUrl("/default/private/full/" + resourceId).toString());
        URL url = this.buildUrl("/default/private/full/" + folderId + "/contents");
        return (DocumentListEntry)this.service.insert(url, (IEntry)doc);
    }

    public AclFeed getAclFeed(String resourceId) throws IOException, MalformedURLException, ServiceException {
        if (resourceId == null) {
            throw new IllegalArgumentException("null resourceId");
        }
        URL url = this.buildUrl("/default/private/full/" + resourceId + "/acl");
        return (AclFeed)this.service.getFeed(url, AclFeed.class);
    }

    public AclEntry addAclRole(AclRole role, AclScope scope, String resourceId) throws IOException, MalformedURLException, ServiceException {
        if (role == null || scope == null || resourceId == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        AclEntry entry = new AclEntry();
        entry.setRole(role);
        entry.setScope(scope);
        URL url = this.buildUrl("/default/private/full/" + resourceId + "/acl");
        return (AclEntry)this.service.insert(url, (IEntry)entry);
    }

    public AclEntry changeAclRole(AclRole role, AclScope scope, String resourceId) throws IOException, ServiceException {
        if (role == null || scope == null || resourceId == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        URL url = this.buildUrl("/default/private/full/" + resourceId + "/acl");
        return this.service.update(url, scope, role);
    }

    public void removeAclRole(String scope, String email, String resourceId) throws IOException, MalformedURLException, ServiceException {
        if (scope == null || email == null || resourceId == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        URL url = this.buildUrl("/default/private/full/" + resourceId + "/acl" + "/" + scope + "%3A" + email);
        this.service.delete(url);
    }

    public String getDownloadFormat(String resourceId, String ext) {
        if (resourceId == null || ext == null) {
            throw new IllegalArgumentException("null passed in for required parameters");
        }
        if (resourceId.indexOf("document") == 0) {
            if (this.DOWNLOAD_DOCUMENT_FORMATS.containsKey(ext)) {
                return this.DOWNLOAD_DOCUMENT_FORMATS.get(ext);
            }
        } else if (resourceId.indexOf("presentation") == 0) {
            if (this.DOWNLOAD_PRESENTATION_FORMATS.containsKey(ext)) {
                return this.DOWNLOAD_PRESENTATION_FORMATS.get(ext);
            }
        } else if (resourceId.indexOf("spreadsheet") == 0 && this.DOWNLOAD_SPREADSHEET_FORMATS.containsKey(ext)) {
            return this.DOWNLOAD_SPREADSHEET_FORMATS.get(ext);
        }
        throw new IllegalArgumentException("invalid document type");
    }

    public String getResourceIdSuffix(String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("null resourceId");
        }
        if (resourceId.indexOf("%3A") != -1) {
            return resourceId.substring(resourceId.lastIndexOf("%3A") + 3);
        }
        if (resourceId.indexOf(":") != -1) {
            return resourceId.substring(resourceId.lastIndexOf(":") + 1);
        }
        throw new IllegalArgumentException("Bad resourceId");
    }

    public String getResourceIdPrefix(String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("null resourceId");
        }
        if (resourceId.indexOf("%3A") != -1) {
            return resourceId.substring(0, resourceId.indexOf("%3A"));
        }
        if (resourceId.indexOf(":") != -1) {
            return resourceId.substring(0, resourceId.indexOf(":"));
        }
        throw new IllegalArgumentException("Bad resourceId");
    }

    private URL buildUrl(String path) throws MalformedURLException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        return this.buildUrl(path, null);
    }

    private URL buildUrl(String path, String[] parameters) throws MalformedURLException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        return this.buildUrl(this.host, path, parameters);
    }

    private URL buildUrl(String domain, String path, String[] parameters) throws MalformedURLException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        StringBuffer url = new StringBuffer();
        url.append("https://" + domain + "/feeds" + path);
        if (parameters != null && parameters.length > 0) {
            url.append("?");
            int i = 0;
            while (i < parameters.length) {
                url.append(parameters[i]);
                if (i != parameters.length - 1) {
                    url.append("&");
                }
                ++i;
            }
        }
        return new URL(url.toString());
    }

    private URL buildUrl(String domain, String path, Map<String, String> parameters) throws MalformedURLException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        StringBuffer url = new StringBuffer();
        url.append("https://" + domain + "/feeds" + path);
        if (parameters != null && parameters.size() > 0) {
            Set<Map.Entry<String, String>> params = parameters.entrySet();
            Iterator<Map.Entry<String, String>> itr = params.iterator();
            url.append("?");
            while (itr.hasNext()) {
                Map.Entry<String, String> entry = itr.next();
                url.append(String.valueOf(entry.getKey()) + "=" + entry.getValue());
                if (!itr.hasNext()) continue;
                url.append("&");
            }
        }
        return new URL(url.toString());
    }

    public DocumentListFeed getRootFolders() {
        DocumentListFeed results = new DocumentListFeed();
        try {
            DocumentListFeed docs = this.getDocsListFeed("folders");
            ArrayList<DocumentListEntry> list = new ArrayList<DocumentListEntry>();
            for (DocumentListEntry doc : docs.getEntries()) {
                if (!doc.getParentLinks().isEmpty()) continue;
                list.add(doc);
            }
            results.setEntries(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    protected DocumentListEntry documentListFindByTitle(String title, DocumentListFeed documentListFeed) {
        for (DocumentListEntry doc : documentListFeed.getEntries()) {
            if (!doc.getTitle().getPlainText().equals(title)) continue;
            return doc;
        }
        return null;
    }

    public DocumentListEntry getRemoteFolderByPath(String path) {
        if (path == null || path.length() < 1) {
            return null;
        }
        String[] pathArray = path.split("/");
        DocumentListFeed remoteSubFolders = this.getRootFolders();
        DocumentListEntry parentRemoteFolder = null;
        DocumentListEntry currentRemoteFolder = null;
        int i = 0;
        while (i < pathArray.length) {
            String folder = pathArray[i];
            if (!folder.isEmpty()) {
                currentRemoteFolder = this.documentListFindByTitle(folder, remoteSubFolders);
                if (currentRemoteFolder == null || !currentRemoteFolder.getType().equals("folder")) {
                    try {
                        currentRemoteFolder = parentRemoteFolder == null ? this.createNew(folder, "folder") : this.createNewSubFolder(folder, parentRemoteFolder.getResourceId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                remoteSubFolders = this.getSubFolders(currentRemoteFolder);
                parentRemoteFolder = currentRemoteFolder;
            }
            ++i;
        }
        return currentRemoteFolder;
    }

    public DocumentListFeed getSubFolders(String folderResourceId) throws IOException, MalformedURLException, ServiceException {
        if (folderResourceId == null) {
            throw new IllegalArgumentException("null folderResourceId");
        }
        String[] parameters = new String[]{"showfolders=true"};
        URL url = this.buildUrl("/default/private/full/" + folderResourceId + "/contents" + "/-/folder", parameters);
        return (DocumentListFeed)this.service.getFeed(url, DocumentListFeed.class);
    }

    public DocumentListFeed getSubFolders(DocumentListEntry folder) {
        DocumentListFeed results = null;
        if (folder == null) {
            return this.getRootFolders();
        }
        try {
            results = this.getSubFolders(folder.getResourceId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public DocumentListEntry createNewSubFolder(String title, String folderResourceId) throws IOException, ServiceException {
        FolderEntry newEntry = new FolderEntry();
        newEntry.setTitle((TextConstruct)new PlainTextConstruct(title));
        URL url = this.buildUrl("/default/private/full/" + folderResourceId + "/contents");
        return (DocumentListEntry)this.service.insert(url, (IEntry)newEntry);
    }
}

