/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.google.docs;

import com.google.gdata.util.AuthenticationException;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openconcerto.erp.preferences.DefaultLocalPreferencePanel;
import org.openconcerto.modules.google.docs.GoogleDocsUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class GoogleDocsPreferencePanel
extends DefaultLocalPreferencePanel {
    public static final String SHOW_MENU = "showMenu";
    public static final String AUTO = "auto";
    public static final String ACCOUNT_PASSWORD = "accountPassword";
    public static final String ACCOUNT_LOGIN = "accountLogin";
    public static final String GOOGLE_DOCS_PROPERTIES = "googledocs.properties";
    final JTextField textAccountLogin = new JTextField();
    final JPasswordField textAccountPassword = new JPasswordField();
    final JCheckBox checkAuto = new JCheckBox("Sauvegarder automatiquement les documents g\u00e9n\u00e9r\u00e9s");
    final JCheckBox checkShowMenu = new JCheckBox("Activer le menu contextuel (clic droit sur les listes)");

    public GoogleDocsPreferencePanel() {
        super("Google Docs", GOOGLE_DOCS_PROPERTIES);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add(new JLabel("Identifiant Google", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add(this.textAccountLogin, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add(new JLabel("Mot de passe", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add(this.textAccountPassword, c);
        c.fill = 2;
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add(this.checkAuto, c);
        c.gridx = 0;
        ++c.gridy;
        this.add(this.checkShowMenu, c);
        c.gridx = 0;
        ++c.gridy;
        JButton bTest = new JButton("Tester les param\u00e8tres");
        bTest.setOpaque(false);
        c.fill = 0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.anchor = 12;
        this.add(bTest, c);
        bTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GoogleDocsUtils ll = new GoogleDocsUtils("OpenConcerto");
                            ll.login((this).GoogleDocsPreferencePanel.this.textAccountLogin.getText(), new String((this).GoogleDocsPreferencePanel.this.textAccountPassword.getPassword()));
                            File f = File.createTempFile("test_ovh", "openconcerto.txt");
                            FileOutputStream fOut = new FileOutputStream(f);
                            fOut.write("OpenConcerto".getBytes());
                            fOut.flush();
                            fOut.close();
                            ll.uploadFile(f, "OpenConcerto/Devis/2010", "Test Google Docs", true);
                            JOptionPane.showMessageDialog((Component)((Object)GoogleDocsPreferencePanel.this), "Connexion r\u00e9ussie");
                        }
                        catch (AuthenticationException e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog((Component)((Object)GoogleDocsPreferencePanel.this), "Identifiant ou mot de passe invalide");
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                            JOptionPane.showMessageDialog((Component)((Object)GoogleDocsPreferencePanel.this), e1.getMessage());
                        }
                    }
                });
                t.setDaemon(true);
                t.setName("Test Google Docs");
                t.start();
            }
        });
        this.textAccountLogin.setText(this.properties.getProperty(ACCOUNT_LOGIN, ""));
        this.textAccountPassword.setText(this.properties.getProperty(ACCOUNT_PASSWORD, ""));
        this.checkAuto.setSelected(this.properties.getProperty(AUTO, "true").equals("true"));
        this.checkShowMenu.setSelected(this.properties.getProperty(SHOW_MENU, "false").equals("true"));
    }

    public void storeValues() {
        this.properties.setProperty(ACCOUNT_LOGIN, this.textAccountLogin.getText());
        this.properties.setProperty(ACCOUNT_PASSWORD, String.valueOf(this.textAccountPassword.getPassword()));
        this.properties.setProperty(AUTO, String.valueOf(this.checkAuto.isSelected()));
        this.properties.setProperty(SHOW_MENU, String.valueOf(this.checkShowMenu.isSelected()));
        super.storeValues();
    }

    public void restoreToDefaults() {
        this.textAccountLogin.setText("");
        this.textAccountPassword.setText("");
        this.checkAuto.setSelected(true);
        this.checkShowMenu.setSelected(false);
    }

    public static Properties getProperties() throws IOException {
        return DefaultLocalPreferencePanel.getPropertiesFromFile((String)GOOGLE_DOCS_PROPERTIES);
    }
}

