/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openconcerto.utils.cc.IdentitySet;

public final class LinkedIdentitySet<E>
extends AbstractSet<E>
implements IdentitySet<E>,
Cloneable {
    private final LinkedList<E> list = new LinkedList();

    public LinkedIdentitySet() {
    }

    public LinkedIdentitySet(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        if (this.contains(e)) {
            return false;
        }
        this.list.add(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean contains(Object o) {
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (o != e.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (o != e.next()) continue;
            e.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public Object clone() {
        return new LinkedIdentitySet<E>(this);
    }
}

