/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class GestionDevise {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat(",##0.00");

    public static long parseLongCurrency(String numStr) {
        numStr = numStr.trim();
        StringBuffer b = new StringBuffer(numStr.length());
        boolean negative = false;
        if (numStr.length() == 0) {
            return 0L;
        }
        int decpl = -1;
        int i = 0;
        while (i < numStr.length()) {
            char c = numStr.charAt(i);
            switch (c) {
                case '-': {
                    negative = true;
                    break;
                }
                case ',': 
                case '.': {
                    if (decpl == -1) {
                        decpl = 0;
                        break;
                    }
                    throw new NumberFormatException("more than one decimal point");
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (decpl != -1) {
                        ++decpl;
                    }
                    b.append(c);
                    break;
                }
            }
            ++i;
        }
        if (decpl == 1) {
            b.append('0');
            ++decpl;
        }
        numStr = b.toString();
        long num = Long.parseLong(numStr);
        if (decpl == -1 || decpl == 0) {
            num *= 100L;
        } else if (decpl != 2) {
            throw new NumberFormatException("wrong number of decimal places.");
        }
        if (negative) {
            num = -num;
        }
        return num;
    }

    public static final String currencyToString(long cents) {
        return GestionDevise.currencyToString(cents, true);
    }

    public static final String currencyToString(BigDecimal currency) {
        return DECIMAL_FORMAT.format(currency);
    }

    public static final String currencyToString(long cents, boolean format) {
        boolean negative;
        String separator = format ? "," : ".";
        if (cents < 0L) {
            cents = -cents;
            negative = true;
        } else {
            negative = false;
        }
        String s = Long.toString(cents);
        int len = s.length();
        switch (len) {
            case 1: {
                s = "0" + separator + "0" + s;
                break;
            }
            case 2: {
                s = "0" + separator + s;
                break;
            }
            default: {
                if (format) {
                    StringBuffer buf = new StringBuffer(s.substring(0, len - 2));
                    StringBuffer result = new StringBuffer();
                    int i = 0;
                    while (i < buf.length()) {
                        char c = buf.charAt(buf.length() - (i + 1));
                        if (i > 0 && i % 3 == 0) {
                            result.insert(0, ' ');
                        }
                        result.insert(0, c);
                        ++i;
                    }
                    s = result + separator + s.substring(len - 2, len);
                    break;
                }
                s = String.valueOf(s.substring(0, len - 2)) + separator + s.substring(len - 2, len);
            }
        }
        if (negative) {
            s = "-" + s;
        }
        return s;
    }
}

