/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openconcerto.utils.cc.ITransformer;

public final class TablePopupMouseListener
extends MouseAdapter {
    private final ITransformer<MouseEvent, JPopupMenu> popup;

    public static void add(JTable t, ITransformer<MouseEvent, JPopupMenu> popup) {
        t.addMouseListener(new TablePopupMouseListener(popup));
    }

    private TablePopupMouseListener(ITransformer<MouseEvent, JPopupMenu> popup) {
        this.popup = popup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            this.adjustSelection(e);
        }
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.adjustSelection(e);
            JPopupMenu menu = this.popup.transformChecked(e);
            if (menu != null && menu.getSubElements().length > 0) {
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private void adjustSelection(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        int row = table.rowAtPoint(e.getPoint());
        if (!table.getSelectionModel().isSelectedIndex(row)) {
            table.getSelectionModel().setSelectionInterval(row, row);
        }
    }
}

