/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openconcerto.ui.Log;
import org.openconcerto.utils.Tuple2;

public class ColumnSizeAdjustor {
    private final JTable table;
    private TableModel tableModel;
    private final TableModelListener tableL;
    private int origAutoResizeMode;
    private boolean createColumns;
    private final PropertyChangeListener autoResizeL;
    private final List<Integer> maxWidths;
    private boolean installed;

    public ColumnSizeAdjustor(final JTable table) {
        this.table = table;
        this.autoResizeL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("autoResizeMode") || evt.getPropertyName().equals("autoCreateColumnsFromModel")) {
                    Log.get().warning(String.valueOf(evt.getPropertyName()) + " changed so uninstalling " + ColumnSizeAdjustor.this);
                    ColumnSizeAdjustor.this.uninstall();
                } else if (evt.getPropertyName().equals("model")) {
                    ColumnSizeAdjustor.this.uninstall();
                    ColumnSizeAdjustor.this.install();
                }
            }
        };
        this.tableL = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e == null || e.getFirstRow() == -1) {
                    if (ColumnSizeAdjustor.this.createColumns) {
                        TableModel m = (TableModel)e.getSource();
                        TableColumnModel cm = table.getColumnModel();
                        while (cm.getColumnCount() > 0) {
                            cm.removeColumn(cm.getColumn(0));
                        }
                        if (m != null) {
                            int i = 0;
                            while (i < m.getColumnCount()) {
                                TableColumn newColumn = new TableColumn(i);
                                table.addColumn(newColumn);
                                ++i;
                            }
                        }
                        ColumnSizeAdjustor.this.packColumns();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ColumnSizeAdjustor.this.packColumns();
                            }
                        });
                    }
                } else {
                    boolean allCols = e.getColumn() == -1;
                    int firstCol = allCols ? 0 : e.getColumn();
                    int lastCol = allCols ? ((TableModel)e.getSource()).getColumnCount() : e.getColumn() + 1;
                    int i = firstCol;
                    while (i < lastCol) {
                        ColumnSizeAdjustor.this.packColumn(i, e.getType(), e.getFirstRow(), e.getLastRow());
                        ++i;
                    }
                }
            }
        };
        this.maxWidths = new ArrayList<Integer>(this.table.getColumnCount());
        this.installed = false;
        this.tableModel = null;
        this.install();
    }

    public final boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean b) {
        if (b != this.installed) {
            if (b) {
                this.origAutoResizeMode = this.table.getAutoResizeMode();
                this.table.setAutoResizeMode(0);
                this.createColumns = this.table.getAutoCreateColumnsFromModel();
                if (this.createColumns) {
                    this.table.setAutoCreateColumnsFromModel(false);
                }
                this.table.addPropertyChangeListener(this.autoResizeL);
                this.tableModel = this.table.getModel();
                this.tableModel.addTableModelListener(this.tableL);
                this.packColumns();
            } else {
                this.tableModel.removeTableModelListener(this.tableL);
                this.tableModel = null;
                this.table.removePropertyChangeListener(this.autoResizeL);
                if (this.table.getAutoResizeMode() == 0) {
                    this.table.setAutoResizeMode(this.origAutoResizeMode);
                }
                if (this.createColumns) {
                    this.table.setAutoCreateColumnsFromModel(true);
                }
            }
            this.installed = b;
        }
    }

    public void install() {
        this.setInstalled(true);
    }

    public void uninstall() {
        this.setInstalled(false);
    }

    public void packColumns() {
        int columnCount = this.table.getColumnCount();
        this.maxWidths.clear();
        this.maxWidths.addAll(Collections.nCopies(columnCount, null));
        int c = 0;
        while (c < columnCount) {
            this.packColumn(c, 0, 0, -1);
            ++c;
        }
    }

    private final void packColumn(int colModelIndex, int type, int firstModelRow, int lastModelRow) {
        if (type == -1) {
            return;
        }
        int initialWidth = this.maxWidths.get(colModelIndex) == null ? 0 : this.maxWidths.get(colModelIndex);
        Tuple2<TableColumn, Integer> colAndWidth = this.computeMaxWidth(colModelIndex, initialWidth, firstModelRow, lastModelRow);
        Integer width = colAndWidth.get1();
        this.maxWidths.set(colModelIndex, width);
        if (width != null) {
            int margin = 2;
            colAndWidth.get0().setPreferredWidth(width + 4);
        }
    }

    private final Tuple2<TableColumn, Integer> computeMaxWidth(int colModelIndex, int initialWidth, int firstModelRow, int last) {
        int viewIndex = this.table.convertColumnIndexToView(colModelIndex);
        if (viewIndex < 0) {
            return new Tuple2<Object, Object>(null, null);
        }
        TableColumn col = this.table.getColumnModel().getColumn(viewIndex);
        int rowCount = this.table.getRowCount();
        int lastModelRow = last < 0 || last >= rowCount ? rowCount : last + 1;
        int width = firstModelRow == 0 && lastModelRow == rowCount ? 0 : initialWidth;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
        width = Math.max(width, comp.getPreferredSize().width);
        int r = firstModelRow;
        while (r < lastModelRow) {
            int viewRow = this.table.convertRowIndexToView(r);
            renderer = this.table.getCellRenderer(viewRow, viewIndex);
            comp = renderer.getTableCellRendererComponent(this.table, this.table.getModel().getValueAt(r, colModelIndex), false, false, viewRow, viewIndex);
            width = Math.max(width, comp.getPreferredSize().width);
            ++r;
        }
        return Tuple2.create(col, width);
    }
}

