/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openconcerto.ui.table.IAlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererDecorator;

public class AlternateTableCellRenderer
extends TableCellRendererDecorator {
    public static final Color COLOR_LIGHT_GRAY = new Color(243, 243, 243);
    public static final Color DEFAULT_BG_COLOR = Color.WHITE;
    public static final Map<Color, Color> DEFAULT_MAP = Collections.singletonMap(DEFAULT_BG_COLOR, COLOR_LIGHT_GRAY);
    private static final String ODD_BG_COLOR_MAP_PROP = String.valueOf(AlternateTableCellRenderer.class.getSimpleName()) + " odd background colour map";
    private static final ProxyComp altComp = new ProxyComp();
    public static final TableCellRendererDecorator.TableCellRendererDecoratorUtils<AlternateTableCellRenderer> UTILS = AlternateTableCellRenderer.createUtils(AlternateTableCellRenderer.class);
    private static final PropertyChangeListener RENDERER_L = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("cellRenderer".equals(evt.getPropertyName())) {
                UTILS.setRenderer((TableColumn)evt.getSource());
            }
        }
    };

    public static void setBGColorMap(JComponent comp, Color evenColor, Color oddColor) {
        AlternateTableCellRenderer.setBGColorMap(comp, Collections.singletonMap(evenColor, oddColor));
    }

    public static void setBGColorMap(JComponent comp, Map<Color, Color> m) {
        HashMap<Color, Color> res = new HashMap<Color, Color>(DEFAULT_MAP);
        res.putAll(m);
        comp.putClientProperty(ODD_BG_COLOR_MAP_PROP, res);
    }

    private static Map<Color, Color> getBGColorMap(JComponent comp) {
        return (Map)comp.getClientProperty(ODD_BG_COLOR_MAP_PROP);
    }

    private static Color getAlternateColor(Color c) {
        return new Color((int)((double)c.getRed() * 0.9), (int)((double)c.getGreen() * 0.9), (int)((double)c.getBlue() * 0.9));
    }

    public static final void setRendererAndListen(TableColumn col) {
        col.removePropertyChangeListener(RENDERER_L);
        AlternateTableCellRenderer.setRenderer(col);
        col.addPropertyChangeListener(RENDERER_L);
    }

    public static final void setRenderer(TableColumn col) {
        UTILS.setRenderer(col);
    }

    public static AlternateTableCellRenderer createDefault() {
        return new AlternateTableCellRenderer(new DefaultTableCellRenderer());
    }

    public AlternateTableCellRenderer() {
        this(null);
    }

    public AlternateTableCellRenderer(TableCellRenderer renderer) {
        super(renderer);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer tableRenderer = this.getRenderer(table, column);
        if (tableRenderer instanceof IAlternateTableCellRenderer) {
            return ((IAlternateTableCellRenderer)tableRenderer).getAlternateTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        Component comp = tableRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected || row % 2 == 0) {
            return comp;
        }
        return altComp.setComp(comp);
    }

    private static final class ProxyComp
    extends JComponent {
        private Component comp;
        private JComponent jComp;
        private Map<Color, Color> oddBGColorMap;

        private ProxyComp() {
        }

        public ProxyComp setComp(Component comp) {
            if (this.comp != comp) {
                this.comp = comp;
                this.jComp = comp instanceof JComponent ? (JComponent)comp : null;
            }
            Map jCompMap = this.jComp == null ? null : AlternateTableCellRenderer.getBGColorMap(this.jComp);
            this.oddBGColorMap = jCompMap == null ? DEFAULT_MAP : jCompMap;
            return this;
        }

        private Color getAlternateColor(Color c) {
            Color res = this.oddBGColorMap.get(c);
            return res != null ? res : AlternateTableCellRenderer.getAlternateColor(c);
        }

        @Override
        public void paint(Graphics g) {
            Color origBG = this.comp.getBackground();
            Color altBG = this.getAlternateColor(origBG);
            boolean wasDoubleBuffered = false;
            if (this.jComp != null && this.jComp.isDoubleBuffered()) {
                wasDoubleBuffered = true;
                this.jComp.setDoubleBuffered(false);
            }
            if (this.getWidth() != this.comp.getWidth() || this.getHeight() != this.comp.getHeight()) {
                this.comp.setSize(this.getWidth(), this.getHeight());
                this.comp.doLayout();
            }
            this.comp.setBackground(altBG);
            this.comp.paint(g);
            this.comp.setBackground(origBG);
            if (wasDoubleBuffered) {
                this.jComp.setDoubleBuffered(true);
            }
        }
    }
}

