/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.coreanimation;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.DisplayabilityListener;
import org.openconcerto.ui.component.ComboComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.coreanimation.JComponentBackGroundAnimator;
import org.openconcerto.ui.coreanimation.JComponentForegroundAnimator;
import org.openconcerto.ui.coreanimation.Pulse;
import org.openconcerto.ui.coreanimation.Pulseable;

public class Animator {
    private Pulse[] tmpAnims = new Pulse[0];
    private final Vector<Pulse> animators = new Vector();
    private Thread thread;
    private boolean isAnimating = true;
    private final Map<Component, Pulse> activeComps = new HashMap<Component, Pulse>();
    private final Map<Component, Object> managedComps = new WeakHashMap<Component, Object>();
    private final DisplayabilityListener displayabilityListener = new DisplayabilityListener(){

        @Override
        protected void displayabilityChanged(Component c) {
            Animator.this.updateComp(c);
        }
    };
    static final Animator instance = new Animator();

    private Animator() {
    }

    public static final synchronized Animator getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pulse() {
        int size;
        Vector<Pulse> vector = this.animators;
        synchronized (vector) {
            size = this.animators.size();
            if (this.tmpAnims.length > size + 128) {
                this.tmpAnims = new Pulse[size + 8];
            }
            this.tmpAnims = this.animators.toArray(this.tmpAnims);
        }
        int i = 0;
        while (i < size) {
            this.tmpAnims[i].pulse();
            this.tmpAnims[i] = null;
            ++i;
        }
    }

    public synchronized boolean isAnimating() {
        return this.isAnimating;
    }

    public synchronized boolean remove(Pulse p) {
        if (this.animators.remove(p)) {
            p.resetState();
            return true;
        }
        return false;
    }

    public void remove(Component c) {
        this.remove(c, true);
    }

    private void remove(Component c, boolean completely) {
        this.remove(this.activeComps.remove(c));
        if (completely) {
            c.removeHierarchyListener(this.displayabilityListener);
            this.managedComps.remove(c);
        }
    }

    private void put(Component f, Pulse pulse) {
        this.activeComps.put(f, pulse);
        this.add(pulse);
    }

    public synchronized void add(Pulse p) {
        if (p == null) {
            throw new NullPointerException("null Pulse");
        }
        if (this.animators.contains(p)) {
            return;
        }
        this.animators.add(p);
        if (this.thread == null) {
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (Animator.this.isAnimating()) {
                        try {
                            Animator.this.pulse();
                            Thread.sleep(100L, 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, String.valueOf(this.getClass().getSimpleName()) + " pulse");
            this.thread.setName("Background Animator");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void animate(Component f, boolean animate) {
        if (animate) {
            this.animate(f);
        } else {
            this.remove(f);
        }
    }

    public boolean animate(Component f) {
        if (this.managedComps.containsKey(f)) {
            return this.activeComps.containsKey(f);
        }
        this.managedComps.put(f, null);
        f.addHierarchyListener(this.displayabilityListener);
        return this.updateComp(f);
    }

    private final boolean updateComp(Component f) {
        boolean res = false;
        if (f.isDisplayable()) {
            Component pc = f instanceof Pulseable ? ((Pulseable)((Object)f)).getPulseComponent() : f;
            Pulse p = this.createPulse(pc);
            if (p != null) {
                this.put(f, p);
                res = true;
            }
        } else {
            this.remove(f, false);
        }
        return res;
    }

    private Pulse createPulse(Component f) {
        Pulse res = null;
        if (f instanceof JToggleButton) {
            res = new JComponentForegroundAnimator((JToggleButton)f);
        } else if (f instanceof JComboBox) {
            res = this.createComboPulse((JComboBox)f);
        } else if (f instanceof ComboComponent && ((ComboComponent)((Object)f)).getComboComp() != null) {
            res = this.createComboPulse(((ComboComponent)((Object)f)).getComboComp());
        } else if (f instanceof JTextComponent) {
            res = new JComponentBackGroundAnimator((JTextComponent)f);
        } else if (f instanceof TextComponent && this.bkgdUseable((TextComponent)((Object)f))) {
            res = new JComponentBackGroundAnimator(((TextComponent)((Object)f)).getTextComp());
        } else if (f instanceof JPanel) {
            res = new JComponentBackGroundAnimator((JPanel)f);
        }
        return res;
    }

    private final boolean bkgdUseable(TextComponent t) {
        return t.getTextComp() != null && (t.getTextComp().isOpaque() || UIManager.getLookAndFeel().getName().equals("Mac OS X") || UIManager.getLookAndFeel().getName().equals("Nimbus"));
    }

    private final Pulse createComboPulse(JComboBox comp) {
        if (comp.isEditable()) {
            JComponent editor = (JComponent)comp.getEditor().getEditorComponent();
            editor.setOpaque(true);
            return new JComponentBackGroundAnimator(editor);
        }
        return new JComponentBackGroundAnimator(comp);
    }
}

