/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.combo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.MutableListCombo;
import org.openconcerto.ui.component.MutableListComboPopupListener;
import org.openconcerto.ui.component.combo.ComboUtils;
import org.openconcerto.ui.component.combo.ISearchableComboCompletionThread;
import org.openconcerto.ui.component.combo.ISearchableComboItem;
import org.openconcerto.ui.component.combo.ISearchableComboPopup;
import org.openconcerto.ui.component.combo.ISearchableTextCombo;
import org.openconcerto.ui.component.combo.Log;
import org.openconcerto.ui.component.combo.SearchMode;
import org.openconcerto.ui.component.combo.ToStringVarDesc;
import org.openconcerto.ui.component.combo.VarDesc;
import org.openconcerto.ui.component.text.DocumentComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.model.DefaultIMutableListModel;
import org.openconcerto.utils.model.IListModel;
import org.openconcerto.utils.model.IMutableListModel;
import org.openconcerto.utils.model.ListComboBoxModel;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ISearchableCombo<T>
extends JPanel
implements ValueWrapper<T>,
DocumentComponent,
TextComponent {
    public static final SearchMode MODE_STARTWITH = new SearchMode.DefaultSearchMode(false);
    public static final SearchMode MODE_CONTAINS = new SearchMode.DefaultSearchMode(true);
    private SearchMode modeCompletion = MODE_CONTAINS;
    private ISearchableComboCompletionThread<T> completionThread;
    protected final ISearchableComboPopup<T> popupCompletion;
    private final DefaultIMutableListModel<ISearchableComboItem<T>> model;
    private final ListComboBoxModel listModel;
    private final ISearchableComboItem<T> emptyItem;
    private boolean includeEmpty;
    private final ComboLockedMode locked;
    private boolean searchable;
    private final ValueChangeSupport<T> supp = new ValueChangeSupport(this);
    private final List<Action> actions;
    private IListModel<T> cache;
    private JTextComponent text;
    private Insets textMargin;
    private final JLabel label;
    private final JLabel btn;
    private final MouseMotionListener dragL;
    private final MouseListener clickL;
    private static Image imageSelectorEnabled;
    private static Image imageSelectorDisabled;
    private int minimumSearch = 1;
    private int maximumResult = 300;
    private final Map<T, ISearchableComboItem<T>> itemsByOriginalItem;
    protected boolean updating = false;
    protected boolean invalidEdit = false;
    private ITransformer<T, VarDesc> varDescTransf = null;
    private ITransformer<T, Icon> iconTransf = null;
    private boolean trace = false;

    public ISearchableCombo() {
        this(ComboLockedMode.UNLOCKED);
    }

    public ISearchableCombo(boolean locked) {
        this(locked ? ComboLockedMode.LOCKED : ComboLockedMode.ITEMS_LOCKED);
    }

    protected ISearchableCombo(ComboLockedMode mode) {
        this(mode, 0, 0);
    }

    public ISearchableCombo(ComboLockedMode mode, int rows, int columns) {
        this(mode, rows, columns, false);
    }

    public ISearchableCombo(ComboLockedMode mode, boolean textArea) {
        this(mode, 0, 0, textArea);
    }

    public ISearchableCombo(ComboLockedMode mode, int rows, int columns, boolean textArea) {
        this.locked = mode;
        this.actions = new ArrayList<Action>();
        this.cache = null;
        this.itemsByOriginalItem = new HashMap<T, ISearchableComboItem<T>>();
        this.model = new DefaultIMutableListModel();
        this.getModel().setSelectOnAdd(false);
        this.getModel().setSelectOnRm(false);
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() == -1 && e.getIndex0() == e.getIndex1()) {
                    ISearchableCombo.this.selectionChanged();
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        this.emptyItem = new ISearchableComboItem<Object>(null, new ToStringVarDesc("effacer"));
        this.setIncludeEmpty(this.isLocked());
        this.listModel = new ListComboBoxModel();
        this.popupCompletion = new ISearchableComboPopup(this.listModel, this);
        this.popupCompletion.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ComboUtils.doNotCancelPopupHack(ISearchableCombo.this.getTextComp());
                ComboUtils.doNotCancelPopupHack(ISearchableCombo.this.getBtn());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboUtils.cancelPopupHack(ISearchableCombo.this.getTextComp());
                ComboUtils.cancelPopupHack(ISearchableCombo.this.getBtn());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ISearchableCombo.this.popupCompletion.setMinWith(ISearchableCombo.this.getBounds().width);
            }
        });
        this.dragL = new MouseMotionListener(){
            private Point last = null;

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getPoint().equals(this.last)) {
                    return;
                }
                this.last = e.getPoint();
                Point converted = e.getPoint();
                converted.translate(0, -ISearchableCombo.this.getHeight());
                ISearchableCombo.this.popupCompletion.updateListBoxSelection(converted);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
        this.clickL = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (this.isClickTarget(e)) {
                    ISearchableCombo.this.getTextComp().requestFocusInWindow();
                    boolean showing = ISearchableCombo.this.popupCompletion.isShowing();
                    if (showing) {
                        ISearchableCombo.this.hideCompletionPopup();
                    } else {
                        ISearchableCombo.this.updateAutoCompletion(true);
                    }
                }
            }

            private boolean isClickTarget(MouseEvent e) {
                boolean isTextClickable;
                JComponent src = (JComponent)e.getSource();
                boolean buttonClicked = src.isEnabled() && src.contains(e.getPoint());
                boolean bl = isTextClickable = !(src instanceof JTextComponent) || !((JTextComponent)src).isEditable();
                return buttonClicked && isTextClickable;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ISearchableCombo.this.popupCompletion.isShowing() && !this.isClickTarget(e)) {
                    ISearchableCombo.this.popupCompletion.validateSelection();
                }
            }
        };
        this.completionThread = null;
        ISearchableCombo.initImages();
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.label = new JLabel();
        this.btn = new JLabel(new ImageIcon(imageSelectorEnabled));
        this.btn.setDisabledIcon(new ImageIcon(imageSelectorDisabled));
        this.btn.setSize(this.getBtn().getPreferredSize());
        this.btn.setFocusable(false);
        this.btn.addMouseMotionListener(this.dragL);
        this.btn.addMouseListener(this.clickL);
        this.setTextEditor(rows, columns, textArea);
        this.getLabel().setOpaque(false);
        this.getBtn().setOpaque(false);
        this.setOpaque(false);
        this.setEnabled(true);
        this.setSearchable(true);
    }

    private static void initImages() {
        if (imageSelectorEnabled != null) {
            return;
        }
        Image ic = new ImageIcon(ISearchableCombo.class.getResource("yellowDownArrow.png")).getImage();
        int w = ic.getWidth(null);
        int h = ic.getHeight(null);
        imageSelectorEnabled = new BufferedImage(w, h, 2);
        Graphics g = imageSelectorEnabled.getGraphics();
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, w, h);
        g.drawImage(ic, 0, 0, null);
        imageSelectorDisabled = new BufferedImage(w, h, 2);
        Graphics2D g2d = (Graphics2D)imageSelectorDisabled.getGraphics();
        g2d.setBackground(new Color(255, 255, 255, 0));
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, g2d.getRenderingHints());
        op.filter((BufferedImage)imageSelectorEnabled, (BufferedImage)imageSelectorDisabled);
    }

    private void log(String s) {
        if (this.trace) {
            Log.get().info(s);
        }
    }

    private DefaultIMutableListModel<ISearchableComboItem<T>> getModel() {
        return this.model;
    }

    private final JLabel getLabel() {
        return this.label;
    }

    protected final JComponent getBtn() {
        return this.btn;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.text.setEnabled(b);
        this.btn.setEnabled(b && this.cache != null);
    }

    protected final ComboLockedMode getMode() {
        return this.locked;
    }

    private boolean isLocked() {
        return this.locked == ComboLockedMode.LOCKED;
    }

    public final boolean isSearchable() {
        return this.searchable;
    }

    public final void setSearchable(boolean searchable) {
        this.searchable = searchable;
        this.text.setEditable(this.searchable || !this.isLocked());
        if (!this.text.isEditable()) {
            this.text.setBackground(Color.WHITE);
        }
    }

    public final List<Action> getActions() {
        return this.actions;
    }

    public final IListModel<T> getCache() {
        return this.cache;
    }

    public void initCache(IListModel<T> acache) {
        if (acache == null) {
            throw new NullPointerException("null cache");
        }
        if (this.getCache() != null) {
            throw new IllegalStateException("cache already set " + this.getCache());
        }
        this.cache = acache;
        this.setEnabled(this.isEnabled());
        if (this.getMode() == ComboLockedMode.UNLOCKED) {
            if (!(acache instanceof IMutableListModel)) {
                throw new IllegalArgumentException(this + " is unlocked but " + acache + " is not mutable");
            }
            final IMutableListModel mutable = (IMutableListModel)acache;
            new MutableListComboPopupListener(new MutableListCombo(){

                @Override
                public ComboLockedMode getMode() {
                    return ISearchableCombo.this.getMode();
                }

                @Override
                public Component getPopupComp() {
                    return ISearchableCombo.this.getTextComp();
                }

                @Override
                public void addCurrentText() {
                    Object newItem = ISearchableCombo.this.stringToT(ISearchableCombo.this.getTextComp().getText());
                    if (!mutable.getList().contains(newItem)) {
                        mutable.addElement(newItem);
                    }
                }

                @Override
                public void removeCurrentText() {
                    mutable.removeElement(ISearchableCombo.this.getValue());
                }
            }).listen();
        }
        this.addItemsFromCache(0, this.getCache().getSize() - 1);
        this.getCache().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() < 0) {
                    return;
                }
                int equalsCount = CollectionUtils.equals(ISearchableCombo.this.getModel().getList(), ISearchableCombo.this.getCache().getList(), true, new ITransformer<ISearchableComboItem<T>, T>(){

                    @Override
                    public T transformChecked(ISearchableComboItem<T> input) {
                        return input.getOriginal();
                    }
                });
                int oldIndex1 = ISearchableCombo.this.getModel().getSize() - 1 - equalsCount;
                int newIndex1 = ISearchableCombo.this.getCache().getSize() - 1 - equalsCount;
                if (oldIndex1 >= 0) {
                    ISearchableCombo.this.rmItemsFromModel(e.getIndex0(), oldIndex1);
                }
                if (newIndex1 >= 0) {
                    ISearchableCombo.this.addItemsFromCache(e.getIndex0(), newIndex1);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ISearchableCombo.this.addItemsFromCache(e.getIndex0(), e.getIndex1());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ISearchableCombo.this.rmItemsFromModel(e.getIndex0(), e.getIndex1());
            }
        });
    }

    private void addItemsFromCache(int index0, int index1) {
        this.addItems(index0, this.getCache().getList().subList(index0, index1 + 1));
    }

    private void addItems(int index, Collection<T> originalItems) {
        ArrayList<ISearchableComboItem<T>> toAdd = new ArrayList<ISearchableComboItem<T>>(originalItems.size());
        for (T originalItem : originalItems) {
            ISearchableComboItem<T> textSelectorItem = this.createItem(originalItem);
            this.itemsByOriginalItem.put(originalItem, textSelectorItem);
            toAdd.add(textSelectorItem);
        }
        this.getModel().addAll(index, toAdd);
    }

    private void rmItemsFromModel(int index0, int index1) {
        this.getModel().removeElementsAt(index0, index1);
        this.itemsByOriginalItem.keySet().retainAll(this.getCache().getList());
    }

    private ISearchableComboItem<T> createItem(T originalItem) {
        return new ISearchableComboItem<T>(originalItem, this.createVarDesc(originalItem));
    }

    private final VarDesc createVarDesc(T o) {
        if (o instanceof VarDesc) {
            return (VarDesc)o;
        }
        if (this.varDescTransf != null) {
            return this.varDescTransf.transformChecked(o);
        }
        return new ToStringVarDesc(o);
    }

    final Icon getIcon(ISearchableComboItem<T> i) {
        T o = i.getOriginal();
        if (o instanceof Icon) {
            return (Icon)o;
        }
        if (this.iconTransf != null) {
            return this.iconTransf.transformChecked(o);
        }
        return null;
    }

    public final void setIconFactory(ITransformer<T, Icon> t) {
        this.iconTransf = t;
    }

    protected T stringToT(String t) {
        throw new IllegalStateException("use " + ISearchableTextCombo.class);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    ISearchableComboItem<T> getSelection() {
        return this.getModel().getSelectedItem();
    }

    @Override
    public T getValue() {
        ISearchableComboItem<T> sel = this.getSelection();
        return sel == null ? null : (T)sel.getOriginal();
    }

    @Override
    public void resetValue() {
        this.setValue(null);
    }

    @Override
    public final void setValue(T val) {
        this.setValue(val, true);
    }

    private final void setValue(T val, boolean valid) {
        this.log("entering " + this.getClass().getSimpleName() + ".setValue " + val + " valid: " + valid);
        boolean invalidChange = this.invalidEdit ^ !valid;
        if (invalidChange) {
            this.invalidEdit = !valid;
            this.text.setForeground(this.invalidEdit ? Color.GRAY : Color.BLACK);
        }
        if (this.getValue() != val) {
            this.log("this.getValue() != val :" + this.getValue());
            if (val == null) {
                this.setSelection(null);
            } else if (this.itemsByOriginalItem.containsKey(val)) {
                this.setSelection(this.itemsByOriginalItem.get(val));
            } else if (this.getMode() != ComboLockedMode.LOCKED) {
                this.setSelection(this.createItem(val));
            } else {
                this.getTextComp().setText(this.createItem(val).asString());
                assert (this.getValue() == null && this.invalidEdit);
            }
        } else if (invalidChange) {
            this.log("this.getValue() == val and invalidChange");
            this.selectionChanged();
        }
    }

    private final void setSelection(ISearchableComboItem<T> val) {
        this.log("entering " + this.getClass().getSimpleName() + ".setSelection " + val);
        this.getModel().setSelectedItem(val);
    }

    protected final void selectionChanged() {
        this.updating = true;
        ISearchableComboItem<T> sel = this.getModel().getSelectedItem();
        this.getLabel().setIcon(sel == null ? null : this.getIcon(sel));
        this.updateMargin();
        if (!this.invalidEdit) {
            String newText;
            String string = newText = sel == null ? "" : sel.asString();
            if (!this.text.getText().equals(newText)) {
                this.text.setText(newText);
                this.text.getCaret().setDot(0);
            }
        }
        this.updating = false;
        this.supp.fireValueChange();
    }

    private int getLeftMargin() {
        int labelWidth = (int)this.getLabel().getPreferredSize().getWidth();
        return this.textMargin.left + (labelWidth > 0 ? 4 + labelWidth : 0);
    }

    private int getRightMargin() {
        return 3 + this.getBtn().getWidth() + 3 + this.textMargin.right;
    }

    private void updateMargin() {
        Insets origMarg = this.text.getMargin();
        this.text.setMargin(new Insets(origMarg.top, this.getLeftMargin(), origMarg.bottom, this.getRightMargin()));
    }

    protected final void docChanged(DocumentEvent e) {
        if (!this.updating) {
            String text = SimpleDocumentListener.getText(e.getDocument());
            if (this.isLocked()) {
                this.setValue(null, text.length() == 0);
            } else {
                this.setValue(this.stringToT(text));
            }
            if (this.isSearchable()) {
                this.updateAutoCompletion(false);
            }
        }
    }

    private void updateAutoCompletion(boolean showAll) {
        if (this.getCache() == null) {
            return;
        }
        String t = this.text.getText();
        if (this.completionThread != null) {
            this.completionThread.stopNow();
        }
        this.completionThread = new ISearchableComboCompletionThread(this, showAll, t);
        this.completionThread.setPriority(1);
        this.completionThread.start();
    }

    List<ISearchableComboItem<T>> getModelValues() {
        return this.getModel().getList();
    }

    void setMatchingCompletions(List<ISearchableComboItem<T>> l, boolean showAll) {
        this.listModel.removeAllElements();
        if (showAll && this.includeEmpty()) {
            this.listModel.addElement(this.emptyItem);
        }
        this.listModel.addAll(l);
        this.listModel.addAll(this.actions);
        if (showAll) {
            this.showCompletionPopup();
        } else if (l.size() > 1) {
            this.showCompletionPopup();
        } else if (l.size() == 1) {
            ISearchableComboItem<T> onlyCompletion = l.get(0);
            if (onlyCompletion.asString().trim().equalsIgnoreCase(this.text.getText().trim())) {
                this.hideCompletionPopup();
                this.setValue(onlyCompletion.getOriginal());
            } else {
                this.showCompletionPopup();
            }
        } else {
            this.hideCompletionPopup();
        }
    }

    public final boolean includeEmpty() {
        return this.includeEmpty;
    }

    public final void setIncludeEmpty(boolean include) {
        this.includeEmpty = include;
    }

    void hideCompletionPopup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ISearchableCombo.this.popupCompletion.close();
            }
        });
    }

    void showCompletionPopup() {
        if (this.isShowing()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ISearchableCombo.this.popupCompletion.open();
                }
            });
        }
    }

    private JTextField createTextField(int columns) {
        boolean macLaF = UIManager.getLookAndFeel().getID().equals("Aqua");
        JTextField tf = !macLaF ? new JTextField(columns) : new JTextField(columns){

            @Override
            public Insets getInsets() {
                Insets res = (Insets)super.getInsets().clone();
                res.left += ISearchableCombo.this.getLeftMargin();
                res.right += ISearchableCombo.this.getRightMargin();
                return res;
            }
        };
        return tf;
    }

    public final void setTextEditor(int rows, int columns, boolean textArea) {
        this.setTextEditor(rows > 1 || textArea ? new ITextArea(rows, columns) : this.createTextField(columns));
    }

    protected final void setTextEditor(JTextComponent atext) {
        if (atext == null) {
            throw new IllegalArgumentException("null textEditor");
        }
        if (this.text != null) {
            this.text.removeMouseMotionListener(this.dragL);
            this.text.removeMouseListener(this.clickL);
            this.remove(this.text);
            this.text.removeAll();
        }
        this.text = atext;
        this.textMargin = (Insets)this.text.getMargin().clone();
        this.setFont(this.text.getFont());
        this.text.setFont(null);
        this.getTextComp().setLayout(new LayoutManager2(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void addLayoutComponent(Component comp, Object constraints) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public void invalidateLayout(Container target) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return parent.getPreferredSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMinimumSize();
            }

            @Override
            public Dimension maximumLayoutSize(Container target) {
                return target.getMaximumSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets parentInsets = ((JComponent)parent).getInsets();
                ISearchableCombo.this.getLabel().setSize(ISearchableCombo.this.getLabel().getPreferredSize());
                ISearchableCombo.this.getLabel().setLocation(parentInsets.left - ISearchableCombo.this.getLabel().getWidth() - 2, parent.getHeight() / 2 - ISearchableCombo.this.getLabel().getHeight() / 2);
                ISearchableCombo.this.getBtn().setSize(ISearchableCombo.this.getBtn().getWidth(), parent.getHeight());
                ISearchableCombo.this.getBtn().setLocation(parent.getWidth() - parentInsets.right + 3, parent.getHeight() / 2 - ISearchableCombo.this.getBtn().getHeight() / 2);
            }

            @Override
            public float getLayoutAlignmentX(Container target) {
                return 0.5f;
            }

            @Override
            public float getLayoutAlignmentY(Container target) {
                return 0.5f;
            }
        });
        this.text.add(this.getLabel());
        this.text.add(this.getBtn());
        this.updateMargin();
        this.add(this.text);
        this.text.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ISearchableCombo.this.docChanged(e);
            }
        });
        this.text.addKeyListener(new KeyListener(){
            private boolean consume;

            private final boolean isAtLastLine(JTextComponent src) {
                if (src.getDocument().getLength() == 0) {
                    return true;
                }
                try {
                    Rectangle caretView = src.modelToView(src.getCaret().getDot());
                    Rectangle lastView = src.modelToView(src.getDocument().getLength() - 1);
                    return caretView.y >= lastView.y;
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                    return false;
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JTextComponent src = (JTextComponent)e.getSource();
                ISearchableComboPopup popup = ISearchableCombo.this.popupCompletion;
                if (e.getKeyCode() == 27) {
                    if (ISearchableCombo.this.getTextComp().getDocument().getLength() == 0) {
                        ISearchableCombo.this.hideCompletionPopup();
                    }
                } else if (e.getKeyCode() == 40) {
                    if (popup.isShowing()) {
                        popup.selectNext();
                        e.consume();
                    } else if (this.isAtLastLine(src)) {
                        ISearchableCombo.this.updateAutoCompletion(true);
                    }
                } else if (e.getKeyCode() == 38) {
                    if (popup.isShowing()) {
                        popup.selectPrevious();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 10) {
                    if (popup.isShowing()) {
                        popup.validateSelection();
                        if (!popup.isShowing()) {
                            e.consume();
                        }
                    }
                } else if (e.getKeyCode() == 34) {
                    if (popup.isShowing()) {
                        popup.selectNextPage();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 33 && popup.isShowing()) {
                    popup.selectPreviousPage();
                    e.consume();
                }
                if (src.getDocument().getLength() == 0 && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                    this.consume = true;
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.consume) {
                    e.consume();
                    this.consume = false;
                }
            }
        });
        this.text.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ISearchableCombo.this.hideCompletionPopup();
            }
        });
        this.text.addMouseListener(this.clickL);
        this.text.addMouseMotionListener(this.dragL);
    }

    public int getMinimumSearch() {
        return this.minimumSearch;
    }

    public final SearchMode getCompletionMode() {
        return this.modeCompletion;
    }

    boolean isEmptyItem(ISearchableComboItem<T> val) {
        return val == this.emptyItem;
    }

    public int getMaximumResult() {
        return this.maximumResult;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public boolean isValidated() {
        return this.getMode() != ComboLockedMode.LOCKED || !this.invalidEdit;
    }

    @Override
    public String getValidationText() {
        return "la valeur ne fait pas partie des choix";
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public Document getDocument() {
        if (this.isLocked()) {
            return null;
        }
        return this.getTextComp().getDocument();
    }

    @Override
    public JTextComponent getTextComp() {
        return this.text;
    }

    @Override
    public String toString() {
        String c = this.getCache() != null ? "with cache" : "without cache";
        String s = this.isSearchable() ? "" : "/non searchable";
        return String.valueOf(this.getClass().getSimpleName()) + "(" + (Object)((Object)this.getMode()) + "/" + c + s + ")";
    }
}

