/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.MutableListCombo;

public class MutableListComboPopupListener
extends MouseAdapter {
    private final MutableListCombo combo;
    private JPopupMenu popup;

    public MutableListComboPopupListener(MutableListCombo combo) {
        this.combo = combo;
        this.popup = null;
    }

    public void listen() {
        this.combo.getPopupComp().addMouseListener(this);
    }

    @Override
    public final void mouseReleased(MouseEvent ev) {
        if (ev.getButton() != 3 || !this.combo.getPopupComp().isEnabled()) {
            return;
        }
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            JMenuItem menu1 = new JMenuItem("Ajouter \u00e0 la liste");
            this.popup.add(menu1);
            menu1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MutableListComboPopupListener.this.combo.addCurrentText();
                }
            });
            JMenuItem menu2 = new JMenuItem("Supprimer de la liste");
            this.popup.add(menu2);
            menu2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MutableListComboPopupListener.this.combo.removeCurrentText();
                }
            });
        }
        if (this.combo.getMode() == ComboLockedMode.UNLOCKED || ev.isControlDown() && this.combo.getMode() == ComboLockedMode.ITEMS_LOCKED) {
            this.popup.show(this.combo.getPopupComp(), ev.getX(), ev.getY());
        }
    }
}

