/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.MutableValueObject;

public class JRadioButtons<V>
extends JPanel
implements MutableValueObject<V>,
EmptyObj {
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private final EmptyChangeSupport emptySupp = new EmptyChangeSupport(this);
    private final Map<V, JRadioButton> choices = new LinkedHashMap<V, JRadioButton>();
    private final ButtonGroup group = new ButtonGroup();
    private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private V emptyID = null;
    private V value = null;

    public JRadioButtons() {
        this((Map<V, String>)null);
    }

    public JRadioButtons(Map<V, String> choices) {
        this.setOpaque(false);
        if (choices != null) {
            this.init(null, choices);
        }
    }

    public final void init(V emptyID, Map<V, String> choices) {
        this.emptyID = emptyID;
        for (Map.Entry<V, String> e : choices.entrySet()) {
            V choice = e.getKey();
            if (choice == null) {
                throw new IllegalArgumentException("A key is null in " + choices);
            }
            String choiceLabel = e.getValue();
            this.addBtn(choiceLabel == null ? choice.toString() : choiceLabel, choice);
        }
        this.addBtn("--- ??? ---", this.emptyID);
        for (final V id : this.choices.keySet()) {
            JRadioButton btn = this.choices.get(id);
            this.group.add(btn);
            btn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        JRadioButtons.this.valueChanged(id);
                    } else if (JRadioButtons.this.value == id) {
                        JRadioButtons.this.valueChanged(null);
                    }
                }
            });
            if (id == this.emptyID) continue;
            this.add(btn);
        }
        this.resetValue();
    }

    private void valueChanged(V id) {
        this.value = id;
        this.supp.firePropertyChange("value", null, id);
        this.emptySupp.fireEmptyChange(this.isEmpty());
    }

    private final void addBtn(String btnLabel, V id) {
        JRadioButton btn = new JRadioButton(btnLabel);
        for (MouseListener l : this.mouseListeners) {
            btn.addMouseListener(l);
        }
        this.choices.put((JRadioButton)id, btn);
    }

    @Override
    public final void setEnabled(boolean b) {
        super.setEnabled(b);
        for (JRadioButton btn : this.choices.values()) {
            btn.setEnabled(b);
        }
    }

    @Override
    public void setValue(V id) {
        if (id == null || !this.choices.containsKey(id)) {
            id = this.emptyID;
        }
        this.choices.get(id).setSelected(true);
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public final void resetValue() {
        this.setValue((V)null);
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null || this.getValue().equals(this.emptyID);
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.emptySupp.addEmptyListener(l);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.mouseListeners.add(l);
        for (JRadioButton radio : this.choices.values()) {
            radio.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.mouseListeners.remove(l);
        for (JRadioButton radio : this.choices.values()) {
            radio.removeMouseListener(l);
        }
    }
}

