/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.utils.CollectionUtils;

public class FormLayouter {
    private final Container co;
    private final int width;
    private final int defaultWidth;
    private final FormLayout layout;
    private final CellConstraints constraints;
    private int x;
    private int y;

    public FormLayouter(Container co, int width, int defaultWidth) {
        if (width < 1) {
            throw new IllegalArgumentException("width must be at least 1 : " + width);
        }
        this.x = 0;
        this.y = 0;
        this.constraints = new CellConstraints();
        this.co = co;
        this.width = width;
        this.defaultWidth = defaultWidth;
        String colSpec = "3dlu, " + CollectionUtils.join(Collections.nCopies(width, "max(25dlu;p), 5dlu, d:g"), ", 5dlu, ") + ", " + "3dlu";
        String rowSpec = "3dlu, top:p, 3dlu";
        int[] colGroups = new int[width];
        int i = 0;
        while (i < width) {
            colGroups[i] = 4 * (i + 1);
            ++i;
        }
        this.layout = new FormLayout(colSpec, "3dlu, top:p, 3dlu");
        this.layout.setColumnGroups((int[][])new int[][]{colGroups});
        co.setLayout((LayoutManager)this.layout);
    }

    public void add(String desc, Component comp) {
        if (comp != null) {
            this.add(desc, comp, this.defaultWidth);
        } else {
            this.newLine();
            JLabel lab = new JLabel(desc);
            lab.setFont(lab.getFont().deriveFont(1, 15.0f));
            this.layout.setRowSpec(this.getY() - 1, new RowSpec("10dlu"));
            this.co.add((Component)lab, this.constraints.xyw(this.getLabelX(), this.getY(), this.width * 4 - 1));
            this.endLine();
        }
    }

    public void add(String desc, Component comp, int w) {
        w = this.checkArgs(comp, w);
        int realWidth = this.getRealFieldWidth(w);
        this.co.add((Component)new JLabel(desc), this.constraints.xy(this.getLabelX(), this.getY(), CellConstraints.RIGHT, CellConstraints.CENTER));
        this.co.add(comp, this.constraints.xyw(this.getFieldX(), this.getY(), realWidth));
        this.x += w;
    }

    private int checkArgs(Component comp, int w) {
        int res;
        if (comp == null) {
            throw new NullPointerException();
        }
        if (w < 0 || w > this.width) {
            throw new IllegalArgumentException("w must be between 0 and " + this.width + " but is : " + w);
        }
        int n = res = w == 0 ? (w = this.width) : w;
        if (this.x + res - 1 >= this.width) {
            this.newLine();
        }
        return res;
    }

    public void addBordered(String desc, Component comp, int w) {
        w = this.checkArgs(comp, w);
        int realWidth = w * 4 - 1;
        JPanel p = new JPanel();
        p.setLayout(new GridLayout());
        p.setBorder(BorderFactory.createTitledBorder(desc));
        p.add(comp);
        this.co.add((Component)p, this.constraints.xyw(this.getLabelX(), this.getY(), realWidth));
        this.x += w;
    }

    private final int getRealFieldWidth(int w) {
        return (w - 1) * 4 + 1;
    }

    private final int getY() {
        return this.y * 2 + 2;
    }

    private final int getLabelX() {
        return this.x * 4 + 2;
    }

    private final int getFieldX() {
        return this.getLabelX() + 2;
    }

    public final void newLine() {
        this.layout.removeRow(this.getY() + 1);
        this.layout.appendRow(new RowSpec("3dlu"));
        this.layout.appendRow(new RowSpec("top:p"));
        this.layout.appendRow(new RowSpec("3dlu"));
        ++this.y;
        this.x = 0;
    }

    private void endLine() {
        this.x = this.width;
    }

    public final int getWidth() {
        return this.width;
    }
}

