/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.config;

import java.io.File;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.users.UserCommonSQLElement;
import org.openconcerto.sql.users.rights.RightSQLElement;
import org.openconcerto.sql.users.rights.UserRightSQLElement;
import org.openconcerto.task.element.TaskRightSQLElement;
import org.openconcerto.task.element.TaskSQLElement;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.LogUtils;

public abstract class ComptaBasePropsConfiguration
extends PropsConfiguration {
    private int idSociete = -1;
    private SQLRow rowSociete = null;
    private DBRoot baseSociete;

    public static File getConfFile(String appName) {
        return ComptaBasePropsConfiguration.getConfFile(appName, new File("."));
    }

    public static File getConfFile(String appName, File wd) {
        String confFilePath = System.getProperty("gestion.confFile");
        File wdFile = new File(wd + "/Configuration", "main.properties");
        File confFile = confFilePath != null ? new File(confFilePath) : (wdFile.isFile() ? wdFile : new File(DesktopEnvironment.getDE().getPreferencesFolder(appName), "main.properties"));
        return confFile;
    }

    public static InputStream getStreamStatic(String name) {
        InputStream stream = ((PropsConfiguration)Configuration.getInstance()).getStream(name);
        return stream;
    }

    public ComptaBasePropsConfiguration(Properties props, String appName) {
        super(props);
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        this.setLoggersLevel();
        this.setProperty("app.name", appName);
        String name = "ilm";
        this.setProperty("systemRoot.rootsToMap", String.valueOf(name) + "_Common");
        this.setProperty("systemRoot.rootPath", String.valueOf(name) + "_Common");
    }

    @Override
    protected PropsConfiguration.FileMode getFileMode() {
        return PropsConfiguration.FileMode.NORMAL_FILE;
    }

    @Override
    protected SQLElementDirectory createDirectory() {
        SQLElementDirectory dir = super.createDirectory();
        dir.addSQLElement(new ConfSQLElement("SOCIETE_COMMON", "une soci\u00e9t\u00e9", "soci\u00e9t\u00e9s"));
        dir.addSQLElement(new ConfSQLElement("EXERCICE_COMMON", "un exercice", "exercices"));
        dir.addSQLElement(new ConfSQLElement("ADRESSE_COMMON", "une adresse", "adresses"));
        dir.addSQLElement(new TaskRightSQLElement());
        dir.addSQLElement(new TaskSQLElement());
        dir.addSQLElement(new UserCommonSQLElement());
        dir.addSQLElement(UserRightSQLElement.class);
        dir.addSQLElement(RightSQLElement.class);
        return dir;
    }

    @Override
    protected SQLFilter createFilter() {
        return new SQLFilter(this.getDirectory(), this.getSystemRoot().getGraph().cloneForFilterKeep(Collections.<SQLField>emptySet()));
    }

    public final String getSocieteBaseName() {
        return this.getRowSociete().getString("DATABASE_NAME");
    }

    public final SQLRow getRowSociete() {
        return this.rowSociete;
    }

    public final int getSocieteID() {
        return this.idSociete;
    }

    protected final void setRowSociete(int id) {
        this.idSociete = id;
        this.rowSociete = this.getSystemRoot().findTable("SOCIETE_COMMON").getValidRow(this.getSocieteID());
    }

    public final SQLBase getSQLBaseSociete() {
        return this.getRootSociete().getBase();
    }

    public final DBRoot getRootSociete() {
        if (this.baseSociete == null) {
            this.baseSociete = this.createSQLBaseSociete();
        }
        return this.baseSociete;
    }

    private DBRoot createSQLBaseSociete() {
        DBSystemRoot b = this.getSystemRoot();
        String societeBaseName = this.getSocieteBaseName();
        b.getRootsToMap().add(societeBaseName);
        try {
            b.reload(Collections.singleton(societeBaseName));
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not access societe base", e);
        }
        b.prependToRootPath(societeBaseName);
        return b.getRoot(societeBaseName);
    }
}

