/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.search.SearchListComponent;
import org.openconcerto.ui.ContinuousButtonModel;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.ListChangeIndex;

public abstract class IListPanel
extends JPanel
implements ActionListener {
    private final IListe liste;
    protected final SQLElement element;
    protected final BtnTooltipMnger btnMngr;
    protected JButton buttonActualiser;
    boolean selectRowOnAdd = true;
    protected JButton buttonModifier;
    protected JButton buttonEffacer;
    protected JButton buttonAjouter;
    protected JButton buttonClone;
    protected JButton saveBtn;
    private JButton buttonPlus;
    private JButton buttonMoins;
    protected final JPanel searchPanel = new JPanel(new GridBagLayout());
    private static final Icon UP_ARROW = new ImageIcon(IListPanel.class.getResource("fleche_haut.png"));
    private static final Icon DOWN_ARROW = new ImageIcon(IListPanel.class.getResource("fleche_bas.png"));
    protected EditFrame createFrame;
    protected SearchListComponent searchComponent;

    public static final File getConfigFile(SQLElement elem, Class<? extends Container> c) {
        return IListPanel.getConfigFile(elem, c, null);
    }

    public static final File getConfigFile(SQLElement elem, Class<? extends Container> c, String variant) {
        String suffix = variant == null || variant.length() == 0 ? "" : "-" + variant;
        return new File(Configuration.getInstance().getConfDir(), "state-" + c.getSimpleName() + "-list" + File.separator + elem.getPluralName() + suffix + ".xml");
    }

    private static final JButton createBtn(Icon i) {
        JButton res = new JButton(i);
        res.setMargin(new Insets(1, 1, 1, 1));
        res.setModel(new ContinuousButtonModel(300));
        res.setBorder(null);
        res.setOpaque(false);
        res.setFocusPainted(true);
        res.setContentAreaFilled(false);
        return res;
    }

    public IListPanel(SQLElement elem) {
        this(elem, null);
    }

    public IListPanel(SQLElement elem, IListe list) {
        this(elem, list, null);
    }

    public IListPanel(SQLElement elem, IListe list, String variant) {
        this.element = elem;
        this.btnMngr = new BtnTooltipMnger();
        File config = IListPanel.getConfigFile(this.getElement(), this.getClass(), variant);
        if (list == null) {
            list = new IListe(this.getElement().getTableSource(), config);
        } else {
            if (list.getSource().getPrimaryTable() != elem.getTable()) {
                throw new IllegalArgumentException("Different tables : " + elem.getTable() + " != " + list.getSource().getPrimaryTable());
            }
            if (list.getConfigFile() == null) {
                list.setConfigFile(config);
            }
        }
        this.liste = list;
        final IClosure<ListChangeIndex<RowAction>> l = new IClosure<ListChangeIndex<RowAction>>(){

            @Override
            public void executeChecked(ListChangeIndex<RowAction> input) {
                for (RowAction rm : input.getItemsRemoved()) {
                    IListPanel.this.getListe().removeRowAction(rm);
                }
                for (RowAction added : input.getItemsAdded()) {
                    IListPanel.this.getListe().addRowAction(added);
                }
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    if (IListPanel.this.isDisplayable()) {
                        IListPanel.this.getListe().addRowActions(IListPanel.this.getElement().getRowActions());
                        IListPanel.this.getListe().addRowActionFactories(IListPanel.this.getElement().getRowActionFactories());
                        IListPanel.this.getElement().addRowActionsListener(l);
                    } else {
                        IListPanel.this.getElement().removeRowActionsListener(l);
                        IListPanel.this.getListe().removeRowActions(IListPanel.this.getElement().getRowActions());
                        IListPanel.this.getListe().removeRowActionFactories(IListPanel.this.getElement().getRowActionFactories());
                    }
                }
            }
        });
        this.init();
    }

    protected final void init() {
        this.uiInit();
        this.liste.addIListener(new IListener(){

            @Override
            public void selectionId(int id, int field) {
                IListPanel.this.listSelectionChanged(id);
            }
        });
        this.liste.addModelListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListPanel.this.searchComponent.reset((ITableModel)evt.getNewValue());
            }
        });
        this.btnMngr.updateBtns();
        this.getListe().selectID(-1);
    }

    private final void uiInit() {
        this.createUI();
        IListPanel container = this;
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = this.createConstraints();
        c.weighty = 1.0;
        container.add((Component)this.liste, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.insets = new Insets(4, 1, 2, 1);
        container.add((Component)this.getMiddlePanel(), c);
        this.addComponents(container, c);
        this.setOpaque(false);
    }

    protected GridBagConstraints createConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        return c;
    }

    protected void createUI() {
        this.setOpaque(false);
        this.buttonActualiser = new JButton(new ImageIcon(IListPanel.class.getResource("reload.png")));
        this.buttonActualiser.setBorderPainted(false);
        this.buttonActualiser.setFocusPainted(false);
        this.buttonActualiser.setOpaque(false);
        this.buttonActualiser.setContentAreaFilled(false);
        this.buttonActualiser.setMinimumSize(new Dimension(20, 20));
        this.buttonActualiser.setPreferredSize(new Dimension(20, 20));
        this.buttonActualiser.setMaximumSize(new Dimension(20, 20));
        this.searchComponent = new SearchListComponent(this.liste.getModel());
        this.searchComponent.setFormats(this.liste.getFormats());
        this.buttonModifier = new JButton("Modifier");
        this.buttonModifier.setOpaque(false);
        this.btnMngr.addBtn(this.buttonModifier, "de modifier", "UPDATE_ROW", true);
        this.buttonEffacer = new JButton("Effacer");
        this.buttonEffacer.setOpaque(false);
        this.btnMngr.addBtn(this.buttonEffacer, "d'effacer", "DELETE_ROW", true);
        this.buttonAjouter = new JButton("Ajouter");
        this.buttonAjouter.setOpaque(false);
        this.btnMngr.addBtn(this.buttonAjouter, "d'ajouter", "INSERT_ROW", false);
        this.buttonClone = new JButton("Dupliquer");
        this.buttonClone.setOpaque(false);
        this.btnMngr.addBtn(this.buttonClone, "de dupliquer", "INSERT_ROW", true);
        this.btnMngr.setOKToolTip(this.buttonClone, "<html>Permet de dupliquer une ligne.<br>Maintenir CTRL enfonc\u00e9 pour dupliquer \u00e9galement le contenu<br>Maintenir Maj. enfonc\u00e9 pour changer d'emplacement.</html>");
        this.saveBtn = new JButton(new ImageIcon(IListPanel.class.getResource("save.png")));
        this.saveBtn.setFocusPainted(false);
        this.saveBtn.setOpaque(false);
        this.saveBtn.setContentAreaFilled(false);
        this.saveBtn.setBorderPainted(false);
        this.saveBtn.setMinimumSize(new Dimension(20, 20));
        this.saveBtn.setPreferredSize(new Dimension(20, 20));
        this.saveBtn.setMaximumSize(new Dimension(20, 20));
        this.buttonMoins = IListPanel.createBtn(UP_ARROW);
        this.buttonPlus = IListPanel.createBtn(DOWN_ARROW);
        this.btnMngr.addBtn(this.buttonMoins, "de changer l'ordre", "UPDATE_ROW", false);
        this.btnMngr.addBtn(this.buttonPlus, "de changer l'ordre", "UPDATE_ROW", false);
        ITransformer<JButton, String> transf = new ITransformer<JButton, String>(){

            @Override
            public String transformChecked(JButton input) {
                boolean ok = IListPanel.this.getListe().hasSelection() && !IListPanel.this.getListe().isSorted();
                return input.getModel().isArmed() || ok ? null : "Pas de s\u00e9lection ou liste tri\u00e9e";
            }
        };
        this.btnMngr.setAdditional(this.buttonMoins, transf);
        this.btnMngr.setAdditional(this.buttonPlus, transf);
        this.searchPanel.setOpaque(false);
        this.getListe().addSortListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListPanel.this.updateOrderButtons();
            }
        });
        if (Boolean.getBoolean("org.openconcerto.listpanel.simpleui")) {
            this.setAdjustVisible(false);
            this.setSearchFullMode(false);
        } else {
            this.searchPanel.setBorder(BorderFactory.createEtchedBorder());
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 2, 0, 2);
        c.fill = 2;
        c.weightx = 0.0;
        JLabel label = new JLabel("Rechercher");
        label.setOpaque(false);
        this.searchPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.searchComponent.setOpaque(false);
        this.searchPanel.setOpaque(false);
        this.searchPanel.add((Component)this.searchComponent, c);
    }

    protected void addComponents(Container container, GridBagConstraints c) {
    }

    protected Object[] getMiddleCompsLayout() {
        JComponent[] comps = new JComponent[]{this.buttonPlus, this.buttonMoins, this.buttonActualiser, this.saveBtn, this.searchPanel, this.buttonAjouter, this.canClone() ? this.buttonClone : null, this.buttonModifier, this.buttonEffacer};
        return new Object[]{comps, this.searchPanel};
    }

    private boolean canClone() {
        String prop = System.getProperty("org.openconcerto.sql.canCloneInList", "");
        return Boolean.parseBoolean(prop) || SQLRow.toList(prop).contains(this.getElement().getTable().getName());
    }

    private final JPanel getMiddlePanel() {
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 2, 0, 2);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        Object[] middleCompsL = this.getMiddleCompsLayout();
        JComponent[] comps = (JComponent[])middleCompsL[0];
        JComponent largest = (JComponent)middleCompsL[1];
        int i = 0;
        while (i < comps.length) {
            JComponent component = comps[i];
            if (component != null) {
                c.weightx = component == largest ? 1 : 0;
                container.add((Component)component, c);
                if (component instanceof JButton) {
                    ((JButton)component).addActionListener(this);
                }
                ++c.gridx;
            }
            ++i;
        }
        container.setOpaque(false);
        return container;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.handleAction((JButton)e.getSource(), e);
    }

    private final int askSerious(Object msg, String title) {
        return JOptionPane.showConfirmDialog(this, msg, title, 0, 2);
    }

    private final JPanel createClonePanel(int selectedLines, boolean rec, SQLRequestComboBox combo) {
        String lines;
        boolean plural = selectedLines > 1;
        String string = lines = plural ? "ces " + selectedLines + " lignes" : "cette ligne";
        String recS = rec ? " et " + (plural ? "leurs contenus" : "son contenu") : "";
        String msg = "Voulez vous cloner " + lines + recS + " ?";
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(2, 2, 2, 2);
        p.add((Component)new JLabel(msg), c);
        if (combo != null) {
            c.gridx = 0;
            ++c.gridy;
            p.add((Component)new JLabel("Nouvel emplacement (optionnel) : "), c);
            ++c.gridy;
            combo.uiInit(this.getElement().getParentElement().getComboRequest());
            combo.setPreferredSize(new Dimension(600, combo.getPreferredSize().height));
            p.add((Component)combo, c);
        }
        return p;
    }

    protected void handleAction(JButton source, ActionEvent evt) {
        block24: {
            if (source == this.buttonMoins) {
                this.getListe().deplacerDe(-this.getInc(evt));
            } else if (source == this.buttonPlus) {
                this.getListe().deplacerDe(this.getInc(evt));
            } else if (source == this.buttonActualiser) {
                this.liste.update();
            } else if (source == this.buttonAjouter) {
                boolean deaf = this.isDeaf();
                int selectedId = this.getListe().getSelectedId();
                if (!deaf && this.selectRowOnAdd && selectedId >= 0) {
                    this.getCreateFrame().selectionId(selectedId);
                }
                FrameUtil.show(this.getCreateFrame());
            } else if (source == this.buttonClone) {
                SQLRequestComboBox combo;
                List<Integer> selectedIDs = this.getListe().getSelection().getSelectedIDs();
                boolean rec = (evt.getModifiers() & 2) != 0;
                boolean showParent = (evt.getModifiers() & 1) != 0;
                SQLRequestComboBox sQLRequestComboBox = combo = showParent && this.getElement().getParentElement() != null ? new SQLRequestComboBox() : null;
                if (this.askSerious(this.createClonePanel(selectedIDs.size(), rec, combo), "Duplication") == 0) {
                    SQLRow parent = combo == null ? null : combo.getSelectedRow();
                    for (int id : selectedIDs) {
                        SQLRow row = this.getElement().getTable().getRow(id);
                        try {
                            if (rec) {
                                this.getElement().copyRecursive(row, parent);
                                continue;
                            }
                            this.getElement().copy(row, parent);
                        }
                        catch (SQLException e) {
                            ExceptionHandler.handle(this, "Impossible de dupliquer " + row, e);
                        }
                    }
                }
            } else if (source == this.buttonEffacer) {
                this.getElement().askArchive((Component)this, this.getListe().getSelection().getSelectedIDs());
            } else if (source == this.saveBtn) {
                try {
                    Object[] options = new Object[]{"Tout", "S\u00e9lection", "Annuler"};
                    int answer = JOptionPane.showOptionDialog(this, "Exporter l'ensemble ou uniquement la s\u00e9lection de la liste ?", "Export de la liste", -1, 3, null, options, options[0]);
                    if (answer != 0 && answer != 1) break block24;
                    FileDialog fd = new FileDialog(SwingThreadUtils.getAncestorOrSelf(Frame.class, this), "Sauver la liste", 1);
                    XMLFormatVersion version = XMLFormatVersion.getDefault();
                    fd.setFile(String.valueOf(this.element.getPluralName().replace('/', '-')) + "." + ContentType.SPREADSHEET.getVersioned(version.getXMLVersion()).getExtension());
                    fd.setVisible(true);
                    if (fd.getFile() != null) {
                        File f = this.liste.exporter(new File(fd.getDirectory(), fd.getFile()), answer == 1, version);
                        int i = JOptionPane.showConfirmDialog(this, "La liste est export\u00e9e au format OpenOffice classeur\n D\u00e9sirez vous l'ouvrir avec OpenOffice?", "Ouvir le fichier", 0);
                        if (i == 0) {
                            OOUtils.open((File)f);
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(this, "Erreur lors de la sauvegarde", e);
                }
            } else {
                throw new IllegalStateException("button '" + source.getText() + "' not implemented");
            }
        }
    }

    protected boolean isDeaf() {
        return Boolean.getBoolean("org.openconcerto.sql.listPanel.deafEditPanel");
    }

    protected final EditFrame getCreateFrame() {
        if (this.createFrame == null) {
            this.createFrame = new EditFrame(this.element, EditPanel.CREATION);
            this.createFrame.getPanel().setIList(this.getListe());
            if (!this.isDeaf()) {
                this.liste.addIListener(this.createFrame);
            }
        }
        return this.createFrame;
    }

    protected void listSelectionChanged(int id) {
        this.btnMngr.updateBtns();
    }

    protected final void updateOrderButtons() {
        this.btnMngr.updateBtn(this.buttonMoins);
        this.btnMngr.updateBtn(this.buttonPlus);
    }

    public final IListe getListe() {
        return this.liste;
    }

    public final SQLElement getElement() {
        return this.element;
    }

    protected SQLComponent getSQLComponent() {
        return null;
    }

    @Override
    public void grabFocus() {
        this.liste.grabFocus();
    }

    private int getInc(ActionEvent evt) {
        int times = (int)evt.getWhen() - 3;
        return times < 2 ? 1 : (int)Math.pow(times, 2.0);
    }

    public void setAdjustVisible(boolean b) {
        this.liste.setAdjustVisible(b);
    }

    public void setSearchFullMode(boolean b) {
        if (b) {
            this.searchPanel.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.searchPanel.setBorder(null);
        }
        this.searchComponent.setSearchFullMode(b);
    }

    protected final class BtnTooltipMnger {
        private final Map<JButton, Tuple2<String, String>> code;
        private final Set<JButton> needSelection = new HashSet<JButton>();
        private final Map<JButton, ITransformer<JButton, String>> additional;
        private final Map<JButton, String> okTooltip;

        public BtnTooltipMnger() {
            this.code = new HashMap<JButton, Tuple2<String, String>>();
            this.additional = new HashMap<JButton, ITransformer<JButton, String>>();
            this.okTooltip = new HashMap<JButton, String>();
        }

        public void addBtn(JButton btn, String desc, String rightCode, boolean needSelection) {
            if (this.code.containsKey(btn)) {
                throw new IllegalStateException("already in");
            }
            this.code.put(btn, Tuple2.create(desc, rightCode));
            if (needSelection) {
                this.needSelection.add(btn);
            }
        }

        public void setAdditional(JButton btn, ITransformer<JButton, String> additional) {
            if (additional != null) {
                this.additional.put(btn, additional);
            } else {
                this.additional.remove(btn);
            }
        }

        public void setOKToolTip(JButton btn, String tooltip) {
            if (tooltip != null) {
                this.okTooltip.put(btn, tooltip);
            } else {
                this.okTooltip.remove(btn);
            }
        }

        void updateBtn(JButton btn) {
            if (!this.code.containsKey(btn)) {
                throw new IllegalArgumentException();
            }
            this.updateBtns(Collections.singleton(btn));
        }

        void updateBtns() {
            this.updateBtns(this.code.keySet());
        }

        private void updateBtns(Set<JButton> btns) {
            boolean hasSelection = IListPanel.this.getListe().getSelectedId() >= 0;
            UserRights rights = UserRightsManager.getCurrentUserRights();
            for (JButton btn : btns) {
                String tooltip;
                boolean ok;
                Tuple2<String, String> t = this.code.get(btn);
                if (!TableAllRights.hasRight(rights, t.get1(), IListPanel.this.getElement().getTable())) {
                    ok = false;
                    tooltip = "Vous n'avez pas le droit " + t.get0();
                } else if (this.needSelection.contains(btn) && !hasSelection) {
                    ok = false;
                    tooltip = "Aucune s\u00e9lection";
                } else if (this.additional.containsKey(btn)) {
                    tooltip = this.additional.get(btn).transformChecked(btn);
                    ok = tooltip == null;
                } else {
                    ok = true;
                    tooltip = this.okTooltip.get(btn);
                }
                btn.setToolTipText(tooltip);
                btn.setEnabled(ok);
            }
        }
    }
}

